local mission = {}

local function LoadCaptureParams()
  mission.capture2 = Game:GetEntity('CapturePosition2'):GetPosition()
  mission.capture3 = Game:GetEntity('CapturePosition3'):GetPosition()
  mission.capture4 = Game:GetEntity('CapturePosition4'):GetPosition()
  mission.radius2 = 5700
  mission.radius3 = 5700
  mission.radius4 = 2200
end

local function CheckCapture2()
  local hall = Game:GetEntity('P1-thallT-L3-0') 
  local bar = Game:GetEntity('P1-barracksT-L3-0')
  if not hall and not bar then
    --Debug:Log('Townhall and Barracks were destroyed')
    --Debug:Log('Enemy Fortification has been captured')
    mission.player:SwitchOwnershipInRadius(mission.capture2, mission.radius2, mission.enemyIndex, mission.playerIndex)
    mission.player:SwitchOwnershipInRadius(mission.capture3, mission.radius3, mission.enemyIndex, mission.playerIndex)
    for i=1,11,1 do
      local tower = 'towerT-'..i
      local wall = 'wall-'..i
      local ent1 = Game:GetEntity(tower)
      local ent2 = Game:GetEntity(wall)
      if ent1 then
        mission.player:SwitchOwnership(ent1, mission.playerIndex)
      end
      if ent2 then
        mission.player:SwitchOwnership(ent2, mission.playerIndex)
      end
    end
    local g1 = Game:GetEntity('gate-1')
    local g2 = Game:GetEntity('gate-2') 
    if ent1 then
        mission.player:SwitchOwnership(g1, mission.playerIndex)
      end
      if ent2 then
        mission.player:SwitchOwnership(g2, mission.playerIndex)
      end
      for i=1,5,1 do
        local name = 'YCapture'..i
        local ent1 = Game:GetEntity(name)
          if ent1 then
            mission.player:SwitchOwnership(ent1, mission.playerIndex)
          end
    end
    mission.player:WinQuest('M10_Town2')
    mission.player:AddResource(0, 1000)
    mission.player:AddResource(1, 1500)
    mission.player:AddResource(2, 1000)
    mission.player:AddResource(3, 1500)
    mission.player:AddResource(4, 500)
    mission.player:AddResource(5, 500)
    mission.player:AddResource(6, 500)
    mission.player:AddResource(7, 500)
    G.capture2_done = true
  end
end

local function init(self)
  Debug:Log('Capture Script: Init Started')
  mission.playerIndex = 0
  mission.enemyIndex = 1
  mission.player = Citadels.GetPlayer(mission.playerIndex)
  mission.enemy = Citadels.GetPlayer(mission.enemyIndex)
  mission.enemy:SetPopulationLimit(60)
  
  if not mission.player or not mission.enemy then
    Debug:Log('Cannot find players')
    return
  end
  mission.timer_default = 3
  mission.timer = mission.timer_default
  LoadCaptureParams()
  self.init_done = true
  Debug:Log('Capture Script: Init Finished')
end

function OnThink(self)
	  -- do init first
  if not self.init_done then
    init(self)
  end
  
  if G.capture2_done then
    return
  end
  
  local dt = Timer:GetTimeDiff()
  mission.timer = mission.timer - dt
  if mission.timer <= 0 then
    CheckCapture2()
    mission.timer = mission.timer_default
  end
end
