local mission = {}

local function LoadCaptureParams()
  mission.capture1 = Game:GetEntity('CapturePosition1'):GetPosition()
  mission.capture2 = Game:GetEntity('CapturePosition2'):GetPosition()
  mission.capture3 = Game:GetEntity('CapturePosition3'):GetPosition()
  mission.capture4 = Game:GetEntity('CapturePosition4'):GetPosition()
  mission.radius1 = 3500
  mission.radius2 = 5200
  mission.radius3 = 5100
  mission.radius4 = 2200
end

local function CheckCapture1()
  local my = mission.player:UnitsInRadiusNumberByKey(mission.capture1, mission.radius1, '*')
  local their = mission.enemy:UnitsInRadiusNumberByKey(mission.capture1, mission.radius1, '*')
  their = their * 2
  if my > their then
    Debug:Log('Enemy Fortification has been captured')
    mission.player:SwitchOwnershipInRadius(mission.capture1, mission.radius1, mission.enemyIndex, mission.playerIndex)
    mission.player:WinQuest('M10_Town1')
    G.capture1_done = true
  end
end

local function init(self)
  Debug:Log('Capture Script: Init Started')
  mission.playerIndex = 0
  mission.enemyIndex = 1
  mission.player = Citadels.GetPlayer(mission.playerIndex)
  mission.enemy = Citadels.GetPlayer(mission.enemyIndex)
  mission.timer_default = 3
  mission.timer = mission.timer_default
  LoadCaptureParams()
  self.init_done = true
  Debug:Log('Capture Script: Init Finished')
end

function OnThink(self)
	  -- do init first
  if not self.init_done then
    init(self)
  end
  
  if G.capture1_done then
    return
  end
  
  local dt = Timer:GetTimeDiff()
  mission.timer = mission.timer - dt
  if mission.timer <= 0 then
    CheckCapture1()
    mission.timer = mission.timer_default
  end
end
