--[[
script checks for capturing new
villages and fortifications
]]--

local mission = {}

local function CheckEndMission()
 -- if not G.capture2_done then return end
  --if not G.capture3_done then return end
  local c = Game:GetEntity('castleC')
  if c then return end
  Citadels.SetAchievementDone(7)
  mission.player:WinQuest('M10_Castle')
  Citadels.ForceVictory()
end

local function init(self)
  Debug:Log('Capture Script: Init Started')
  mission.playerIndex = 0
  mission.enemyIndex = 1
  mission.player = Citadels.GetPlayer(mission.playerIndex)
  mission.enemy = Citadels.GetPlayer(mission.enemyIndex)
  mission.timer_default = 2
  	mission.timer = mission.timer_default
  if not self.load then
	G.capture2_done = false
	G.capture3_done = false
	mission.player:AddQuest('M10_Town2', 'side')
	mission.player:SetQuestPosition('M10_Town2', -22299,2415)
	mission.player:AddQuest('M10_Town3', 'side')
	mission.player:SetQuestPosition('M10_Town3', 14270,22861)
	mission.player:AddQuest('M10_Castle', 'main')
	mission.player:SetQuestPosition('M10_Castle', -8651,-19882)
  end
  self.init_done = true
  Debug:Log('Capture Script: Init Finished')
end

function OnThink(self)
	  -- do init first
  if not self.init_done then
    init(self)
  end
  local dt = Timer:GetTimeDiff()
  mission.timer = mission.timer - dt
  if mission.timer <= 0 then
    CheckEndMission()
    mission.timer = mission.timer_default
  end
end

function OnSerialize(self, ar)
	if (ar:IsLoading()) then
     if not Citadels.GetLoadGameRunning() then return end
     Debug:Log('lua: Script Load Start')
	 G.capture2_done = ar:Read()
	 G.capture3_done = ar:Read()
     Debug:Log('lua: Script Load End')
	  self.load = true
   else
     Debug:Log('lua: Script Save Start')
     ar:Write(G.capture2_done)
	 ar:Write(G.capture3_done)
     Debug:Log('lua: Script Save End')
   end
end
