--[[
script generates army
for the enemy randomly in all spawnpositions
]]--

local mission = {}
local units = {}

local function LoadUnitsParams()
  units[1] = 'unit_D_fman_L3'
  units[2] = 'unit_D_rider_L2'
  units[3] = 'unit_D_archer_L2'
  units[4] = 'unit_D_archer_L3'
  units[5] = 'unit_D_ballista_L2'
  units[6] = 'unit_D_catapult_L2'
end

local function LoadSpawnPoints()
  mission.spawns = {}
  for i=1,mission.spawns_count,1 do
    local name = string.format('ArmyPosition%0.f', i)
    local ent = Game:GetEntity(name)
    if not ent then
      Debug:Log('Cannot find '..name)
      return
    end
    mission.spawns[i] = ent:GetPosition()
  end
end

local function GenerateSpawnPoint()
  local r = math.random(1, mission.spawns_count)
  return mission.spawns[r]
end

local function GenerateUnitPrefab()
  --local r = math.random(1, mission.units_count)
  mission.position = mission.position + 1
  if mission.position > mission.spawns_count then
      mission.position = 1
  end
  return units[mission.position]
end

local function GenerateArmy()
  mission.generated_index = mission.generated_index + 1
  local target = GenerateSpawnPoint()
  local unit = GenerateUnitPrefab()
  local unitposition = mission.enemy:GetFreePosition(target, 3000, 100)
  local name = mission.name..mission.generated_index
  Debug:Log('ArmyGenerator: Generating unit >> '..unit)
  mission.enemy:createUnit(mission.spawn, mission.enemyIndex, 2, unit, name)
  mission.enemy:Deselect()
  mission.enemy:SelectUnitsByName(name)
  mission.enemy:SetDefensive()
  mission.enemy:Move(target)
  if mission.generated_index == 20 then
    mission.timer_default = 30
    return
  end
  if mission.generated_index == 40 then
    mission.timer_default = 60
    return
  end
  if mission.generated_index == 50 then
    mission.timer_default = 120
    return
  end
end

local function init(self)
  Debug:Log('ArmyGenerator: Init Started')
  mission.playerIndex = 0
  mission.enemyIndex = 1
  mission.player = Citadels.GetPlayer(mission.playerIndex) -- my player
  mission.enemy = Citadels.GetPlayer(mission.enemyIndex) -- enemy player
  if not mission.player or not mission.enemy then
    Debug:Log('Cannot find players')
    return
  end
  if not self.load then
	mission.timer_default = 20 * (2 - mission.player:GetDifficultyCoef())
	mission.timer =  mission.timer_default
	mission.generated_index = 0
  end
  mission.spawns_count = 5
  mission.units_count = 6
  mission.name = 'enemy_army_'
  mission.position = 1
  local ent = Game:GetEntity('ArmyGenerator')
  if not ent then
    Debug:Log('Cannot find ArmyGenerator')
    return
  end
  mission.spawn = ent:GetPosition()
  LoadUnitsParams()
  LoadSpawnPoints()
  self.init_done = true
  Debug:Log('ArmyGenerator: Init Finished')
end

function OnThink(self)
  -- do init first
  if not self.init_done then
    init(self)
  end

  local dt = Timer:GetTimeDiff()
  mission.timer = mission.timer - dt
	if mission.timer <= 0 then
    GenerateArmy()
    mission.timer =  mission.timer_default
	end
end

function OnSerialize(self, ar)
	if (ar:IsLoading()) then
     if not Citadels.GetLoadGameRunning() then return end
     Debug:Log('lua: Script Load Start')
     mission.generated_index = ar:Read()
	 mission.timer_default = ar:Read()
	 mission.timer = ar:Read()
     Debug:Log('Script Load End')
	  self.load = true
   else
     Debug:Log('lua: Script Save Start')
     ar:Write(mission.generated_index)
     ar:Write(mission.timer_default)
     ar:Write(mission.timer)
     Debug:Log('Script Save End')
   end
end
