local mission = {}
local q1 = {}
local q2 = {}
local q3 = {}
local q4 = {}
local q5 = {}
local q6 = {}
local q9 = {}

local save_thinks = {}
local save_counter = 1
local load = false
local player0 = nil

local function ShowMark(pos, markKey, size)
	-- Vision.VColorRef(0x82, 0xff, 0) - color from LukasP, too bright
	local m = Citadels.CreateMarkEntity("textures\\mission_target.dds", pos, size or 1200, 0, markKey, Vision.VColorRef(0x41, 0x80, 0))
	if m then
		m:SetPulsing(0.02)
	end
end

local function HideMark(markKey)
	e = Game:GetEntity(markKey)
	if e then
		e:FadeOut()
	end
end

local function DestroyMark(markKey)
	Citadels.Remove(markKey)
	
	-- e = Game:GetEntity(markKey)
	-- if e then
	-- 	e:Remove()
	-- else
	-- 	Debug:Log('DestroyMark: object not found : '..(markKey or 'nil'))
	-- end
	
end



local function LoadEntities()
  q1.position = Game:GetEntity('P0-townhall-L1'):GetPosition()
  q1.radius = 2000
  q2.position = Game:GetEntity('RiverPosition'):GetPosition()
  q2.radius = 2000
  q6.position1 = Game:GetEntity('TowerPosition1'):GetPosition()
  q6.position2 = Game:GetEntity('TowerPosition2'):GetPosition()
  q6.radius = 2400
  q9.attack_position = Game:GetEntity('AttackPosition'):GetPosition()
end

local function Think_15()
  -- nothing to do here
end

local function Think_14()
  -- build army
  if player0:UnitsNumber('unit_L_catapult_L1') < 2 then
    return
  end
  player0:WinQuest('M01_14')
  save_counter = 15
  mission.thinkFunction = Think_15
end

local function Think_13()
  -- build siege workshop
  if player0:BuildingBuilt('bld_L_siege_L1') then
    player0:WinQuest('M01_13')
    save_counter = 14
    mission.thinkFunction = Think_14
  end
end

local function Think_12()
  if player0:GetResource(4) < 20 then return end
  if player0:GetResource(5) < 20 then return end
  player0:WinQuest('M01_12')
		  player0:RemoveQuest('M01_11')
		  player0:RemoveQuest('M01_12')
    player0:AddQuest('M01_13', 'side')
    player0:AddQuest('M01_14', 'side')
  save_counter = 13
  mission.thinkFunction = Think_13
end

local function Think_11()
  if not player0:BuildingBuilt('bld_L_lmill_L1') then return end
  if not player0:BuildingBuilt('bld_L_blacksmith_L1') then return end
  player0:WinQuest('M01_11')
  save_counter = 12
  mission.thinkFunction = Think_12
end

local function Think_9()
  if not q9.sent then
    player1:Deselect()
    player1:SelectUnitsByName('P1-attack')
    player1:SetAggressive()
    player1:Move(q9.attack_position)
	  q9.sent = true
	return
  end
  local live = player1:UnitGroupLives('P1-attack')
  if not live then
      player0:WinQuest('M01_09')
	  player0:RemoveQuest('M01_07')
	  player0:RemoveQuest('M01_08')
	  player0:RemoveQuest('M01_09')
      player0:AddQuest('M01_11', 'side')
      player0:AddQuest('M01_12', 'side')
      save_counter = 11
      mission.thinkFunction = Think_11
  end
end

local function Think_8()
  -- garrison not allowed any more, upgrade townhall
  if player0:BuildingBuilt('bld_L_thall_L2') then
    player0:WinQuest('M01_08')
    player0:AddQuest('M01_09', 'side')
    save_counter = 10
    mission.thinkFunction = Think_9
  end
end

local function Think_7()
  if player0:UnitsNumber('unit_L_fman_L1') < 9 then
    return
  end
  if player0:UnitsNumber('unit_L_archer_L1') < 9 then
    return
  end
    player0:WinQuest('M01_07')
    player0:RemoveQuest('M01_06a')
	  player0:RemoveQuest('M01_06b')
	  player0:RemoveQuest('M01_06c')
	player0:AddQuest('M01_08', 'side')
    save_counter = 9
    mission.thinkFunction = Think_8
end

local function Think_6c()
  if player0:MoatBuilt() then
    player0:WinQuest('M01_06c')
    player0:AddQuest('M01_07', 'side')
    save_counter = 8
    mission.thinkFunction = Think_7
  end
end

local function Think_6b()
  --local p1 = player0:BuildingsInRadiusNumber(q6.position1, q6.radius, 'bld_L_wall_L1')
  --local p2 = player0:BuildingsInRadiusNumber(q6.position2, q6.radius, 'bld_L_wall_L1')
  --if (p1 + p2) > 0 then
  local b = player0:BuildingBuilt('bld_L_wall_L1')
  if b then
    player0:WinQuest('M01_06b')
    player0:AddQuest('M01_06c', 'side')
     save_counter = 7
    mission.thinkFunction = Think_6c
  end
end

local function Think_6a()
  local p1 = player0:BuildingsInRadiusNumber(q6.position1, q6.radius, 'bld_L_tower_L1')
  --local p2 = player0:BuildingsInRadiusNumber(q6.position2, q6.radius, 'bld_L_tower_L1')
  --local b = player0:BuildingBuilt('bld_L_tower_L1')
  --if (p1 + p2) > 0 then
  if p1 > 0 then
    player0:WinQuest('M01_06a')
     player0:RemoveQuest('M01_05a')
     player0:RemoveQuest('M01_05b')
     save_counter = 6
    mission.thinkFunction = Think_6b
    HideMark('__mark_2')
  end
end

local function Think_5b()
  if player0:GetResource(0) < 100 then return end
  if player0:GetResource(1) < 100 then return end
  if player0:GetResource(2) < 100 then return end
  if player0:GetResource(3) < 100 then return end
  player0:WinQuest('M01_05b')
  player0:AddQuest('M01_06a', 'side')
  player0:AddQuest('M01_06b', 'side')
  player0:SetQuestPosition('M01_06a', q6.position1.x,q6.position1.y)
  player0:SetQuestPosition('M01_06b', q6.position1.x,q6.position1.y)
  save_counter = 5
  mission.thinkFunction = Think_6a
  ShowMark(q6.position1, '__mark_2', q6.radius + 50)
end

local function Think_5a()
  if not player0:BuildingBuilt('bld_L_lumber_L1') then return end
  if not player0:BuildingBuilt('bld_L_farm_L1') then return end
  if not player0:BuildingBuilt('bld_L_iron_L1') then return end
  if not player0:BuildingBuilt('bld_L_stone_L1') then return end
  player0:WinQuest('M01_05a')
  player0:RemoveQuest('M01_01')
  player0:RemoveQuest('M01_04')
  save_counter = 4
  mission.thinkFunction = Think_5b
end

local function Think_4()
  if player0:BuildingBuilt('bld_L_house_L1') then
    player0:WinQuest('M01_04')
    player0:AddQuest('M01_05a', 'side')
    player0:AddQuest('M01_05b', 'side')
    save_counter = 3
    mission.thinkFunction = Think_5a
  end
end

local function Think_1()
	if not player0:UnitGroupLives('Peasant') and player0:UnitsNumber('unit_L_peasant_L*') == 0 then
		player0:FailQuest('M01_01')
		player0:FailQuest('M01_15')
		Citadels.ForceDefeat()
	end
  local s = player0:SomeUnitsInRadius(q1.position, q1.radius, 'unit_L_peasant_L*')
  if s then
	HideMark('__mark_1')
   player0:WinQuest('M01_01')
   player0:AddQuest('M01_04', 'side')
   player0:SetGeneratePeasantsInTownhall(true)
    save_counter = 2
   mission.thinkFunction = Think_4
  end
end

function OnThink(self)
  if not self.init_done then
    Debug:Log('Main Script: Init Start')
    player0 = Citadels.GetPlayer(0)
    player1 = Citadels.GetPlayer(1)
    LoadEntities()
    player1:SetPopulationLimit(40)
    if not self.load then
	  Debug:Log('You should not SEE THIS IF LOAD GAME')
      mission.timer_default = 2
      mission.timer = mission.timer_default
      q9.send = false
      G.house_destroyed = false
      player0:SetGeneratePeasantsInTownhall(false)
      save_counter = 1
      mission.thinkFunction = Think_1
      player0:AddQuest('M01_01', 'side')
      player0:SetQuestPosition('M01_01', q1.position.x, q1.position.y-200)
      player0:AddQuest('M01_15', 'main')
      player0:SetQuestPosition('M01_15', -9530, 11100)
      ShowMark(q1.position - Vision.hkvVec3(0,200,0), '__mark_1', q1.radius + 50)
      --ShowMark(q1.position - Vision.hkvVec3(-1000,1000,0), '__mark_1', q1.radius);
    else
		-- set peasants generation from load
		if save_counter == 1 then
			player0:SetGeneratePeasantsInTownhall(false)
		else
			player0:SetGeneratePeasantsInTownhall(true)
     end
	end
    player0:SetQuestPanelVisibility(true)
    Debug:Log('Main Script: Init End')
    load = false
    self.init_done = true
    
    -------- Mark entity test - how to use
    --local e
    --e = Game:GetEntity('MultiPosition')
    --if e then
	--	local pos = e:GetPosition()
	--	Citadels.CreateMarkEntity("textures\\mission_target.dds", pos, 1200, 0, "__target1", Vision.VColorRef(0x82, 0xff, 0))
	--end
	--
	--e = Game:GetEntity('__target1')
	--if e then
	--	e:FadeOut()
	--end
    --------
  end

  local dt = Timer:GetTimeDiff()
  mission.timer = mission.timer - dt
  if mission.timer <= 0 then
    mission.timer = mission.timer_default
    mission.thinkFunction()
  end
end

local function SetThinks()
  save_thinks[15] = Think_15
  save_thinks[14] = Think_14
  save_thinks[13] = Think_13
  save_thinks[12] = Think_12
  save_thinks[11] = Think_11
  save_thinks[10] = Think_9
  save_thinks[9] = Think_8
  save_thinks[8] = Think_7
  save_thinks[7] = Think_6c
  save_thinks[6] = Think_6b
  save_thinks[5] = Think_6a
  save_thinks[4] = Think_5b
  save_thinks[3] = Think_5a
  save_thinks[2] = Think_4
  save_thinks[1] = Think_1
end

function OnSerialize(self, ar)
	if (ar:IsLoading()) then
     if not Citadels.GetLoadGameRunning() then return end
     --local s = ar:Read()
     Debug:Log('Script Load Start')
     SetThinks()
     mission.timer_default = ar:Read()
     mission.timer = ar:Read()
     q9.send = ar:Read()
     G.house_destroyed = ar:Read()
     save_counter = ar:Read()
     mission.thinkFunction = save_thinks[save_counter]
          
	 Debug:Log('Script Load End')
     self.load = true
   else
     --ar:Write("Hello, Lua")
     Debug:Log('Script Save Start')
     ar:Write(mission.timer_default)
     ar:Write(mission.timer)
     ar:Write(q9.send)
     ar:Write(G.house_destroyed)
     ar:Write(save_counter)
     Debug:Log('Script Save End')
   end
end
