local mission = {}
local eventIndex = 1
local eventTime = 0

local function player_addEvent(player, waitT, fn)
	table.insert(player.events, {t=waitT,handler=fn})
end

local function think(player)
	local dt = Timer:GetTimeDiff()
	if #player.events >= eventIndex then
		local r = player.events[eventIndex]
		r.t = r.t - dt
		eventTime = r.t
		if r.t <= 0 then
			r.handler(player)
			--table.remove(player.events, 1)
			eventIndex = eventIndex + 1 -- use another event
			if #player.events >= eventIndex then -- just to be sure u have time for right eventIndex
				r = player.events[eventIndex]
				eventTime = r.t
			end
		end
	end
end

local function init(player)
	--local enemy = player:GetEnemy(0)
	--if not enemy then
	--	return
	--end
	--local enemyPos = enemy:GetPosition()
	local playerPos = player:GetPosition()

	--local rallyPoint = (enemyPos + playerPos) * 0.5
    player:AISetAutoMode(true)
    player:AISetEverythingVisible(true)
    
    --player:AIDestroyFortifications()
    --player:AIIgnoreUnits('unit_D_archer_L1', true); -- left all predefined units intact
    --player:AIIgnoreUnits('unit_D_fman_L1', true); -- left all predefined units intact
    --ai left all nonpeasant units with set object key intact !!!!

	player.t = 0
	player.events = {}
	player.addEvent = player_addEvent
    
	player:addEvent(4, function()   --after 4 seconds
        player:AISetupGathering(7, 50,0)      --wheat
		player:AISetupGathering(5, 50,1)      --wood
        player:AISetupGathering(5, 50,2)      --stone
        player:AISetupGathering(5, 50,3)      --iron

        --player:AISetupGuards('unit_L_archer_L1', 5, false, 30)
	end)
    
    player:addEvent(1, function()
		player:AISetupGuards('unit_D_fman_L1', 15, false, 30) --archers on the ground
	end)
    
    player:addEvent(120, function() --after next 120 seconds
		player:AISetupGathering(3, 40,5)    --planks
		player:AISetupGathering(3, 40,7)    --weapons
	end)
    
    player:addEvent(120, function() --after next 120 seconds
		Debug:Log('Ai Script: Rebuilding fortifications started')
		player:AIRebuildFortifications()
	end)

end

function OnThink(self)
    if not self.init_done then
		mission.enemy = Citadels.GetPlayer(1)
		Debug:Log('Ai Script: Init Start')
		init(mission.enemy)
		if self.load and #mission.enemy.events >= eventIndex then
			mission.enemy.events[eventIndex].t = eventTime -- restore time
		end
		self.init_done = true
  end
  think(mission.enemy)
end

function OnSerialize(self, ar)
	if (ar:IsLoading()) then
     if not Citadels.GetLoadGameRunning() then return end
     --local s = ar:Read()
     Debug:Log('Script Load Start')
	 eventIndex = ar:Read()
	 eventTime = ar:Read()
	 Debug:Log('Script Load End')
     self.load = true
   else
	Debug:Log('Script Save Start')
	ar:Write(eventIndex)
	ar:Write(eventTime)
    Debug:Log('Script Save End')
   end
end