﻿local mission = {}
local eventIndex = 1
local eventTime = 0

local function player_addEvent(player, waitT, fn)
	table.insert(player.events, {t=waitT,handler=fn})
end

local function think(player)
	local dt = Timer:GetTimeDiff()
	if #player.events >= eventIndex then
		local r = player.events[eventIndex]
		r.t = r.t - dt
		eventTime = r.t
		if r.t <= 0 then
			r.handler(player)
			--table.remove(player.events, 1)
			eventIndex = eventIndex + 1 -- use another event
			if #player.events >= eventIndex then -- just to be sure u have time for right eventIndex
				r = player.events[eventIndex]
				eventTime = r.t
			end
		end
	end
end

local function init(player)
	--local enemy = player:GetEnemy(0)
	--if not enemy then
	--	return
	--end
	--local enemyPos = enemy:GetPosition()
	local playerPos = player:GetPosition()

	--local rallyPoint = (enemyPos + playerPos) * 0.5
    player:AISetAutoMode(true)
    player:AISetEverythingVisible(true)

	player.t = 0
	player.events = {}
	player.addEvent = player_addEvent
    
	player:addEvent(4, function()
        player:AISetupGathering(3, 50,0)      --wheat
		player:AISetupGathering(3, 50,1)      --wood
        player:AISetupGathering(3, 50,2)      --stone
        player:AISetupGathering(3, 50,3)      --iron

        --player:AISetupGuards('unit_L_archer_L1', 5, false, 30)
	end)
    
    player:addEvent(20, function()
		player:AttackGroupAdd('unit_L_archer_L1', 5)
		player:AttackGroupCommit(2, playerPos,20)
	end)


    player:addEvent(120, function()
		player:AISetupGathering(3, 40,4)    --stone block
        player:AISetupGathering(3, 40,5)    --planks
        player:AISetupGathering(3, 40,6)    --bread
        player:AISetupGathering(3, 40,7)    --weapons
	end)
    
    player:addEvent(120, function()
		player:AISetupGuards('unit_L_fman_L1', 20, false, 30)
	end)
    
    player:addEvent(200, function()
		player:AttackGroupAdd('unit_L_fman_L1', 5)
		player:AttackGroupAdd('unit_L_archer_L1', 5)
		player:AttackGroupCommit(2, playerPos,20)
	end)
    
    player:addEvent(140, function()
		player:AISetupGuards('unit_L_archer_L1', 20, false, 30)
	end)
    
    player:addEvent(120, function()
		player:AISetupGuards('unit_L_fman_L1', 20, false, 30)
	end)
    
    player:addEvent(360, function()
		player:AISetupGuards('unit_L_catapult_L1', 20, false, 30)
	end)
    
    player:addEvent(400, function()
		player:AttackGroupAdd('unit_L_fman_L1', 5)
		player:AttackGroupAdd('unit_L_archer_L1', 5)
		player:AttackGroupCommit(2, playerPos,20)
	end)
    
    player:addEvent(520, function()
		player:AttackGroupAdd('unit_L_fman_L1', 15)
		player:AttackGroupAdd('unit_L_archer_L1', 15)
		player:AttackGroupAdd('unit_L_catapult_L1', 4)
		player:AttackGroupCommit(10, playerPos,20)
	end)    
	
end

function OnThink(self)
    if not self.init_done then
    mission.enemy = Citadels.GetPlayer(1)
    
    Debug:Log('generated...')
    init(mission.enemy)
    if self.load and #mission.enemy.events >= eventIndex then
			mission.enemy.events[eventIndex].t = eventTime -- restore time
		end
    
    self.init_done = true
  end
  think(mission.enemy)
end

function OnSerialize(self, ar)
    local arVersion = 1
	if (ar:IsLoading()) then
     if not Citadels.GetLoadGameRunning() then return end
     --local s = ar:Read()
     Debug:Log('Script Load Start')
     local ver = ar:Read()
	 eventIndex = ar:Read()
	 eventTime = ar:Read()
	 Debug:Log('Script Load End')
     self.load = true
   else
	Debug:Log('Script Save Start')
    ar:Write(arVersion)
	ar:Write(eventIndex)
	ar:Write(eventTime)
    Debug:Log('Script Save End')
   end
end