function OnCreate(self)
  self:AddTriggerSource("Reservoir")
end

function OnAfterSceneLoaded(self)
  Debug:Enable(true)
  self.Ascending = false -- set to true if you want to enable water rising
  self.Multiplier = 1.0
  
  self.Reservoir:LinkToTarget("Waterfall")
  self.Reservoir:LinkToTarget("River")
end

function OnThink(self)
  local timeDiff = Timer:GetTimeDiff()
    
  -- raise water level...
  if self.Ascending then
    Debug:PrintLine("Ascending")
    self.positionZ = self:GetPosition().z
    Debug:PrintLine("Position z = " .. self.positionZ)
    
    --if self.positionZ < refLevel then
    if self.positionZ < 310 then
      self:IncPosition(0,0,timeDiff*8)
    else
      --Debug:PrintLine("Position z = " .. self.positionZ)
      self.Ascending = false
    end
    
  end
end
