-- new script file

local SPEED = 1.0 / 2400
local TIME_START = 0
local TIME_END = 1

function OnUpdateSceneBegin(self)
    Debug:Enable(true)
	
    local handler = Renderer:GetTimeOfDayHandler()
    if handler then
      local dt = Timer:GetTimeDiff()
      local t = handler:GetDayTime()
    
      if t < 0.25 or t > 0.87 then
        -- night speed is faster
        t = t + dt  * SPEED * 4
      else
        -- day speed is normal
        t = t + dt  * SPEED
      end
      
      if t > TIME_END then
        t = t - TIME_END + TIME_START
      end
      
      handler:SetDayTime(t)
      --Debug:PrintLine("Current time: " .. t)
    end

end

function OnAfterSceneLoaded(self)
  local handler = Renderer:GetTimeOfDayHandler()
  if handler then
    handler:SetDayTime(0.545)
  end
end
