function OnAfterSceneLoaded(self)
  Debug:Enable(true)
  Input:SetKeyAsSingleHit(Vision.KEY_PAGEDOWN)
  Input:SetKeyAsSingleHit(Vision.KEY_PAGEUP)
  self.Ascending = false -- set to true if you want to enable water rising
end

function OnThink(self)
  if not self.wasInit then
    self.wasInit = true
    self:AddTriggerSource("reservoir")
    
    self.reservoir:LinkToTarget("river")
    self.reservoir:LinkToTarget("waterfall")
    self.reservoir:LinkToTarget("plane")
  end
  
  if Input:IsKeyPressed(Vision.KEY_PAGEUP) then
    self.Ascending = true
  end
  if Input:IsKeyPressed(Vision.KEY_PAGEDOWN) then
    self.Ascending = false
  end
  
  local timeDiff = Timer:GetTimeDiff()
  self.positionZ = self:GetPosition().z
  --Debug:PrintLine("Z = " .. self.positionZ)
    
  -- raise water level...
  if self.Ascending then
        
    if self.positionZ < 370 then
      self:IncPosition(0,0,timeDiff*18)
    else
      self.reservoir:TriggerAllTargets()
      self.Ascending = false
    end
    
  end
end

