struct VS_OUTPUT
{
    float4	Pos: POSITION;
    float4	Diff: COLOR0;
	float4	Tex0: TEXCOORD0;
	float4	Tex1: TEXCOORD1;
	float4	Tex2: TEXCOORD2;
};


texture MaskTexture;
sampler MaskTextureSampler = sampler_state {
    Texture   = <MaskTexture>;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
    MipFilter = LINEAR;
    MaxAnisotropy = 8;
	AddressU  = CLAMP;
	AddressV  = CLAMP;
	AddressW  = CLAMP;
};


texture WaveTexture;
sampler WaveTextureSampler = sampler_state {
    Texture   = <WaveTexture>;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
    MipFilter = LINEAR;
    MaxAnisotropy = 8;
	AddressU  = WRAP;
	AddressV  = WRAP;
	AddressW  = WRAP;
};


texture ReflectionTexture;
sampler ReflectionTextureSampler = sampler_state {
    Texture   = <ReflectionTexture>;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
    MipFilter = LINEAR;
    MaxAnisotropy = 8;
	AddressU  = BORDER;//WRAP;
	AddressV  = BORDER;//WRAP;
	AddressW  = BORDER;//WRAP;
};



float4	Viewport;			// .x => MinX, .y => MinY, .z => Width, .w => Height
float	DistTexelWidth;
float	DistTexelHeight;

float2	TexOff0;
float	TexScale0;
float2	TexOff1;
float	TexScale1;

float	ScaleFactor1=1.5;
float	ScaleFactor2=1.5*8.0;

float	SpecSize=0.5;
float	SpecIntensity=1.0;
float3	SpecColor=float3(1, 1, 1);

float4 WaterPS(VS_OUTPUT pixel) : COLOR
{
	float2	texd;
	float4	texdoff;
	float2	dist;
	float2	dist1;
	float2	dist2;
	float4	col;

	texd.x=ScaleFactor1*(pixel.Tex1.z-pixel.Tex1.x)/pixel.Tex1.w;
	texd.y=(ScaleFactor2-pixel.Tex1.y)/pixel.Tex1.w;
	texdoff=float4(texd.x-DistTexelWidth, texd.x+DistTexelWidth, texd.y-DistTexelHeight, texd.y+DistTexelHeight);

	dist1.x=tex2D(WaveTextureSampler, float2(texdoff.x, texd.y)+TexOff0).r;
	dist1.x-=tex2D(WaveTextureSampler, float2(texdoff.y, texd.y)+TexOff0).r;
	dist1.y=tex2D(WaveTextureSampler, float2(texd.x, texdoff.z)+TexOff0).r;
	dist1.y-=tex2D(WaveTextureSampler, float2(texd.x, texdoff.w)+TexOff0).r;

	texd+=0.333;
	texdoff+=0.333;
	dist2.x=tex2D(WaveTextureSampler, float2(-texd.y, -texdoff.x)+TexOff1).r;
	dist2.x-=tex2D(WaveTextureSampler, float2(-texd.y, -texdoff.y)+TexOff1).r;
	dist2.y=tex2D(WaveTextureSampler, float2(-texdoff.z, -texd.x)+TexOff1).r;
	dist2.y-=tex2D(WaveTextureSampler, float2(-texdoff.w, -texd.x)+TexOff1).r;

	dist=lerp(dist1*TexScale0, dist2*TexScale1, 0.5);

	float	s=pow(saturate(dist.y), SpecSize)*SpecIntensity;

	col.rgb=tex2D(ReflectionTextureSampler, pixel.Tex2+dist/float2(24.0, 24.0)).rgb;
	col.rgb=lerp(col.rgb, SpecColor, s*s);

	col.a=tex2D(MaskTextureSampler, pixel.Tex0).a;
	col.a*=1.0+s;

	return col;
}


VS_OUTPUT WaterVS(	float4 Pos 	: POSITION0,
					float4 Diff	: COLOR0,
					float4 Tex0 : TEXCOORD0,
					float4 Tex1 : TEXCOORD1,
					float4 Tex2 : TEXCOORD2)
{
	VS_OUTPUT	pixel;
	pixel.Pos.x=(Pos.x-Viewport.x)/Viewport.z-0.5;
	pixel.Pos.y=0.5-(Pos.y-Viewport.y)/Viewport.w;
	pixel.Pos.z=Pos.z;
	pixel.Pos.w=Pos.z;
	pixel.Diff=Diff;

	pixel.Tex0=Tex0;
	pixel.Tex1.xy=Tex1.xy;
	pixel.Tex1.z=(Pos.x-Viewport.x)/Viewport.z-0.5;
	pixel.Tex1.w=1.0+(Pos.y-Viewport.y)/Viewport.w;
	pixel.Tex2=Tex2;

	return pixel;
}

technique Water
{
	pass p0
	{
		VertexShader=compile vs_1_1 WaterVS();
		PixelShader=compile ps_2_0 WaterPS();
	}
}
