struct VS_OUTPUT
{
    float4  Position: POSITION;
    float4  Diffuse : COLOR0;
	float2  TexCoord: TEXCOORD0;
};


texture SourceTexture;
sampler SourceTextureSampler = sampler_state {
    Texture   = <SourceTexture>;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
    MipFilter = LINEAR;
    MaxAnisotropy = 8;
	AddressU  = WRAP;
	AddressV  = WRAP;
	AddressW  = WRAP;
};



float	TexScale0;
float	TexScale1;

float	TexUOff0;
float	TexVOff0;
float	TexUOff1;
float	TexVOff1;


float4 RefMapUpdatePS(VS_OUTPUT pixel) : COLOR
{
	float4	val0=tex2D(SourceTextureSampler, float2(pixel.TexCoord.x+TexUOff0, pixel.TexCoord.y+TexVOff0))-float4(0.5, 0.5, 0.5, 0.0);
	val0.rgb*=TexScale0;
	float4	val1=tex2D(SourceTextureSampler, float2(-pixel.TexCoord.y+TexUOff1, -pixel.TexCoord.x+TexVOff1))-float4(0.5, 0.5, 0.5, 0.0);
	val1.rgb*=TexScale1;
	float4	val;
	val.rgb=lerp(val0.rgb, val1.rgb, 0.5)+float3(0.5, 0.5, 0.5);
	val.a=1;

	return val;
}


VS_OUTPUT RefMapUpdateVS(	float4 Position 	: POSITION0,
							float4 Diffuse		: COLOR0,
							float2 TexCoord 	: TEXCOORD0)
{
	VS_OUTPUT pixel;
	pixel.Position=Position;
	pixel.Diffuse=Diffuse;
	pixel.TexCoord=TexCoord;

	return pixel;
}

technique RefMapUpdate
{
	pass p0
	{
		VertexShader=compile vs_1_1 RefMapUpdateVS();
		PixelShader=compile ps_2_0 RefMapUpdatePS();
	}
}
