struct VS_OUTPUT
{
    float4	Pos: POSITION;
    float4	Diff: COLOR0;
	float4	Tex0: TEXCOORD0;
	float4	Tex1: TEXCOORD1;
	float4	Tex2: TEXCOORD2;
};


texture MaskTexture;
sampler MaskTextureSampler = sampler_state {
    Texture   = <MaskTexture>;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
    MipFilter = LINEAR;
    MaxAnisotropy = 8;
	AddressU  = CLAMP;
	AddressV  = CLAMP;
	AddressW  = CLAMP;
};


texture WaveTexture;
sampler WaveTextureSampler = sampler_state {
    Texture   = <WaveTexture>;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
    MipFilter = LINEAR;
    MaxAnisotropy = 8;
	AddressU  = WRAP;
	AddressV  = WRAP;
	AddressW  = WRAP;
};


texture ReflectionTexture;
sampler ReflectionTextureSampler = sampler_state {
    Texture   = <ReflectionTexture>;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
    MipFilter = LINEAR;
    MaxAnisotropy = 8;
	AddressU  = WRAP;
	AddressV  = WRAP;
	AddressW  = WRAP;
};



float4	Viewport;			// .x => MinX, .y => MinY, .z => Width, .w => Height
float	DistTexelWidth;
float	DistTexelHeight;


float4 WaterPS(VS_OUTPUT pixel) : COLOR
{
	float2	dist;
	float2	texd;
	texd.x=1.5*pixel.Tex1.z/pixel.Tex1.w;
	texd.y=12/pixel.Tex1.w;
	dist.x=tex2D(WaveTextureSampler, float2(texd.x-DistTexelWidth, texd.y)).r;
	dist.x-=tex2D(WaveTextureSampler, float2(texd.x+DistTexelWidth, texd.y)).r;
	dist.y=tex2D(WaveTextureSampler, float2(texd.x, texd.y-DistTexelHeight)).r;
	dist.y-=tex2D(WaveTextureSampler, float2(texd.x, texd.y+DistTexelHeight)).r;
	dist.x/=24;
	dist.y/=8;

	float4	col;
	col.rgb=tex2D(ReflectionTextureSampler, pixel.Tex2+dist).rgb;
//	col.a=clamp(1-(dist.x+dist.y)*8, 0, 1);
	col.a=clamp(1-dist.y*32, 0, 1);
	col.a*=tex2D(MaskTextureSampler, pixel.Tex0+dist).a*1.5;
//	col=tex2D(MaskTextureSampler, pixel.Tex0+dist);

	col.rgb=col.rgb/3.0+col.rgb*dist.x/(2.0/3.0);
//	float	f=clamp(dist.y*16, 0, 1);
	float	f=clamp((dist.x+dist.y)*16, 0, 1);
	col.rgb=lerp(col.rgb, float3(1, 1, 1), f);

//col=float4(0.5+dist.x*4, 0, 0.5+dist.y*4, 1);
//col=float4(0.5+texd.x/4, 0.5, 0, 1);
//f=tex2D(WaveTextureSampler, float2(texd.x, texd.y)).r;
//col=float4(f, f, f, 1);
//col=tex2D(ReflectionTextureSampler, pixel.Tex2);
//col.a=1;

//col.rgb=f;
//col.a=1;

	return col;
}


VS_OUTPUT WaterVS(	float4 Pos 	: POSITION0,
					float4 Diff	: COLOR0,
					float4 Tex0 : TEXCOORD0,
					float4 Tex1 : TEXCOORD1,
					float4 Tex2 : TEXCOORD2)
{
	VS_OUTPUT	pixel;
	pixel.Pos.x=(Pos.x-Viewport.x)/Viewport.z-0.5;
	pixel.Pos.y=0.5-(Pos.y-Viewport.y)/Viewport.w;
	pixel.Pos.z=Pos.z;
	pixel.Pos.w=Pos.z;
	pixel.Diff=Diff;

	pixel.Tex0=Tex0;
	pixel.Tex1=Tex1;
	pixel.Tex1.z=(Pos.x-Viewport.x)/Viewport.z-0.5;
	pixel.Tex1.w=1.0+(Pos.y-Viewport.y)/Viewport.w;
//	pixel.Tex1.w=2.0-(Pos.y-Viewport.y)/Viewport.w;
	pixel.Tex2=Tex2;

	return pixel;
}

technique Water
{
	pass p0
	{
		VertexShader=compile vs_1_1 WaterVS();
		PixelShader=compile ps_2_0 WaterPS();
	}
}
