struct VS_OUTPUT
{
    float4	Pos: POSITION;
    float4	Diff: COLOR0;
	float4	Tex0: TEXCOORD0;
	float4	Tex1: TEXCOORD1;
};


texture WaveTexture;
sampler WaveTextureSampler = sampler_state {
    Texture   = <WaveTexture>;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
    MipFilter = LINEAR;
    MaxAnisotropy = 8;
	AddressU  = WRAP;
	AddressV  = WRAP;
	AddressW  = WRAP;
};


texture ReflectionTexture;
sampler ReflectionTextureSampler = sampler_state {
    Texture   = <ReflectionTexture>;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
    MipFilter = LINEAR;
    MaxAnisotropy = 8;
	AddressU  = BORDER;//WRAP;
	AddressV  = BORDER;//WRAP;
	AddressW  = BORDER;//WRAP;
};



float4	Viewport;			// .x => MinX, .y => MinY, .z => Width, .w => Height
float	DistScale;
float 	Alpha;
float2	WaveScroll;

float4 UnderwaterPS(VS_OUTPUT pixel) : COLOR
{
	float2	dist;
	float4	col;
	float	brght;

	dist.xy=tex2D(WaveTextureSampler, pixel.Tex0+WaveScroll).rg-float2(0.5, 0.5);
	brght=0.5+tex2D(WaveTextureSampler, pixel.Tex0+WaveScroll*0.234).b*DistScale*32;

	col.rgb=tex2D(ReflectionTextureSampler, pixel.Tex1+dist*DistScale).rgb*brght;
	col.a=Alpha;

	return col;
}


VS_OUTPUT UnderwaterVS(	float4 Pos 	: POSITION0,
					float4 Diff	: COLOR0,
					float4 Tex0 : TEXCOORD0,
					float4 Tex1 : TEXCOORD1)
{
	VS_OUTPUT	pixel;
	pixel.Pos.x=(Pos.x-Viewport.x)/Viewport.z-0.5;
	pixel.Pos.y=0.5-(Pos.y-Viewport.y)/Viewport.w;
	pixel.Pos.z=Pos.z;
	pixel.Pos.w=Pos.z;
	pixel.Diff=Diff;

	pixel.Tex0=Tex0;
	pixel.Tex1=Tex1;

	return pixel;
}

technique Underwater
{
	pass p0
	{
		VertexShader=compile vs_1_1 UnderwaterVS();
		PixelShader=compile ps_2_0 UnderwaterPS();
	}
}
