struct VS_OUTPUT
{
    float4  Position: POSITION;
    float4  Diffuse : COLOR0;
	float3  TexCoord: TEXCOORD0;
};


texture ColorTexture;
sampler ColorTextureSampler = sampler_state {
    Texture   = <ColorTexture>;
    MinFilter = Linear;
    MagFilter = Linear;
    MipFilter = Linear;
    MaxAnisotropy = 8;
	AddressU  = CLAMP;
	AddressV  = CLAMP;
	AddressW  = CLAMP;
};



float	Progress=0.0;
float	Exposure=0.0;

float4 PhotoDevelopmentPS(VS_OUTPUT pixel) : COLOR
{
	float4	col=tex2D(ColorTextureSampler, pixel.TexCoord.xy);

	if(col.r+col.g+col.b!=3.0)
	{
		float	blendval=pow(Progress, 3.0)*2.0;

		if(Exposure<=1.0)
			col.rgb=1.0-Exposure+(col.rgb*Exposure);
		else
//			col.rgb=pow(col.rgb, 2.5*Exposure);
			col.rgb=pow(col.rgb, 4.0*Exposure);

		if(blendval<1.0)
			col.rgb=1.0-blendval+(col.rgb*blendval);
		else
			col.rgb=col.rgb*(2.0-blendval);
	}

	return saturate(col);
}


VS_OUTPUT PhotoDevelopmentVS(
									float4 Position 	: POSITION0,
									float4 Diffuse		: COLOR0,
									float3 TexCoord 	: TEXCOORD0
)
{
	VS_OUTPUT pixel;
	pixel.Position=Position;
	pixel.Diffuse=Diffuse;
	pixel.TexCoord=TexCoord;
	
	return pixel;
}

technique PhotoDevelopment
{
	pass p0
	{
		VertexShader=compile vs_1_1 PhotoDevelopmentVS();
		PixelShader=compile ps_2_0 PhotoDevelopmentPS();
	}
}
