struct VS_OUTPUT
{
    float4  Position: POSITION;
    float4  Diffuse : COLOR0;
	float3  TexCoord: TEXCOORD0;
};


texture ColorTexture;
sampler ColorTextureSampler = sampler_state {
    Texture   = <ColorTexture>;
    MinFilter = Linear;
    MagFilter = Linear;
    MipFilter = Linear;
    MaxAnisotropy = 8;
	AddressU  = CLAMP;
	AddressV  = CLAMP;
	AddressW  = CLAMP;
};



int AlphaBlend;

float4 LayerFogPS(VS_OUTPUT pixel) : COLOR
{
	float4 col=tex2D(ColorTextureSampler, pixel.TexCoord.xy);
//	if(AlphaBlend==0)
//		col.a=1.0f;

	col*=pixel.Diffuse;
//	col.rgb=lerp(col.rgb, pixel.Fog.rgb, pixel.Fog.a);	// Blend between object's color and fog's color

	return col;
//	return pixel.Diffuse;
//	return pixel.Fog;
//	return float4(pixel.TexCoord.x, pixel.TexCoord.y, pixel.TexCoord.z, col.a);
}


VS_OUTPUT LayerFogVS(
									float4 Position 	: POSITION0,
									float4 Diffuse		: COLOR0,
									float3 TexCoord 	: TEXCOORD0
)
{
	VS_OUTPUT pixel;
	pixel.Position=Position;
	pixel.Diffuse=Diffuse;
	pixel.TexCoord=TexCoord;
	
	return pixel;
}

technique LayerFog
{
	pass p0
	{
		VertexShader=compile vs_1_1 LayerFogVS();
		PixelShader=compile ps_2_0 LayerFogPS();
	}
}
