struct VS_OUTPUT
{
    float4	Pos: POSITION;
    float4	Diff: COLOR0;
	float4	Tex0: TEXCOORD0;
	float4	Tex1: TEXCOORD1;
};


texture NrmlZTexture;
sampler NrmlZTextureSampler = sampler_state {
    Texture   = <NrmlZTexture>;
    MinFilter = LINEAR;//POINT;
    MagFilter = LINEAR;//POINT;
    MipFilter = LINEAR;//POINT;
    MaxAnisotropy = 8;
	AddressU  = CLAMP;
	AddressV  = CLAMP;
	AddressW  = CLAMP;
};


texture LightSrcTexture;
sampler LightSrcTextureSampler = sampler_state {
    Texture   = <LightSrcTexture>;
    MinFilter = POINT;
    MagFilter = POINT;
    MipFilter = POINT;
    MaxAnisotropy = 8;
	AddressU  = BORDER;
	AddressV  = BORDER;
	AddressW  = BORDER;
//	BorderColor = float4(0.5, 0.5, 0.5, 0.5);
};



float4	Viewport;			// .x => MinX, .y => MinY, .z => Width, .w => Height

float	LightZScale=0.25;
float	LightZPos=0.2;

float3	LightColor=float3(1.0, 1.0, 1.0);
float4	AmbientColor=float4(0.1, 0.1, 0.1, 1.0);

float3	DbgDirLight=float3(1.0, 0.0, 0.0);


float4 DynLightPS(VS_OUTPUT pixel) : COLOR
{
	float4	bckg=tex2D(NrmlZTextureSampler, pixel.Tex0);
	float4	lght=tex2D(LightSrcTextureSampler, pixel.Tex1);
	bckg.rgb=(bckg.rgb-0.5)*2.0;
	lght.rgb=(lght.rgb-0.5)*2.0;

	if(bckg.a<=0.0)
		return AmbientColor;//float4(0.5, 0.0, 0.0, 1.0);

	if(lght.a==0.0)
		return AmbientColor;//float4(bckg.a*0.5, bckg.a*0.5, bckg.a*0.5, 1.0);

	float	zpos=(bckg.a-LightZPos)/LightZScale;
	if(zpos>lght.b || zpos<-lght.b)
		return AmbientColor;//float4(bckg.a, 0.0, 0.0, 1.0);

//	float3	nrml=float3(-lght.r, lght.g, zpos);
	float3	nrml=float3(-lght.r, lght.g, -zpos);
	float	len=sqrt(nrml.r*nrml.r+nrml.g*nrml.g+nrml.b*nrml.b);
	if(len<0.01)
		return AmbientColor;//float4(1.0, 0.0, 0.0, 1.0);
	nrml/=len;
	float	dot=bckg.r*nrml.r+bckg.g*nrml.g+bckg.b*nrml.b;

	float4	col=dot*2*(1.0-len);
	col=clamp(col, AmbientColor, 1.0);
	col.rgb*=LightColor;
	col=clamp(col, AmbientColor, 1.0);

	return col;
}


VS_OUTPUT DynLightVS(	float4 Pos 	: POSITION0,
						float4 Diff	: COLOR0,
						float4 Tex0 : TEXCOORD0,
						float4 Tex1 : TEXCOORD1)
{
	VS_OUTPUT	pixel;
	pixel.Pos.x=(Pos.x-Viewport.x)/Viewport.z-0.5;
	pixel.Pos.y=0.5-(Pos.y-Viewport.y)/Viewport.w;
	pixel.Pos.z=Pos.z;
	pixel.Pos.w=Pos.z;
	pixel.Diff=Diff;

	pixel.Tex0=Tex0;
	pixel.Tex1=Tex1;
//	pixel.Tex1.z=(Pos.x-Viewport.x)/Viewport.z-0.5;
//	pixel.Tex1.w=1.0+(Pos.y-Viewport.y)/Viewport.w;

	return pixel;
}

technique DynLight
{
	pass p0
	{
		VertexShader=compile vs_1_1 DynLightVS();
		PixelShader=compile ps_2_0 DynLightPS();
	}
}




// ********************************************************************







float4 DynLightViewZPS(VS_OUTPUT pixel) : COLOR
{
	float4	bckg=tex2D(NrmlZTextureSampler, pixel.Tex0);
	float4	lght=tex2D(LightSrcTextureSampler, pixel.Tex1);
	lght.rgb=(lght.rgb-0.5)*2.0;

	if(bckg.a<=0.0)
		return float4(0.5, 0.0, 0.0, 1.0);

	if(lght.a==0.0)
		return float4(0.0, bckg.a, 0.0, 1.0);

	if(abs(lght.b)>0.991)
		return float4(LightZPos, LightZPos, LightZPos, 1.0);

	return bckg.a;
}


VS_OUTPUT DynLightViewZVS(	float4 Pos 	: POSITION0,
							float4 Diff	: COLOR0,
							float4 Tex0 : TEXCOORD0,
							float4 Tex1 : TEXCOORD1)
{
	VS_OUTPUT	pixel;
	pixel.Pos.x=(Pos.x-Viewport.x)/Viewport.z-0.5;
	pixel.Pos.y=0.5-(Pos.y-Viewport.y)/Viewport.w;
	pixel.Pos.z=Pos.z;
	pixel.Pos.w=Pos.z;
	pixel.Diff=Diff;

	pixel.Tex0=Tex0;
	pixel.Tex1=Tex1;
	pixel.Tex1.z=(Pos.x-Viewport.x)/Viewport.z-0.5;
	pixel.Tex1.w=1.0+(Pos.y-Viewport.y)/Viewport.w;

	return pixel;
}

technique DynLightViewZ
{
	pass p0
	{
		VertexShader=compile vs_1_1 DynLightViewZVS();
		PixelShader=compile ps_2_0 DynLightViewZPS();
	}
}




// ********************************************************************







float4 DynLightLghtOnlyPS(VS_OUTPUT pixel) : COLOR
{
	float4	bckg=tex2D(NrmlZTextureSampler, pixel.Tex0);
	float4	lght=tex2D(LightSrcTextureSampler, pixel.Tex1);
	bckg.rgb=(bckg.rgb-0.5)*2.0;
	lght.rgb=(lght.rgb-0.5)*2.0;

	if(bckg.a<=0.0)
		return float4(0.5, 0.0, 0.0, 1.0);

	if(lght.a==0.0)
		return float4(0.0, bckg.a, 0.0, 1.0);

	float	zpos=(bckg.a-LightZPos)/LightZScale;
	if(zpos>lght.b || zpos<-lght.b)
		return float4(0.0, bckg.a, 0.0, 1.0);

	float3	nrml=float3(-lght.r, lght.g, -zpos);
	float	len=sqrt(nrml.r*nrml.r+nrml.g*nrml.g+nrml.b*nrml.b);
	if(len<0.01)
		return float4(1.0, 0.0, 0.0, 1.0);
	nrml/=len;
/*nrml=nrml*0.5+0.5;
return float4(nrml.r, nrml.g, nrml.b, 1.0);*/
	float	dot=bckg.r*nrml.r+bckg.g*nrml.g+bckg.b*nrml.b;

	float4	col=dot*2*(1.0-len);
	col=clamp(col, AmbientColor, 1.0);
	col.rgb*=LightColor;
	col=clamp(col, AmbientColor, 1.0);

	return float4(col.r, col.g, col.b, 1.0);
}


VS_OUTPUT DynLightLghtOnlyVS(	float4 Pos 	: POSITION0,
								float4 Diff	: COLOR0,
								float4 Tex0 : TEXCOORD0,
								float4 Tex1 : TEXCOORD1)
{
	VS_OUTPUT	pixel;
	pixel.Pos.x=(Pos.x-Viewport.x)/Viewport.z-0.5;
	pixel.Pos.y=0.5-(Pos.y-Viewport.y)/Viewport.w;
	pixel.Pos.z=Pos.z;
	pixel.Pos.w=Pos.z;
	pixel.Diff=Diff;

	pixel.Tex0=Tex0;
	pixel.Tex1=Tex1;
	pixel.Tex1.z=(Pos.x-Viewport.x)/Viewport.z-0.5;
	pixel.Tex1.w=1.0+(Pos.y-Viewport.y)/Viewport.w;

	return pixel;
}

technique DynLightLghtOnly
{
	pass p0
	{
		VertexShader=compile vs_1_1 DynLightLghtOnlyVS();
		PixelShader=compile ps_2_0 DynLightLghtOnlyPS();
	}
}




// ********************************************************************







float4 DynLightLghtNrmlPS(VS_OUTPUT pixel) : COLOR
{
	float4	bckg=tex2D(NrmlZTextureSampler, pixel.Tex0);
	bckg.rgb=(bckg.rgb-0.5)*2.0;

	if(bckg.a<=0.0)
		return float4(0.5, 0.0, 0.0, 1.0);

	float	dot=bckg.r*DbgDirLight.r+bckg.g*DbgDirLight.g+bckg.b*DbgDirLight.b;

	float3	col=dot;
	col=clamp(col, 0.0, 1.0);

//col=float3(0.5+nrml.r*0.5, 0.5+nrml.g*0.5, 0.5+nrml.b*0.5);
	return float4(col.r, col.g, col.b, 1.0);
}


VS_OUTPUT DynLightLghtNrmlVS(	float4 Pos 	: POSITION0,
								float4 Diff	: COLOR0,
								float4 Tex0 : TEXCOORD0,
								float4 Tex1 : TEXCOORD1)
{
	VS_OUTPUT	pixel;
	pixel.Pos.x=(Pos.x-Viewport.x)/Viewport.z-0.5;
	pixel.Pos.y=0.5-(Pos.y-Viewport.y)/Viewport.w;
	pixel.Pos.z=Pos.z;
	pixel.Pos.w=Pos.z;
	pixel.Diff=Diff;

	pixel.Tex0=Tex0;
	pixel.Tex1=Tex1;
	pixel.Tex1.z=(Pos.x-Viewport.x)/Viewport.z-0.5;
	pixel.Tex1.w=1.0+(Pos.y-Viewport.y)/Viewport.w;

	return pixel;
}

technique DynLightLghtNrml
{
	pass p0
	{
		VertexShader=compile vs_1_1 DynLightLghtNrmlVS();
		PixelShader=compile ps_2_0 DynLightLghtNrmlPS();
	}
}
