function tutorial_init()
    ENGINE.modules.tutorial = ENGINE.modules.tutorial or {}
    local obj = ENGINE.modules.tutorial
    local G = {}
    function obj:init()
        G = tutorial_1()
        g2.html = ""..
        "<table>"..
        "<tr><td><input type='button' value='Resume' onclick='resume' />"..
        "<tr><td><input type='button' value='Restart' onclick='restart' />"..
        "<tr><td><input type='button' value='Skip' onclick='skip' />"..
        "<tr><td><input type='button' value='Back to Menu' onclick='menu' />"..
        "</table>"..
        "";
    end
    function obj:loop(t)
        local win = nil
        local planets = g2.search("planet -neutral")
        for _i,p in pairs(planets) do
            local user = p:owner()
            if (win == nil) then win = user end
            if (win ~= user) then return end
        end
        if win == G.player then
            G.win_t = G.win_t + t
            if G.win_t >= 3 then
                G = G.post()
            end
        end
    end
    function obj:event(e) 
        if e.type == 'quit' then
            ENGINE.engine:next(ENGINE.modules.title)
            g2.quit = false
        end
        if e.type == 'onclick' and e.value == 'resume' then
            g2.state = "play"
        end
        if e.type == 'onclick' and e.value == 'restart' then
            G = tutorial_1()
        end
        if e.type == 'onclick' and e.value == 'skip' then
            tutorial_end()
        end
        if e.type == 'onclick' and e.value == 'menu' then
            ENGINE.engine:next(ENGINE.modules.title)
        end
    end
end

function tutorial_setup(title,intro,post)
    local G = {}
    G.SW = 320
    G.SH = 320
    G.HY = G.SH-60
    G.post = post
    G.win_t = 0
    
    local COLORS = {0x555555,0x00ff00,0xff0000} 

    g2.state = "play"
    g2.game_reset()
    g2.bkgr_src = "background05"
    g2.view_set(0,0,G.SW,G.SH)
    g2.play_music("mus-legends-menu")

    local o = g2.new_user("neutral",COLORS[1])
    o.user_neutral = 1
    o.ships_production_enabled = 0
    G.neutral = o
    
    local o = g2.new_user("player",COLORS[2])
    o.ui_ships_show_mask = 0xf
    G.player = o
    g2.player = o

    local o = g2.new_user("enemy",COLORS[3])
    G.bot = o
    
    local txt = g2.new_label(title,G.SW/2,20)
    txt.label_size = 32
    
    local y = 60
    for k,v in pairs(intro) do
        local txt = g2.new_label(v,G.SW/2,y)
        txt.label_size = 20
        y = y + 20
    end
    
    return G
end

function tutorial_1() 
    local G = tutorial_setup("Basic Gameplay",
        {
        "",
        "Tap to select your planet",
        "(indicated by spiral.)",
        "",
        "Then choose a target.",
        "(Tap on or drag to the",
        "enemy planet.)",
        },tutorial_2)

    g2.new_planet(G.player,80,G.HY,100,100)
    g2.new_planet(G.bot,G.SW-80,G.HY,50,45)
    
    return G
end

function tutorial_2()
    local G = tutorial_setup("Production",
        {
        "The number is ships on the planet.",
        "",
        "Large planets produce more ships.",
        "Grey planets are neutral.",
        "",
        "Take over the neutral planet so",
        "that you can produce enough",
        "ships to conquer the enemy.",
        },tutorial_3)

    g2.new_planet(G.player,80,G.HY+30,25,50)
    g2.new_planet(G.bot,G.SW-80,G.HY+30,30,50)
    g2.new_planet(G.neutral,G.SW/2,G.HY-10,100,3)
    
    return G
end

function tutorial_3()
    local G = tutorial_setup("Advanced Controls",
        {
        "Select multiple planets by tapping",
        "them individually, or select all by",
        "double-tapping one of them.",
        "",
        "Tap the % indicator to change",
        "your fleet size.",
        "",
        "Conquer the enemy to win!",
        },tutorial_end)
    
    g2.new_planet(G.player,60,G.HY+20,60,80)
    g2.new_planet(G.bot,G.SW-60,G.HY-20,20,12)
    g2.new_planet(G.bot,G.SW-90,G.HY+20,40,24)
    g2.new_planet(G.neutral,G.SW/2-35,G.HY-15,65,15)
    g2.new_planet(G.neutral,G.SW/2+15,G.HY+30,45,10)
    
    return G
end
    

function tutorial_end()
    ext_achievement_submit("tutorial")
    ENGINE.engine:next(ENGINE.modules.gqwrap)
end
