function title_init()
    ENGINE.modules.title = ENGINE.modules.title or {}
    local obj = ENGINE.modules.title
    function obj:init() 
        g2.game_reset()
        g2.view_set(0,0,640,480)
        g2.play_music("mus-legends-menu")
        g2.bkgr_src = "background23"
        g2.state = "overlay"
        local html = [[
            <table>
            <tr><td><p>Phil Hassey presents ...</p>
            <tr><td><p>&nbsp;</p>
            <tr><td><img src="legends_logo" width=320/>
            <tr><td><p>&nbsp;</p>
            <tr><td><input type='button' value='Play' onclick='play' class='button2' />]]
        if g2.platform == "iOS" then
            html = html .. [[<tr><td><input type='button' value='Your Stats' onclick='ach' />]]
        else
            html = html .. [[<tr><td><input type='button' value='Leaderboards' onclick='highs'  />]]
        end
        html = html .. [[<tr><td><input type='button' value='Settings' onclick='settings' />
            <tr><td><input type='button' value='About' onclick='about' />
            ]]
            if g2.platform ~= "iOS" and g2.platform ~= "Android" then
                html = html .. [[<tr><td><input type='button' value='Quit' onclick='quit' />]]
            end
            html = html .. [[
            <tr><td><p>&nbsp;</p>
            <tr><td><p>]]..g2.vinfo..[[</p>
            </table>
            ]]
        g2.html = html
    
        if g2.platform == "iOS" or g2.platform == "Android" then
            g2_ext_call("legends:remove_quit","")
        end
--             <tr><td><input type='button' value='More Games' onclick='more' />
    end
    function obj:loop(t)
    end
    function obj:event(e) 
        if e.type == 'onclick' and e.value == 'play' then
            local data = json.decode(g2.data)
            if data == nil or data.current_difficulty == nil or data.current_difficulty == 1 then
                ENGINE.engine:next(ENGINE.modules.tutorial)
            else
                ENGINE.engine:next(ENGINE.modules.gqwrap)
            end
        end
        if e.type == 'onclick' and e.value == 'highs' then
            ENGINE.engine:next(ENGINE.modules.highs)
        end
        if e.type == 'onclick' and e.value == 'ach' then
            if g2_ext_call("legends:achievements_show","") == "unavailable" then
                ENGINE.engine:next(ENGINE.modules.highs)
            end
        end
        if e.type == 'onclick' and e.value == 'settings' then
            g2.state = 'settings'
        end
        if e.type == 'onclick' and e.value == 'about' then
            ENGINE.engine:next(ENGINE.modules.about)
        end
        if e.type == 'onclick' and e.value == 'quit' then
            g2.state = 'exit'
        end
        if e.type == 'quit' then
            g2.state = 'exit'
        end
    end
end
