----- GAMEMODE-SPECIFIC INIT FUNCITONS -----

function init_classic() 
    local level = LEVELS[GLOBAL.current_level]
    local pad = 40; local sw = GLOBAL.play_sw; local sh = GLOBAL.play_sh

    local a = math.random(0,360)
    local users = 1.0 + #GAME.bots
    homes = {}
    
    for i=1,level.homes do
        local x,y
        x = sw/2 + (sw-pad*5)*math.cos(a*math.pi/180.0)/2.0
        y = sh/2 + (sh-pad*4)*math.sin(a*math.pi/180.0)/2.0
        table.insert(homes,g2.new_planet(GAME.player, x,y, level.home_production, level.player_ships))
        for j=1,#GAME.bots do
            local bot = GAME.bots[j]
            a = a+360/(users)
            x = sw/2 + (sw-pad*4)*math.cos(a*math.pi/180.0)/2.0
            y = sh/2 + (sh-pad*4)*math.sin(a*math.pi/180.0)/2.0
            if level.teams ~= nil then
                if level.teams[j] == 1 then
                    table.insert(homes,g2.new_planet(bot, x,y, level.home_production, level.player_ships))
                else
                    table.insert(homes,g2.new_planet(bot, x,y, level.home_production, level.enemy_ships[GLOBAL.current_difficulty]))
                end
            else
                table.insert(homes,g2.new_planet(bot, x,y, level.home_production, level.enemy_ships[GLOBAL.current_difficulty]))
            end
        end   
        a = a + 360/(users)
        a = a + 360/(level.homes*users) 
    end
    local map = generate_map(homes, level.neutrals, GLOBAL.tolerance)
    for _i,p in ipairs(map) do
        g2.new_planet(GAME.user_neutral, p.position_x, p.position_y, p.ships_production, p.ships_value);
    end
end

function init_vacuum()
    local level = LEVELS[GLOBAL.current_level]
    GAME.time_left = level.TIMER_START[GLOBAL.current_difficulty]
    GAME.beeps_left = 3
    g2.status = "Time Left: "..time_left_text(GAME.time_left)
    
    local pad = 50; local sw = GLOBAL.play_sw; local sh = GLOBAL.play_sh
    local a = math.random(0,360)
    
    for i=1,level.homes do
        local x,y
        x = sw/2 + (sw-pad*2)*math.cos(a*math.pi/180.0)/2.0
        y = sh/2 + (sh-pad*2)*math.sin(a*math.pi/180.0)/2.0
        g2.new_planet(GAME.player, x,y, level.home_production, level.player_ships)
        a = a + 360/level.homes
    end
    -- make sure vacuum levels are fair yet still random
    -- see vacuum_generation.png for an explanation
    local curr_prod = 100
    local total_ships = 0
    local k = 1 -- "strictness" (how stringent the fairness algorithm is)
    for i=1,level.neutrals do
        local ideal_total_ships = (i-1)*25 -- the ideal number of ships that should have been generated thus far
        curr_prod = curr_prod - (100 - 15)/level.neutrals
        local min = k*(ideal_total_ships-total_ships)
        local max = min + 50
        if min < 0 then min = 0 end
        if min > 30 then min = 30 end
        if max > 50 then max = 50 end
        if max < 20 then max = 20 end
        local ships = math.random(min,max)
        total_ships = total_ships + ships
        g2.new_planet(GAME.user_neutral, math.random(pad,sw-pad),math.random(pad,sh-pad), curr_prod, ships);
    end
end

function init_armistice()
    local level = LEVELS[GLOBAL.current_level]
    GAME.time_left = level.TIMER_START[GLOBAL.current_difficulty]
    GAME.beeps_left = 3
    g2.status = "Time Left: "..time_left_text(GAME.time_left)
    GAME.player.ui_to_mask = 0x7
    GAME.bots[1].ui_to_mask = 0x7
    init_classic()
end

function init_symmetric() 
    local level = LEVELS[GLOBAL.current_level]
    local pad = 50; local sw = GLOBAL.play_sw; local sh = GLOBAL.play_sh

    local a = math.random(0,360)
    local users = 1.0 + #GAME.bots
    local x,y
    for i=1,level.homes do
        x = sw/2 + (sw-pad*2)*math.cos(a*math.pi/180.0)/2.0
        y = sh/2 + (sh-pad*2)*math.sin(a*math.pi/180.0)/2.0
        g2.new_planet(GAME.player, x,y, level.home_production, level.player_ships)
        for j=1,#GAME.bots do
            local bot = GAME.bots[j]
            a = a+360/(users)
            x = sw/2 + (sw-pad*2)*math.cos(a*math.pi/180.0)/2.0
            y = sh/2 + (sh-pad*2)*math.sin(a*math.pi/180.0)/2.0
            g2.new_planet(bot, x,y, level.home_production, level.enemy_ships[GLOBAL.current_difficulty])
        end   
        a = a + 360/(users)
        a = a + 360/(level.homes*users) 
    end
    
    for i=1,level.neutrals/users do
        local angle = math.random(0,360)
        local x0 = math.random(pad,sw-pad)
        local y0 = math.random(pad,sh-pad)
        local rand_prod = math.random(15,100)
   		local rand_ships = math.random(0,50)
    	for j=1, users do -- matrix rotation around (sw/2,sh/2)
    	    local point = rotate_point(x0, y0, sw/2, sh/2, angle)
        	g2.new_planet(GAME.user_neutral, point.x, point.y, rand_prod, rand_ships)
			angle = angle + math.pi*2/users
		end
    end
end

function init_beast() 
    local level = LEVELS[GLOBAL.current_level]
    local pad = 50; local sw = GLOBAL.play_sw; local sh = GLOBAL.play_sh
    
    local a = math.random(0,360)
    local users = #GAME.bots
    
    for i=1,level.homes do
        local x,y
        x = sw/2 + (sw-pad*2)*math.cos(a*math.pi/180.0)/2.0
        y = sh/2 + (sh-pad*2)*math.sin(a*math.pi/180.0)/2.0
        g2.new_planet(GAME.player, x,y, level.home_production, level.player_ships)
            
        a = a + 360/(users)
        a = a + 360/(level.homes*users)
    end
    
    for i=1,level.neutrals do
        g2.new_planet(GAME.bots[1], math.random(pad,sw-pad),math.random(pad,sh-pad), math.random(15,100), level.enemy_ships[GLOBAL.current_difficulty]);
    end
end

function init_custom_lv5()
    local level = LEVELS[GLOBAL.current_level]
    local pad = 50; local sw = GLOBAL.play_sw; local sh = GLOBAL.play_sh
    
    local a = math.random(0,360)

    local x = sw/2 + (sw-pad*2)*math.cos(a*math.pi/180.0)/2.0
    local y = sh/2 + (sh-pad*2)*math.sin(a*math.pi/180.0)/2.0
    g2.new_planet(GAME.player, x,y, level.home_production, level.player_ships)
    
    for i=1,level.neutrals/4 do
        g2.new_planet(GAME.bots[1], math.random(pad,sw-pad),math.random(pad,sh-pad), math.random(15,100), level.enemy_ships[GLOBAL.current_difficulty]);
    end
    for i=1,level.neutrals/4 do
        g2.new_planet(GAME.bots[2], math.random(pad,sw-pad),math.random(pad,sh-pad), math.random(15,100), level.enemy_ships[GLOBAL.current_difficulty]);
    end
    for i=1,level.neutrals/2 do
        g2.new_planet(GAME.user_neutral, math.random(pad,sw-pad),math.random(pad,sh-pad), math.random(15,100), math.random(0,50));
    end
end

function init_wormhole() 
    local level = LEVELS[GLOBAL.current_level]
    local pad = 50; local sw = GLOBAL.play_sw; local sh = GLOBAL.play_sh

    GAME.wave_num = 0
    GAME.time_left = level.TIMER_START[GLOBAL.current_difficulty]
    GAME.beeps_left = 3
    g2.status = "Wave: "..GAME.wave_num.."/3  |  Time Left: "..time_left_text(GAME.time_left)

    local a = math.random(0,360)
    
    for i=1,level.homes do
        local x,y
        x = sw/2 + (sw-pad*2)*math.cos(a*math.pi/180.0)/2.0
        y = sh/2 + (sh-pad*2)*math.sin(a*math.pi/180.0)/2.0
        g2.new_planet(GAME.player, x,y, level.home_production, level.player_ships)
        a = a + 180
    end
    
    for i=1,level.neutrals do
        g2.new_planet(GAME.user_neutral, math.random(pad,sw-pad),math.random(pad,sh-pad), math.random(15,100), math.random(0,50));
    end
    
    GAME.wormhole = g2.new_planet(GAME.bots[1], GLOBAL.play_sw/2, GLOBAL.play_sh/2, 200, 1000);
    g2.planets_settle()
    GAME.wormhole:destroy()
end

function init_invasion() 
    local level = LEVELS[GLOBAL.current_level]
    local pad = 50; local sw = GLOBAL.play_sw; local sh = GLOBAL.play_sh

    GAME.wave_num = 0
    GAME.time_left = level.TIMER_START[GLOBAL.current_difficulty]
    GAME.beeps_left = 3
    g2.status = "Wave: "..GAME.wave_num.."/3  |  Time Left: "..time_left_text(GAME.time_left)

    local a = math.random(0,360)
    local curr_prod = 100 -- makes maps somewhat fair yet random
    for i=1,level.neutrals*2/3 do
        curr_prod = curr_prod - (100 - 15)/(level.neutrals*2/3)
        g2.new_planet(GAME.bots[1], math.random(pad,sw-pad),math.random(pad,sh-pad),curr_prod, level.enemy_ships[GLOBAL.current_difficulty]);
    end
    for i=1,level.neutrals/3 do
        g2.new_planet(GAME.user_neutral, math.random(pad,sw-pad),math.random(pad,sh-pad), math.random(15,100), math.random(0,50));
    end
    
    GAME.wormhole = g2.new_planet(GAME.player, GLOBAL.play_sw/2, GLOBAL.play_sh/2, 200, 1000);
    g2.planets_settle()
    GAME.wormhole:destroy()
end

function init_grinder() 
    local level = LEVELS[GLOBAL.current_level]
    GAME.time_left = level.TIMER_START[GLOBAL.current_difficulty]
    GAME.beeps_left = 3
    g2.status = "Time Left: "..time_left_text(GAME.time_left)
    init_classic()
end

function init_seduction()
    init_grinder()
end

function init_custom_lv9()
    local level = LEVELS[GLOBAL.current_level]
    local pad = 50; local sw = GLOBAL.play_sw; local sh = GLOBAL.play_sh
    
    local a = math.random(0,360)
    
    for i=1,3 do
        local x = sw/2 + (sw-pad*2)*math.cos(a*math.pi/180.0)/2.0
        local y = sh/2 + (sh-pad*2)*math.sin(a*math.pi/180.0)/2.0
        g2.new_planet(GAME.bots[1], x,y, 200, 8*level.enemy_ships[GLOBAL.current_difficulty])
        a = a + 120
    end
    for i=1,level.homes do
        g2.new_planet(GAME.player, math.random(pad,sw-pad),math.random(pad,sh-pad), level.home_production, level.player_ships)
    end
    for i=1,3*level.neutrals/4 do
        g2.new_planet(GAME.bots[2], math.random(pad,sw-pad),math.random(pad,sh-pad), math.random(15,100), level.enemy_ships[GLOBAL.current_difficulty]);
    end
    for i=1,level.neutrals/4 do
        g2.new_planet(GAME.user_neutral, math.random(pad,sw-pad),math.random(pad,sh-pad), math.random(15,100), math.random(0,50));
    end
end

function init_custom_lv10()
    local level = LEVELS[GLOBAL.current_level]
    local pad = 50; local sw = GLOBAL.play_sw; local sh = GLOBAL.play_sh
    
    local a = math.random(0,360)
    
    for i=1,level.homes do
        g2.new_planet(GAME.player, math.random(pad,sw-pad),math.random(pad,sh-pad), level.home_production, level.player_ships)
    end
    for i=1,3*level.neutrals/4 do
        g2.new_planet(GAME.bots[1], math.random(pad,sw-pad),math.random(pad,sh-pad), math.random(15,100), level.enemy_ships[GLOBAL.current_difficulty]);
    end
    for i=1,level.neutrals/4 do
        g2.new_planet(GAME.user_neutral, math.random(pad,sw-pad),math.random(pad,sh-pad), math.random(15,100), math.random(0,50));
    end
end

function init_custom_lv11()
    local level = LEVELS[GLOBAL.current_level]
    local pad = 50; local sw = GLOBAL.play_sw; local sh = GLOBAL.play_sh
    
    local x = math.random(3*pad,sw-3*pad)
    local y = math.random(3*pad,sh-3*pad)
    g2.new_planet(GAME.player, x, y, level.home_production, 1.5*level.player_ships)
    g2.new_planet(GAME.bots[1], x + 2*math.random(-pad,pad), y + 2*math.random(-pad,pad), level.home_production, 0.5*level.player_ships)
    
    for i=1,3*level.neutrals/4 do
        g2.new_planet(GAME.bots[2], math.random(pad,sw-pad),math.random(pad,sh-pad), math.random(15,100), level.enemy_ships[GLOBAL.current_difficulty]);
    end
    for i=1,level.neutrals/4 do
        g2.new_planet(GAME.user_neutral, math.random(pad,sw-pad),math.random(pad,sh-pad), math.random(15,100), math.random(0,50));
    end
end

function init_custom_lv15() 
    local level = LEVELS[GLOBAL.current_level]
    local pad = 50; local sw = GLOBAL.play_sw; local sh = GLOBAL.play_sh

    local a = math.random(0,360)
    local users = 2.0 + #GAME.bots
    
    for i=1,2 do
        local x,y
        x = sw/2 + (sw-pad*2)*math.cos(a*math.pi/180.0)/2.0
        y = sh/2 + (sh-pad*2)*math.sin(a*math.pi/180.0)/2.0
        g2.new_planet(GAME.player, x,y, level.home_production, level.player_ships)
        local bot = GAME.bots[i]
        a = a + 360/(users)
        x = sw/2 + (sw-pad*2)*math.cos(a*math.pi/180.0)/2.0
        y = sh/2 + (sh-pad*2)*math.sin(a*math.pi/180.0)/2.0
        g2.new_planet(bot, x,y, level.home_production, level.enemy_ships[GLOBAL.current_difficulty])
        a = a + 360/(users)
    end
    
    for i=1,level.neutrals do
        g2.new_planet(GAME.user_neutral, math.random(pad,sw-pad),math.random(pad,sh-pad), math.random(15,100), math.random(0,50));
    end
end

function init_custom_lv16() 
    local level = LEVELS[GLOBAL.current_level]
    local pad = 50; local sw = GLOBAL.play_sw; local sh = GLOBAL.play_sh

    local a = math.random(0,360)
    local homes = 7
    
    local x,y
    for i=1,3 do
        x = sw/2 + (sw-pad*2)*math.cos(a*math.pi/180.0)/2.0
        y = sh/2 + (sh-pad*2)*math.sin(a*math.pi/180.0)/2.0
        g2.new_planet(GAME.bots[i%2+1], x,y, level.home_production, level.enemy_ships[GLOBAL.current_difficulty])
        a = a + 360/homes
    end
    for i=1,2 do
        x = sw/2 + (sw-pad*2)*math.cos(a*math.pi/180.0)/2.0
        y = sh/2 + (sh-pad*2)*math.sin(a*math.pi/180.0)/2.0
        g2.new_planet(GAME.bots[i+2], x,y, level.home_production, level.player_ships)
        a = a + 360/homes
    end
    for i=2,2 do
        x = sw/2 + (sw-pad*2)*math.cos(a*math.pi/180.0)/2.0
        y = sh/2 + (sh-pad*2)*math.sin(a*math.pi/180.0)/2.0
        g2.new_planet(GAME.bots[i%2+1], x,y, level.home_production, level.enemy_ships[GLOBAL.current_difficulty])
        a = a + 360/homes
    end
    x = sw/2 + (sw-pad*2)*math.cos(a*math.pi/180.0)/2.0
    y = sh/2 + (sh-pad*2)*math.sin(a*math.pi/180.0)/2.0
    g2.new_planet(GAME.player, x,y, level.home_production, level.player_ships)
    
    for i=1,level.neutrals do
        g2.new_planet(GAME.user_neutral, math.random(pad,sw-pad),math.random(pad,sh-pad), math.random(15,100), math.random(0,50));
    end
end

function init_custom_lv22()
    local level = LEVELS[GLOBAL.current_level]
    local pad = 50; local sw = GLOBAL.play_sw; local sh = GLOBAL.play_sh
    
    local player_x = math.random(pad*3,sw-pad*3)
    local player_y = math.random(pad*3,sh-pad*3)
    
    g2.new_planet(GAME.player, player_x, player_y, level.home_production, level.player_ships)
    g2.new_planet(GAME.bots[1], player_x + 1.5*math.random(-pad,pad), player_y + 1.5*math.random(-pad,pad), level.home_production, 2*level.enemy_ships[GLOBAL.current_difficulty])
    
    for i=1,5 do
        g2.new_planet(GAME.bots[2], math.random(pad,sw-pad),math.random(pad,sh-pad), math.random(90,100), 0.6*level.enemy_ships[GLOBAL.current_difficulty]);
    end
    for i=1,level.neutrals - 5 do
        g2.new_planet(GAME.user_neutral, math.random(pad,sw-pad),math.random(pad,sh-pad), math.random(15,100), math.random(0,50));
    end
end

function init_orbit()
    local level = LEVELS[GLOBAL.current_level]
    local pad = 150; local sw = GLOBAL.play_sw; local sh = GLOBAL.play_sh
    
    GAME.planet_data = {}
    for i=1,level.neutrals - 1 do
        GAME.planet_data[i] = {p = g2.new_planet(GAME.user_neutral, math.random(pad,sw-pad),math.random(pad,sh-pad), math.random(15,100), math.random(0,50)), rot_speed = 0.25};
    end
    GAME.planet_data[#GAME.planet_data + 1] = {p = g2.new_planet(GAME.player, math.random(pad,sw-pad),math.random(pad,sh-pad), level.home_production, level.player_ships), rot_speed = 0.25};
    local star = g2.new_planet(GAME.bots[1], sw/2, sh/2, 250, level.enemy_ships[GLOBAL.current_difficulty])
    for i=1,100 do
        star.position_x = sw/2
        star.position_y = sh/2
        g2.planets_settle()
    end
    g2.view_set(0, 0, GLOBAL.play_sw, GLOBAL.play_sh)
end

----- GAMEMODE-SPECIFIC LOOP FUNCITONS -----

function loop_wormhole(t)
    local level = LEVELS[GLOBAL.current_level]
    
    if g2.status ~= "Wave: 3/3" then
        g2.status = "Wave: "..GAME.wave_num.."/3  |  Time Left: "..time_left_text(GAME.time_left)
        time_left_beep()
    end
    
    GAME.time_left = GAME.time_left - t
    if GAME.time_left <= 0 and GAME.wave_num < 3 then
        GAME.time_left = level.TIMER_RESET[GLOBAL.current_difficulty]
        GAME.beeps_left = 3
        GAME.wave_num = GAME.wave_num + 1
        GAME.wormhole = g2.new_planet(GAME.bots[1], GLOBAL.play_sw/2, GLOBAL.play_sh/2, 200, 1000)
        local num_fleets = 12
        g2.play_sound("sfx-incoming")
        for i=1,num_fleets do
            g2_fleet_init(GAME.bots[1].n,level.enemy_ships[GLOBAL.current_difficulty],GAME.wormhole.n,find_to_wormhole(GAME.bots[1],GAME.wormhole).n)
        end
        GAME.wormhole:destroy()
        if GAME.wave_num == 3 and g2.status ~= "" then 
            g2.status = "Wave: 3/3"
        end
    end
end

function loop_invasion(t)
    local level = LEVELS[GLOBAL.current_level]
    
    if g2.status ~= "Wave: 3/3" then
        g2.status = "Wave: "..GAME.wave_num.."/3  |  Time Left: "..time_left_text(GAME.time_left)
        time_left_beep()
    end
    
    GAME.time_left = GAME.time_left - t
    if GAME.time_left <= 0 and GAME.wave_num < 3 then
        GAME.time_left = level.TIMER_RESET[GLOBAL.current_difficulty]
        GAME.beeps_left = 3
        GAME.wave_num = GAME.wave_num + 1
        GAME.wormhole = g2.new_planet(GAME.player, GLOBAL.play_sw/2, GLOBAL.play_sh/2, 200, 1000)
        local num_fleets = 14
        g2.play_sound("sfx-incoming")
        if GAME.wave_num == 3 then num_fleets = 15 end
        for i=1,num_fleets do
            g2_fleet_init(GAME.player.n,level.player_ships,GAME.wormhole.n,find_to_wormhole(GAME.bots[1],GAME.wormhole).n)
        end
        GAME.wormhole:destroy()
        if GAME.wave_num == 3 and g2.status ~= "" then 
            g2.status = "Wave: 3/3"
        end
    end
end

function loop_vacuum(t)
    local level = LEVELS[GLOBAL.current_level]
    
    if g2.status ~= "" then
        g2.status = "Time Left: "..time_left_text(GAME.time_left)
        time_left_beep()
    end
    
    GAME.time_left = GAME.time_left - t
    
    -- test whether the player controls all planets
    local win = nil
    GAME.won = true
    local planets = g2.search("planet")
    for _i,p in ipairs(planets) do
        local team = p:owner():team()
        if (win == nil) then win = team end
        if (win ~= team) then 
            GAME.won = false
        end
    end
    if GAME.won then
        if GLOBAL.current_level == GLOBAL.highest_level and GLOBAL.highest_level < 24 then 
            GLOBAL.highest_level = GLOBAL.highest_level + 1 
            save()
        end
        if GLOBAL.current_difficulty > GLOBAL.highest_ranks[GLOBAL.current_level] then
            GLOBAL.highest_ranks[GLOBAL.current_level] = GLOBAL.current_difficulty
            save()
        end
        init_post_game()
        return
    end
    if GAME.time_left <= 0 then
        init_post_game()
    end
end

function time_left_text(time_left)
    return math.floor((GAME.time_left+0.99)/60)..":"..zero_pad(math.floor((GAME.time_left+0.99)%60))
end
function time_left_beep()
    if GAME.wave_num == 0 then return end

    if (GAME.time_left <= 3 and GAME.beeps_left == 3) or
       (GAME.time_left <= 2 and GAME.beeps_left == 2) or
       (GAME.time_left <= 1 and GAME.beeps_left == 1) then
       g2.play_sound("sfx-beep")
       GAME.beeps_left = GAME.beeps_left - 1
    end
end

function loop_grinder(t)
    local level = LEVELS[GLOBAL.current_level]
    
    if g2.status ~= "" then
        g2.status = "Time Left: "..time_left_text(GAME.time_left)
        time_left_beep()
    end
    GAME.time_left = GAME.time_left - t
    if GAME.time_left <= 0 then
        GAME.time_left = level.TIMER_RESET[GLOBAL.current_difficulty]
        GAME.beeps_left = 3
        local planets = g2.search("planet team:"..GAME.player:team())
        local to = nil; local to_v = 0;
        for _i,p in ipairs(planets) do
            local v = p.ships_value + p.ships_production
            if (to==nil or v > to_v) then
                to_v = v;
                to = p;
            end
        end
        if to ~= nil then
            if level.game_mode == "grinder" then
                to:planet_chown(GAME.user_neutral)
                g2.play_sound("sfx-kazoom")
                for i=1,75 do
                    local xx = to.position_x;
                    local yy = to.position_y;
                    local rr = to.planet_r
                    local aa = i * 37
                    g2.new_part("p-chunk",5.0,
                            xx+rr*math.cos(aa),yy+rr*math.sin(aa),math.random(5,10),math.random(0,360),1.0,
                            35*math.random(-100,100)/100.0,
                            35*math.random(-100,100)/100.0,
                            0,
                            10*math.random(-100,100)/100.0,
                            -1.0/5.0)
                end
                to:destroy()
            elseif level.game_mode == "seduction" then
                to:planet_chown(GAME.bots[1])
                g2.play_sound("sfx-yum")
                for i=1,25 do
                    local xx = to.position_x;
                    local yy = to.position_y;
                    local rr = to.planet_r
                    local aa = i * 37
                    g2.new_part("p-heart",5.0,
                            xx+rr*math.cos(aa),yy+rr*math.sin(aa),math.random(10,15),math.random(0,360),1.0,
                            15*math.random(-100,100)/100.0,
                            15*math.random(-100,100)/100.0,
                            math.random(100,200)/100.0,
                            math.random(-100,100)/100.0,
                            -1.0/5.0)
                end
                    
            end
        end
    end
end

function loop_armistice(t)
    local level = LEVELS[GLOBAL.current_level]
    
    if g2.status ~= "" then
        if GAME.time_left < 0 then 
            GAME.player.ui_to_mask = 0xf
            GAME.bots[1].ui_to_mask = 0xf
            g2.status = ""
            return
        end
        if g2.status ~= "" then
            g2.status = "Time Left: "..time_left_text(GAME.time_left)
            time_left_beep()
        end
    else 
        return
    end
    GAME.time_left = GAME.time_left - t
end

function loop_orbit(t)
    local level = LEVELS[GLOBAL.current_level]
    
    for i,data in ipairs(GAME.planet_data) do
        local x0 = data.p.position_x; local y0 = data.p.position_y; local cx = GLOBAL.play_sw/2; local cy = GLOBAL.play_sh/2
        local point = rotate_point(x0, y0, cx, cy, data.rot_speed/dist(x0, y0, cx, cy))
        data.p.position_x = point.x
        data.p.position_y = point.y
    end
end