--------------------------------------------------------------------------------
-- NOTE: this is a wrapper for GalconQuest
-- It would be nice if GalconQuest itself was broken up into multiple modules
-- such as ProgressMap, Animations, PlayGame, WinGame, LoseGame, Credits, etc.
--------------------------------------------------------------------------------
function gqwrap_init()
    ENGINE.modules.gqwrap = ENGINE.modules.gqwrap or {}
    local obj = ENGINE.modules.gqwrap
    function obj:init() gq_init() end
    function obj:loop(t) gq_loop(t) end
    function obj:event(e)
        gq_event(e)
        if e.type == 'quit' and g2.quit == true then
            ENGINE.engine:next(ENGINE.modules.title)
            g2.quit = false
        end
    end
end
--------------------------------------------------------------------------------

function engine_init()
    ENGINE.engine = ENGINE.engine or {}
    ENGINE.modules = ENGINE.modules or {}
    local obj = ENGINE.engine

    function obj:next(module)
        ENGINE.module = module
        ENGINE.module:init()
    end
    
    function obj:init()
        self:next(ENGINE.modules.title)
    end
    
    function obj:event(e)
        return ENGINE.module:event(e)
    end
    
    function obj:loop(t)
        ENGINE.module:loop(t)
    end
end
--------------------------------------------------------------------------------
function mod_init()
    global("ENGINE")
    ENGINE = ENGINE or {}
    engine_init()
    title_init()
    gqwrap_init()
    about_init()
    tutorial_init()
    highs_init()
end
--------------------------------------------------------------------------------
function init() ENGINE.engine:init() end
function loop(t) ENGINE.engine:loop(t) end
function event(e) ENGINE.engine:event(e) end
--------------------------------------------------------------------------------
mod_init()