CREDITS = {
    "Galcon Legends",
    "",
    "",
    "",
    "Phil Hassey - Design",
    "",
    "Evan Sparano - Code",
    "",
    "Matt Kohr - Art",
    "",
    "Joshua Laya - Music",
    "",
    "Tim Inge - Music",
    "",
    "",
    "Simple DirectMedia Layer",
    "Copyright (C) 1997-2013",
    "Sam Lantinga",
    "",
    "stb_image, stb_vorbis",
    "Sean Barrett",
    "",
    "Icons made by Lorc",
    "Available at",
    "www.game-icons.net",
--     "",
--     "Brawndo is a trademark",
--     "of Omni Consumer",
--     "Products Corporation",
    "",
    "",
    "Galcon Legends",
    "Copyright (C) 2013",
    "Philip Hassey",
    "",
    "",
    "",
    "",
    "Be excellent",
    "to each other.",
    "",
    "",
}

RANKS = {
    {   full_name = "Cabin Boy", -- full name of rank
        name="Cabin Boy",  -- name of rank used on the map
        rand=0,            -- how random 0=100% random moves, 100=0% random moves.
        show_ships=1,      -- if ship counts are shown on screen
        redir=0            -- if the enemy can redirect (and the bot itself should be able to redirect)
    },
    {   full_name = "Ensign",
        name="Ensign",
        rand=0.25,
        show_ships=1,
        redir=0
    },
    {   full_name = "Lieutenant",
        name="Lieutenant",
        rand=0.5,
        show_ships=1,
        redir=0
    },
    {   full_name = "Commander",
        name="Commander",
        rand=0.5,
        show_ships=0,
        redir=0
    },
    {   full_name = "Captain",
        name="Captain",
        rand=0.75,
        show_ships=0,
        redir=0
    },
    {   full_name = "Admiral",
        name="Admiral",
        rand=1,
        show_ships=0,
        redir=0
    },
    {   full_name = "1-Stripe Admiral",
        name="1-Stripe\nAdmiral",
        rand=1,
        show_ships=0,
        redir=1
    },
    {   full_name = "2-Stripe Admiral",
        name="2-Stripe\nAdmiral",
        rand=1,
        show_ships=0,
        redir=1
    }, 
    {   full_name = "3-Stripe Admiral",
        name="3-Stripe\nAdmiral",
        rand=1,
        show_ships=0,
        redir=1
    },
    {   full_name = "Grand Admiral",
        name=" Grand\nAdmiral",
        rand=1,
        show_ships=0,
        redir=1
    }
}

-- *** ALL PIXEL DATA MEASURED ON 2048x1536 RESOLUTION ***
-- data used for selecting planets on the map
PLANETS = {
    {x=237,y=1284,r=22},
    {x=165,y=1112,r=26},
    {x=213,y=958,r=19},
    {x=351,y=983,r=20},
    {x=456,y=1056,r=26},
    {x=641,y=958,r=26},
    {x=660,y=669,r=18},
    {x=731,y=627,r=15},
    {x=852,y=464,r=26},
    {x=803,y=401,r=25},
    {x=1053,y=290,r=25},
    {x=1127,y=592,r=20},
    {x=1273,y=917,r=26},
    {x=1310,y=1099,r=34},
    {x=1493,y=1165,r=25},
    {x=1776,y=1076,r=41},
    {x=1718,y=906,r=31},
    {x=1827,y=449,r=27},
    {x=375,y=632,r=22},
    {x=790,y=859,r=24},
    {x=876,y=1013,r=38},
    {x=1133,y=862,r=20},
    {x=1678,y=1079,r=52}
}

-- data used for selecting wormholes on the map
WORMHOLES = {
    {x=1451,y=341,r=125},
    {x=550,y=337,r=125}
}

-- data used for positioning "connection" images
CONNECTIONS = {
    {name="conn_1",x=75,y=1191,w=349,h=319},
    {name="conn_2",x=127,y=1094,w=181,h=200},
    {name="conn_3",x=117,y=951,w=122,h=210}, 
    {name="conn_4",x=175,y=858,w=173,h=136},
    {name="conn_5",x=268,y=877,w=223,h=216},
    {name="conn_6",x=340,y=783,w=574,h=440}, 
    {name="conn_7",x=490,y=656,w=216,h=366},
    {name="conn_8",x=615,y=595,w=134,h=117},
    {name="conn_9",x=704,y=462,w=207,h=193}, 
    {name="conn_10",x=507,y=168,w=427,h=467},
    {name="conn_11",x=739,y=182,w=348,h=276},
    {name="conn_12",x=998,y=118,w=176,h=505}, 
    {name="conn_13",x=1090,y=553,w=286,h=353},
    {name="conn_14",x=1173,y=867,w=225,h=246},
    {name="conn_15",x=978,y=877,w=556,h=533}, 
    {name="conn_16",x=1448,y=989,w=326,h=218},
    {name="conn_17",x=1697,y=864,w=161,h=308},
    {name="conn_18",x=1569,y=56,w=479,h=914}, 
    {name="conn_19",x=5,y=313,w=567,h=492},
    {name="conn_20",x=304,y=560,w=508,h=284},
    {name="conn_21",x=703,y=751,w=184,h=280}, 
    {name="conn_22",x=808,y=798,w=351,h=312},
    {name="conn_23",x=1062,y=608,w=950,h=802}
}

-- data controlling setup of intro dialogue
INTRO_TEXTS = {
    {name="intro_text1",x=649,y=199,w=1057,h=338},
    {name="intro_text2",x=804,y=199,w=718,h=338}
}

-- data controlling setup of ending dialogue
ENDING_TEXTS = {
    {name="end_text1",x=978,y=424,w=909,h=268},
    {name="end_text2",x=352,y=225,w=913,h=415},
    {name="end_text3",x=1241,y=386,w=761,h=314},
    {name="end_text4",x=150,y=422,w=684,h=168}
}

-- data controlling the setup of each level
LEVELS = {
    -- Level 1
	{   bots={"Walter"},                                  -- a list of bots in the level
        music="mus-legends-walter",                       -- music to be played during the level
        ach = 'level1',
        title="Walter",
        player_ships=100,                                 -- how many ships on each player/ally home                       
        enemy_ships={50,65,75,75,85,100,100,120,135,150}, -- how many ships on each enemy home organized by increasing difficulty level
        homes=1,                                          -- how many "home" planets each player will start with
        neutrals=25,                                      -- how many neutral planets will be generated
        home_production=100,                              -- how much production home planets have
        game_mode="classic",                              -- game mode
        pre_images={                                      -- images to be displayed in the pre-game scene
            {name="buck-normal",x=-12,y=554,w=1194,h=982},
            {name="walter-normal",x=2069,y=462,w=-944,h=1076}
        },    
        tweens={1,2},                                     -- the tween direction of each image in pre_images  (0 = no tween, 1 = to right, 2 = to left)
        pre_texts = {                                     -- dialogue images to be displayed in the pre-game scene
            {name="level_1_text",x=566,y=169,w=1002,h=314}
        },                    
        background_image="background11",                  -- this level's background image
        win_images={                                      -- post-game images to be displayed if the level is beaten
            {name="buck-normal",x=1992,y=187,w=-1640,h=1349},
            {name="walter_loseb",x=0,y=0,w=999,h=758}
        },        
        lose_images={                                     -- post-game images to be displayed if the level is not beaten
            {name="walter-normal",x=1839,y=225,w=-1153,h=1314},
            {name="buck_loseb",x=0,y=0,w=999,h=758}
        }        
    },
    -- Level 2
    {   bots={"Ms. Magpie"}, 
        music="mus-legends-magpie",
        ach = 'level2',
        title = "Ms. Magpie",
        player_ships=100, 
        enemy_ships={50,65,75,75,85,100,100,120,135,150},
        homes=1, 
        neutrals=20, 
        home_production=100, 
        game_mode="classic", 
        pre_images={                                  
            {name="buck-fire",x=2032,y=458,w=-1458,h=1078},
            {name="magpie-lose",x=86,y=586,w=445,h=952}
        },    
        tweens={2,0},  
        pre_texts = {                                    
            {name="level_2_text",x=566,y=169,w=1002,h=314}
        },  
        background_image="background12", 
        win_images={                            
            {name="buck-normal",x=1992,y=187,w=-1640,h=1349},
            {name="magpie_loseb",x=0,y=0,w=999,h=758}
        },        
        lose_images={                            
            {name="magpie-win",x=1896,y=264,w=-889,h=1272},
            {name="buck_loseb",x=0,y=0,w=999,h=758}
        }        
    },
    -- Level 3
    {   bots={"Ms. Magpie"}, 
        music="mus-legends-magpie",
        title = "Ms. Magpie's Nest",
        player_ships=100, 
        enemy_ships={50,65,75,75,85,100,100,120,135,150},
        homes=2, 
        neutrals=25, 
        home_production=200, 
        game_mode="classic", 
        pre_images={                                  
            {name="buck-bonked",x=579,y=738,w=1340,h=941},
            {name="magpie-bonk",x=83,y=486,w=1327,h=1050}
        },  
        tweens={2,1}, 
        pre_texts = {                                    
            {name="level_3_text",x=794,y=202,w=926,h=314}
        },  
        background_image="background11", 
        win_images={                            
            {name="buck-normal",x=1992,y=187,w=-1640,h=1349},
            {name="magpie_loseb",x=0,y=0,w=999,h=758}
        },        
        lose_images={                            
            {name="magpie-win",x=1896,y=264,w=-889,h=1272},
            {name="buck_loseb",x=0,y=0,w=999,h=758}
        }     
    },
    -- Level 4
    {   bots={"Walter "}, 
        music="mus-legends-walter",
        title="Walter's Territory",
        player_ships=200, 
        enemy_ships={0,2,3,4,5,7,7,8,9,10},
        homes=2, 
        neutrals=27, 
        home_production=100, 
        game_mode="beast",
        pre_images={                                  
            {name="buck-lose",x=-2,y=591,w=596,h=945},
            {name="walter-up",x=2050,y=346,w=-1374,h=1193}
        },  
        tweens={1,2}, 
        pre_texts = {                                    
            {name="level_4_text",x=485,y=139,w=1002,h=314}
        },  
        background_image="background12", 
        win_images={                            
            {name="buck-normal",x=1992,y=187,w=-1640,h=1349},
            {name="walter_loseb",x=0,y=0,w=999,h=758}
        },        
        lose_images={                            
            {name="walter-normal",x=1839,y=225,w=-1153,h=1314},
            {name="buck_loseb",x=0,y=0,w=999,h=758}
        }             
    },
    -- Level 5
    {   bots={"Walter","Ms. Magpie"}, 
        music="mus-legends-walter",
        title="vs. Walter vs. Ms. Magpie",
        player_ships=500, 
        enemy_ships={30,40,50,55,60,70,70,80,100,120},
        homes=1, 
        neutrals=30, 
        home_production=15, 
        game_mode="custom_lv5", 
        pre_images={                                  
            {name="walter-lose",x=221,y=727,w=699,h=811},
            {name="magpie-win",x=1865,y=269,w=-886,h=1267}
        },  
        tweens={1,2}, 
        pre_texts = {                                    
            {name="level_5_text",x=575,y=123,w=863,h=314}
        },   
        background_image="background11", 
        win_images={                            
            {name="buck-normal",x=1992,y=187,w=-1640,h=1349},
            {name="walmag_loseb",x=0,y=0,w=999,h=758}
        },        
        lose_images={                            
            {name="walter-up",x=1528,y=555,w=-1132,h=983},
            {name="magpie-win",x=2055,y=523,w=-708,h=1013},
            {name="buck_loseb",x=0,y=0,w=999,h=758}        
        }    
    },
    -- Level 6
    {   bots={"Crab Lord"},
        music="mus-legends-crablord",
        title="Crab Lord Invasion",
        ach = 'level6',
        player_ships=200, 
        enemy_ships={15,16,19,22,25,28,28,30,32,34},
        homes=2, 
        neutrals=27, 
        home_production=100, 
        game_mode="wormhole", 
        TIMER_START={0,0,0,0,0,0,0,0,0,0},               -- in timed gamemodes, the number of seconds on the clock initially
        TIMER_RESET={30,30,30,30,30,30,30,30,30,30},     -- in timed gamemodes with multiple waves, the number of seconds added to the clock after a reset
        pre_images={                                  
            {name="toxicFactory",x=0,y=0,w=2048,h=1536},
            {name="slug-normal",x=107,y=866,w=616,h=670},
            {name="crablord-norm",x=1582,y=859,w=-753,h=677}
        },  
        tweens={0,1,2}, 
        pre_texts = {                                    
            {name="level_6_text",x=618,y=552,w=942,h=296}
        },   
        background_image="background1w", 
        win_images={                            
            {name="buck-normal",x=1992,y=187,w=-1640,h=1349},
            {name="crab_loseb",x=0,y=0,w=999,h=758}
        },        
        lose_images={                            
            {name="crablord-win",x=2049,y=430,w=-1149,h=1106},
            {name="buck_loseb",x=0,y=0,w=999,h=758}
        }     
    },
    -- Level 7
    {   bots={"The Phantom"}, 
        music="mus-legends-phantom",
        title="The Phantom",
        ach = 'level7',
        player_ships=100, 
        enemy_ships={40,55,65,65,75,90,90,110,125,140},
        homes=1, 
        neutrals=25, 
        home_production=100, 
        game_mode="classic", 
        pre_images={                            
            {name="buck-normal",x=-11,y=568,w=1177,h=968},
            {name="phantom-normal",x=1144,y=225,w=921,h=1413}
        },     
        tweens={1,2}, 
        pre_texts = {                                    
            {name="level_7_text",x=275,y=100,w=1002,h=381}
        },   
        background_image="background21", 
        win_images={                            
            {name="buck-normal",x=1992,y=187,w=-1640,h=1349},
            {name="phant_loseb",x=0,y=0,w=999,h=758}
        },        
        lose_images={                            
            {name="phantom-win",x=2118,y=79,w=-1153,h=1457},
            {name="buck_loseb",x=0,y=0,w=999,h=758}
        } 
    },
    -- Level 8
    {   bots={"Banjo King"}, 
        music="mus-legends-banjoking",
        title="Banjo King",
        ach = 'level8',
        player_ships=100, 
        enemy_ships={25,30,35,40,45,50,55,60,65,70},
        homes=1,
        neutrals=25, 
        home_production=100, 
        game_mode="classic", 
        pre_images={                            
            {name="banjoking-norm",x=-19,y=420,w=1046,h=1116},
            {name="buck-win",x=2081,y=-62,w=-989,h=1598}
        },   
        tweens={1,2}, 
        pre_texts = {                                    
            {name="level_8_text1",x=977,y=47,w=1057,h=314},
            {name="level_8_text2",x=77,y=127,w=803,h=314}
        },  
        background_image="background22", 
        win_images={                            
            {name="buck-normal",x=1992,y=187,w=-1640,h=1349},
            {name="banjok_loseb",x=0,y=0,w=999,h=758}
        },        
        lose_images={                            
            {name="banjoking-win",x=2102,y=223,w=-1170,h=1313},
            {name="buck_loseb",x=0,y=0,w=999,h=758}
        } 
    },
    -- Level 9
    {   bots={"The Phantom","Banjo King"}, 
        music="mus-legends-banjoking",
        title="The Phantom + Banjo King",
        player_ships=100, 
        enemy_ships={0,5,10,15,17,22,25,30,35,40},
        homes=5, 
        neutrals=30,
        home_production=15, 
        game_mode="custom_lv9", 
        pre_images={                            
            {name="phantom-win",x=-34,y=304,w=975,h=1232},
            {name="banjoking-win",x=2076,y=397,w=-1021,h=1146}
        },   
        tweens={1,2}, 
        pre_texts = {                                    
            {name="level_9_text",x=576,y=88,w=1057,h=314}
        },  
        background_image="background23", 
        win_images={                            
            {name="buck-normal",x=1992,y=187,w=-1640,h=1349},
            {name="banphant_loseb",x=0,y=0,w=999,h=758}
        },        
        lose_images={                            
            {name="banjoking-win",x=1717,y=463,w=-956,h=1073},
            {name="phantom-win",x=2146,y=320,w=-962,h=1216},
            {name="buck_loseb",x=0,y=0,w=999,h=758}
        } 
    },
    -- Level 10
    {   bots={"Zanthor"}, 
        music="mus-legends-zanthor",
        ach = 'level10',
        title="Zanthor",
        player_ships=100, 
        enemy_ships={10,15,20,30,45,60,60,70,80,90},
        homes=2, 
        neutrals=25, 
        home_production=100, 
        game_mode="custom_lv10", 
        pre_images={                            
            {name="buck-lose",x=2037,y=887,w=-409,h=649},
            {name="zanthor-normal",x=-11,y=276,w=1493,h=1260}
        },   
        tweens={2,1},  
        pre_texts = {                                    
            {name="level_10_text1",x=885,y=15,w=554,h=321},
            {name="level_10_text2",x=1473,y=306,w=554,h=571}
        }, 
        background_image="background21", 
        win_images={                            
            {name="buck-normal",x=1992,y=187,w=-1640,h=1349},
            {name="zanthor_loseb",x=0,y=0,w=999,h=758}
        },        
        lose_images={                            
            {name="zanthor-win",x=2429,y=239,w=-1486,h=1297},
            {name="buck_loseb",x=0,y=0,w=999,h=758}
        } 
    },
    -- Level 11
    {   bots={"Banjo King","Zanthor"}, 
        music="mus-legends-zanthor",
        title="Banjo King vs. Zanthor",
        teams={1,2},                                     -- which team each bot is on (1 = player's team, 2 = enemy team)
        player_ships=100, 
        enemy_ships={5,10,20,30,40,50,50,60,75,90},
        homes=1, 
        neutrals=25, 
        home_production=100, 
        game_mode="custom_lv11", 
        pre_images={                            
            {name="banjoking-lose",x=139,y=1050,w=408,h=486},
            {name="zanthor-win",x=2059,y=181,w=-1552,h=1355}
        },   
        tweens={1,2}, 
        pre_texts = {                                    
            {name="level_11_text1",x=521,y=116,w=554,h=257},
            {name="level_11_text2",x=94,y=707,w=390,h=314}
        }, 
        background_image="background22", 
        win_images={                            
            {name="banjoking-win",x=1825,y=452,w=-965,h=1084},
            {name="buck-normal",x=2318,y=296,w=-1507,h=1240},
            {name="zanthor_loseb",x=0,y=0,w=999,h=758}
        },        
        lose_images={                            
            {name="zanthor-win",x=2429,y=239,w=-1486,h=1297},
            {name="buck_loseb",x=0,y=0,w=999,h=758}
        } 
    },
    -- Level 12
    {   bots={}, 
        music="mus-legends-crablord",
        title="The Blockade",
        player_ships=200, 
        enemy_ships={0,0,0,0,0,0,0,0,0,0},
        homes=1, 
        neutrals=30, 
        home_production=100, 
        game_mode="vacuum", 
        TIMER_START={130,110,90,78,70,65,62,59,56,54},
        pre_images={                            
            {name="planet_grinder",x=241,y=155,w=1807,h=953},
            {name="crablord-win",x=1,y=984,w=731,h=703}
        },  
        tweens={0,1}, 
        pre_texts = {                                    
            {name="level_12_text",x=786,y=1152,w=1218,h=271}
        }, 
        background_image="background23", 
        win_images={                            
            {name="buck-normal",x=1992,y=187,w=-1640,h=1349},
            {name="crab_loseb",x=0,y=0,w=999,h=758}
        },        
        lose_images={                            
            {name="crablord-win",x=2049,y=430,w=-1149,h=1106},
            {name="buck_loseb",x=0,y=0,w=999,h=758}
        } 
    },
    -- Level 13
    {   bots={"Crab Lord"}, 
        music="mus-legends-crablord",
        title="Planet Grinder",
        player_ships=100, 
        enemy_ships={40,55,65,65,80,100,100,115,130,150},
        homes=1, 
        neutrals=25, 
        home_production=100, 
        game_mode="grinder", 
        TIMER_START={30,25,20,17,13,10,8,6,4,2},
        TIMER_RESET={40,30,25,20,17,15,12,10,8,6}, 
        pre_images={                            
            {name="planet_grinder",x=241,y=155,w=1807,h=953},
            {name="buck-lose",x=2037,y=887,w=-409,h=649},
        },  
        tweens={0,2},
        pre_texts = {                                    
            {name="level_13_text",x=585,y=1121,w=779,h=282}
        }, 
        background_image="background31", 
        win_images={                            
            {name="buck-normal",x=1992,y=187,w=-1640,h=1349},
            {name="crab_loseb",x=0,y=0,w=999,h=758}
        },        
        lose_images={                            
            {name="crablord-win",x=2049,y=430,w=-1149,h=1106},
            {name="buck_loseb",x=0,y=0,w=999,h=758}
        } 
    },
    -- Level 14
    {   bots={"Crab Lord","Ms. Magpie"}, 
        music="mus-legends-magpie",
        title="vs. Crab Lord vs. Ms. Magpie",
        player_ships=100, 
        enemy_ships={60,75,85,100,120,150,150,200,250,300},
        homes=1, 
        neutrals=30, 
        home_production=100, 
        game_mode="symmetric", 
        pre_images={                            
            {name="buck-normal",x=-310,y=510,w=1247,h=1026},
            {name="crablord-win",x=2271,y=611,w=-1073,h=1033},
            {name="magpie-bonk",x=537,y=573,w=1141,h=963}
        },  
        tweens={0,0,1}, 
        pre_texts = {                                    
            {name="level_14_text",x=696,y=206,w=1102,h=353}
        },  
        background_image="background32", 
        win_images={                            
            {name="buck-normal",x=1992,y=187,w=-1640,h=1349},
            {name="magcrab_loseb",x=0,y=0,w=999,h=758}
        },        
        lose_images={                            
            {name="crablord-win",x=1927,y=540,w=-1034,h=996},
            {name="magpie-win",x=2055,y=523,w=-708,h=1013},
            {name="buck_loseb",x=0,y=0,w=999,h=758}
        } 
    },
    -- Level 15
    {   bots={"Crab Lord","The Phantom"}, 
        music="mus-legends-phantom",
        title="Crab Lord + The Phantom",
        teams={2,2}, 
        player_ships=100, 
        enemy_ships={50,65,75,75,85,100,100,115,130,140},
        homes=1, 
        neutrals=30, 
        home_production=100, 
        game_mode="custom_lv15", 
        pre_images={                            
            {name="phantom-normal",x=9,y=253,w=897,h=1376},
            {name="crablord-norm",x=2047,y=420,w=-1242,h=1116}
        },  
        tweens={1,2}, 
        pre_texts = {                                    
            {name="level_15_text",x=625,y=85,w=942,h=335}
        },  
        background_image="background31", 
        win_images={                            
            {name="buck-normal",x=1992,y=187,w=-1640,h=1349},
            {name="phancrab_loseb",x=0,y=0,w=999,h=758}
        },        
        lose_images={                            
            {name="crablord-win",x=1927,y=540,w=-1034,h=996},
            {name="phantom-win",x=2146,y=320,w=-962,h=1216},
            {name="buck_loseb",x=0,y=0,w=999,h=758}
        } 
    },
    -- Level 16
    {   bots={"Crab Lord","The Phantom","Walter ","Ms. Magpie"}, 
        music="mus-legends-phantom",
        title="Us vs. Them",
        teams={2,2,1,1}, 
        player_ships=150, 
        enemy_ships={70,75,80,85,90,95,95,103,110,117},
        homes=1, 
        neutrals=30, 
        home_production=100, 
        game_mode="custom_lv16",
        pre_images={                            
            {name="walter-down",x=4,y=396,w=1159,h=1142},
            {name="magpie-normal",x=1356,y=309,w=618,h=1227}
        },  
        tweens={1,0}, 
        pre_texts = {                                    
            {name="level_16_text",x=438,y=72,w=763,h=314}
        },
        background_image="background32", 
        win_images={                            
            {name="buck-normal",x=1609,y=567,w=-1178,h=969},
            {name="walter-up",x=1957,y=593,w=-1088,h=945},
            {name="magpie-win",x=2140,y=572,w=-674,h=964},
            {name="phancrab_loseb",x=0,y=0,w=999,h=758}
        },        
        lose_images={                            
            {name="crablord-win",x=1927,y=540,w=-1034,h=996},
            {name="phantom-win",x=2146,y=320,w=-962,h=1216},
            {name="buck_loseb",x=0,y=0,w=999,h=758}
        } 
    },
    -- Level 17
    {   bots={"Crab Lord","Crab Lord","Banjo King"}, 
        music="mus-legends-banjoking",
        title="Banjo King vs. Crab Lord",
        teams={2,2,1}, 
        player_ships=150, 
        enemy_ships={80,90,100,110,125,140,140,155,170,180},
        homes=1, 
        neutrals=30, 
        home_production=100, 
        game_mode="grinder", 
        TIMER_START={30,25,20,17,13,10,8,6,4,3},
        TIMER_RESET={40,30,25,20,17,15,12,10,8,6}, 
        pre_images={                            
            {name="banjoking-win",x=2079,y=381,w=-1029,h=1155},
            {name="crablord-lose",x=-17,y=518,w=853,h=1018}
        },  
        tweens={2,1}, 
        pre_texts = {                                    
            {name="level_17_text",x=576,y=88,w=947,h=314}
        },
        background_image="background31", 
        win_images={                            
            {name="banjoking-win",x=1825,y=452,w=-965,h=1084},
            {name="buck-normal",x=2318,y=296,w=-1507,h=1240},
            {name="crab_loseb",x=0,y=0,w=999,h=758}
        },        
        lose_images={                            
            {name="crablord-win",x=2049,y=430,w=-1149,h=1106},
            {name="buckban_loseb",x=0,y=0,w=999,h=758}
        } 
    },
    -- Level 18
    {   bots={"Slug Princess"}, 
        music="mus-legends-princess",
        title="The Invasion",
        ach = 'level18',
        player_ships=40,
        enemy_ships={0,3,10,15,19,21,21,23,25,27},
        homes=1, 
        neutrals=30, 
        home_production=100, 
        game_mode="invasion",
        TIMER_START={0,0,0,0,0,0,0,0,0,0},
        TIMER_RESET={30,30,30,30,30,30,30,30,30,30},
        pre_images={                            
            {name="octopus",x=163,y=7,w=1722,h=1324}
        },  
        pre_texts = {                                    
            {name="level_18_text",x=770,y=1175,w=901,h=314}
        },
        background_image="background3w", 
        win_images={                            
            {name="buck-normal",x=1992,y=187,w=-1640,h=1349},
            {name="slug_loseb",x=0,y=0,w=999,h=758}
        },        
        lose_images={                            
            {name="slug-win",x=2053,y=283,w=-1057,h=1255},
            {name="buck_loseb",x=0,y=0,w=999,h=758}
        } 
    },
    -- Level 19
    {   bots={"Slug Princess"}, 
        music="mus-legends-princess",
        title="The Armistice",
        player_ships=100, 
        enemy_ships={60,75,90,105,120,140,140,180,220,250},
        homes=1, 
        neutrals=30, 
        home_production=100, 
        game_mode="armistice", 
        TIMER_START={30,30,30,30,30,30,30,30,30,30},
        pre_images={                            
            {name="slug-lose",x=2097,y=607,w=-1018,h=929},
            {name="buck-fire",x=-7,y=483,w=1424,h=1053}
        },  
        tweens={2,1}, 
        pre_texts = {                                    
            {name="level_19_text",x=359,y=153,w=1057,h=250}
        },
        background_image="background41", 
        win_images={                            
            {name="buck-normal",x=1992,y=187,w=-1640,h=1349},
            {name="slug_loseb",x=0,y=0,w=999,h=758}
        },        
        lose_images={                            
            {name="slug-win",x=2053,y=283,w=-1057,h=1255},
            {name="buck_loseb",x=0,y=0,w=999,h=758}
        } 
    },
    -- Level 20
    {   bots={"Slug Princess"}, 
        music="mus-legends-princess",
        title="The Seduction",
        player_ships=200, 
        enemy_ships={100,120,140,150,160,170,170,180,190,200},
        homes=1, 
        neutrals=25, 
        home_production=100, 
        game_mode="seduction", 
        TIMER_START={30,25,20,17,13,10,8,7,6,5},
        TIMER_RESET={40,35,30,26,23,20,16,14,12,10}, 
        pre_images={                            
            {name="slug-win",x=-14,y=594,w=794,h=942},
--             {name="brawndo",x=1665,y=870,w=322,h=666},
--             {name="buck-win",x=1727,y=133,w=-869,h=1403,}
            {name="buck-chest",x=1727,y=133,w=-869,h=1403}
        },  
        tweens={1,0,2}, 
        pre_texts = {                                    
            {name="level_20_text1",x=22,y=176,w=839,h=421},
            {name="level_20_text2",x=1262,y=191,w=782,h=409}
        },
        background_image="background42",
        win_images={                            
            {name="buck-normal",x=1992,y=187,w=-1640,h=1349},
            {name="slug_loseb",x=0,y=0,w=999,h=758}
        },        
        lose_images={                            
            {name="slug-win",x=2053,y=283,w=-1057,h=1255},
            {name="buck_loseb",x=0,y=0,w=999,h=758}
        } 
    },
    -- Level 21
    {   bots={"Slug Princess"}, 
        music="mus-legends-princess",
        title="Fair Fight",
        player_ships=100, 
        enemy_ships={60,75,85,85,95,110,110,125,140,155},
        homes=1,
        neutrals=25, 
        home_production=100, 
        game_mode="symmetric", 
        pre_images={                            
            {name="background4m",x=0,y=0,w=2048,h=1536},
            {name="slug-normal",x=206,y=424,w=551,h=600},
            {name="buck-normal",x=2060,y=264,w=-992,h=759}
        },   
        tweens={0,1,2,1,2}, 
        pre_texts = {                                    
            {name="level_21_text",x=550,y=202,w=887,h=241}
        }, 
        background_image="background41", 
        win_images={                            
            {name="buck-normal",x=1992,y=187,w=-1640,h=1349},
            {name="slug_loseb",x=0,y=0,w=999,h=758}
        },        
        lose_images={                            
            {name="slug-win",x=2053,y=283,w=-1057,h=1255},
            {name="buck_loseb",x=0,y=0,w=999,h=758}
        } 
    },
    -- Level 22
    {   bots={"Slug Princess","Zanthor "}, 
        music="mus-legends-zanthor",
        title="Slug Princess + Zanthor",
        teams={2,2}, 
        player_ships=500, 
        enemy_ships={60,70,80,95,100,110,120,130,140,150},
        homes=1, 
        neutrals=30, 
        home_production=100, 
        game_mode="custom_lv22", 
        pre_images={                            
            {name="zanthor-lose",x=-23,y=201,w=1487,h=1335},
            {name="slug-normal",x=1963,y=1176,w=-331,h=360}
        }, 
        tweens={1,0}, 
        pre_texts = {                                    
            {name="level_22_text1",x=1441,y=719,w=599,h=421},
            {name="level_22_text2",x=963,y=252,w=477,h=257}
        },  
        background_image="background42", 
        win_images={                            
            {name="buck-normal",x=1992,y=187,w=-1640,h=1349},
            {name="slugzan_loseb",x=0,y=0,w=999,h=758}
        },        
        lose_images={                            
            {name="zanthor-win",x=2594,y=229,w=-1497,h=1307},
            {name="slug-win",x=1428,y=988,w=-461,h=548},
            {name="buck_loseb",x=0,y=0,w=999,h=758}
        } 
    },
    -- Level 23 
    {   bots={"Slug Princess"}, 
        title="Final Battle",
        music="mus-legends-princess",
        player_ships=20000, 
        enemy_ships={19500,19600,19700,19800,19950,20150,20150,20250,20320,20400},
        homes=1, 
        neutrals=15, 
        home_production=60, 
        game_mode="orbit",  
        pre_images={                            
            {name="final_battle",x=0,y=0,w=2048,h=1536},
        }, 
        pre_texts = {                                    
            {name="level_23_text",x=709,y=1159,w=645,h=165}
        }, 
        background_image="background4w", 
        win_images={                            
            {name="buck-normal",x=1992,y=187,w=-1640,h=1349},
            {name="slug_loseb",x=0,y=0,w=999,h=758}
        },        
        lose_images={                            
            {name="slug-win",x=2053,y=283,w=-1057,h=1255},
            {name="buck_loseb",x=0,y=0,w=999,h=758}
        } 
    }
}

-- a pre-game message to be shown at each level
MESSAGES = {
    -- Level 1
	"Walter takes the brute force approach to life. "..
    "He hopes to overwhelm you with his massive "..
    "herd of stampeding ships. "..
    "He sends all of his ships directly to your "..
    "planet with the most ships on it. "..
    "\n\n"..
    "Tip: Send your ships to several large (high production) "..
    "planets with few ships on them (small number). "..
    "You'll quickly out-produce Walter and "..
    "be able to take him out.",
    -- Level 2
	"Ms. Magpie has a decent understanding of "..
    "basic strategy.  She carefully picks good "..
    "high-production low-cost planets "..
    "that are nearby. "..
    "\n\n"..
    "Tip: Mimic her strategy.  When it comes to "..
    "attacks, be sure to take her planets when "..
    "you think they have few ships on them.",
    -- Level 3
    "In this mission, both Buck and Ms. Magpie get two "..
    "MEGA-PLANETS.  These planets have production "..
    "set at 200 (double the typical maximum)! "..
    "\n\n"..
    "Tip: To win, you need to out-produce Ms. Magpie. "..
    "This can be accomplished by trying to keep "..
    "two mega-planets at all times while capturing "..
    "a few of the better non-mega planets. "..
    "It's okay to lose a mega-planet as long as you "..
    "grab one of Ms. Magpie's planets soon after.",
    -- Level 4
    "Stepping into Walter's main territory gives him "..
    "a huge advantage, as he owns all the planets. "..
    "Fortunately, he's pretty slow-moving.  You start "..
    "out with a huge mass of ships, so as long as you "..
    "quickly spread out he won't be able to keep up. "..
    "\n\n"..
    "Tip: Be sure not to leave a large cache of ships "..
    "on any one planet.  Walter will target it and "..
    "decimate your fleet.",
    -- Level 5
    "Three-way battles require you to decide which "..
    "(or both) of the opponents you will destroy "..
    "first.  If you play your cards right, often "..
    "your opponents will destroy each other. "..
    "\n\n"..
    "Tip: Try to take a few medium-sized planets and "..
    "watch the balance of play.  Let your opponents "..
    "waste ships fighting over the mega-planets. "..
    "Once you've built up a sizeable fleet, attack!",
    -- Level 6
    "The evil Crab Lord is trying to smuggle his "..
    "planet grinder into the Galaxy without paying "..
    "appropriate tariffs.  You must stop him "..
    "by defeating three waves of invasion. "..
    "\n\n"..
    "Tip: Let the enemy tire himself out on neutral "..
    "planets.  Take and hold high production "..
    "planets and defend them.  Try to wipe out "..
    "each invasion before the next wave hits.",
    -- Level 7
    "The Phantom's fleets are completely invisible. "..
    "His strategy is similar to Ms. Magpie's, "..
    "though not as strategic. "..
    "\n\n"..
    "Tip: Although his fleets are invisible, watch "..
    "carefully and you can see explosions when "..
    "a planet is under the Phantom's attack. "..
    "You can also see the ship count go down "..
    "on planets that are under attack.",
    -- Level 8
    "The Banjo King is able to send his fleets "..
    "at 3x normal speed.  Although he sticks "..
    "with a fairly basic strategy, his speed "..
    "makes him a tough opponent. "..
    "\n\n"..
    "Tip: If you can hold your own for a minute "..
    "or two, he'll run out of ships and become "..
    "easy to conquer.",
    -- Level 9
    "The Phantom and Banjo King are brawling and "..
    "you get in the way.  Since it's a free-for-all, "..
    "you'll need to be careful what planets you take. "..
    "\n\n"..
    "Tip: Try taking over the smaller planets while "..
    "your enemies waste ships fighting over "..
    "the big ones. Watch the balance of play so "..
    "neither of your opponents gains a big advantage. "..
    "Try not to take planets that are under attack.",
    -- Level 10
    "Zanthor likes high production planets.  He can be "..
    "intimidating because of his large number of ships, "..
    "but his strategy is easy to take advantage of. "..
    "\n\n"..
    "Tip: Move your ships off your home planets "..
    "immediately.  Take over all of Zanthor's small "..
    "planets and as many neutrals as possible. "..
    "Clean up behind Zanthor as he moves and evacuate "..
    "ships off all planets under attack.",
    -- Level 11
    "With Zanthor on the attack, you've got to give "..
    "the Banjo King a hand.  With the King on "..
    "your side you've got a decent chance. "..
    "\n\n"..
    "Tip: Send reinforcements to the Banjo King "..
    "as soon as you can to keep him in the game.",
    -- Level 12
    "The Crab Lord was foiled in his last "..
    "attempt to bring his PLANET GRINDER into "..
    "the galaxy.  But the Crab Lord does not "..
    "give up easily!  You must set up a "..
    "blockade to forestall his invasion. "..
    "\n\n"..
    "Tip: In this round you will be fighting "..
    "no enemies but the clock.  You must take "..
    "over all neutral planets before the time "..
    "runs out.  To beat the clock, never let "..
    "ships sit idle on a planet.",
    -- Level 13
    "The Crab Lord ground his way through your "..
    "blockade and is now wreaking havoc.  If you "..
    "do not save the Galaxy from destruction, "..
    "corporate bill collection will become a thing "..
    "of the past.  You would face unemployment! "..
    "\n\n"..
    "Tip: The planet grinder targets your "..
    "well-stocked high-production planets. "..
    "Watch the clock and keep your ships "..
    "moving constantly.  When the planet grinder "..
    "strikes you lose that planet and all "..
    "the ships on it.  FOREVER!",
    -- Level 14
    "You get caught in a three-way battle "..
    "with Ms. Magpie and the Crab Lord. "..
    "On the plus side, the Crab Lord's PLANET "..
    "GRINDER is clogged with feathers and is "..
    "in the shop. "..
    "\n\n"..
    "Tip: Watch the balance of play and target "..
    "the stronger opponent.  This is a "..
    "symmetrical level and each player has an "..
    "identical starting position.",
    -- Level 15
    "With the promise of power, the Phantom has "..
    "agreed to aid the Crab Lord in his nefarious "..
    "plot to take over the Galaxy. "..
    "\n\n"..
    "Tip: The Crab Lord is the more formidable "..
    "opponent, so it is wise to concentrate your "..
    "efforts on him first.  But keep an eye "..
    "out for signs of the Phantom.",
    -- Level 16
    "Ms. Magpie and Walter have offered their "..
    "help in defeating the powerful evil force "..
    "that is terrorizing the galaxy. "..
    "\n\n"..
    "Tip: Work with your teammates, Ms. Magpie "..
    "and Walter.  Feed them ships as necessary "..
    "to ensure their survival.",
    -- Level 17
    "The Crab Lord's PLANET GRINDER is out "..
    "of the shop and resuming its trail of "..
    "destruction.  Team up with the Banjo King "..
    "to defeat the Crab Lord and his PLANET "..
    "GRINDER once and for all! "..
    "\n\n"..
    "Tip: With the planet grinder back it is "..
    "important to remember not to stash too "..
    "many ships on any one planet. "..
    "The Banjo King is your ally, so make "..
    "sure he doesn't die.",
    -- Level 18
    "The Slug Princess has destroyed your "..
    "flagship and retreated back into her own "..
    "galaxy.  You must pursue her via wormhole "..
    "and seek REVENGE! "..
    "\n\n"..
    "Tip: Try to survive each round so that your "..
    "landing fleet grows a bit each wave.",
    -- Level 19
    "Under the Polite Conversation Proclamation, "..
    "no party is allowed to attack another "..
    "until 30 seconds have elapsed. "..
    "\n\n"..
    "Tip: Watch where the Slug Princess sends "..
    "her fleets and send more of yours at the same "..
    "planet.  Make sure that you take over more and "..
    "better planets before battle begins.",
    -- Level 20
    "Using her \"charm\", the Slug Princess is able to "..
    "make the planets you conquer revolt to her side. "..
    "\n\n"..
    "Tip: Keep your ships moving!  You don't want "..
    "a planet to be \"seduced\" when it is loaded "..
    "with ships, because they will become part "..
    "of the Slug Princess' fleet.",
    -- Level 21
    "This mission presents a true test of "..
    "your skill against the Slug Princess. "..
    "The level is actually a mirror image. "..
    "\n\n"..
    "Tip: It's skill against skill alone. "..
    "Good luck!",
    -- Level 22
    "Oh no!  The Slug Princess has hired muscle. "..
    "Time to show her what you've got!! "..
    "\n\n"..
    "Tip: Try to concentrate your attacks on "..
    "the Slug Princess.  You can take care "..
    "of Zanthor afterwards.",
    -- Level 23
    "You are invading the evil heart of the "..
    "Slug Princess' domain.  Her fortress is on a central "..
    "planet surrounded by orbiting moons. "..
    "Be careful! "..
    "\n\n"..
    "Tip: It's a crazy ride.  Enjoy the trip!",
}