-- data controlling the behavior of each bot
-- the rest of the bot's custom behavior is in its loop() function

BOTS = {
    -- normal Walter
    {   name="Walter",                                       -- the bot's name
        color=0x0000ff,                                      -- the bot's color
        wait={5,3.33,2.25,2.25,1.5,1.2,1.1,1,0.9,0.7},       -- how long between bot loop() calls, in order of increasing difficulty
        loop="bot_walter"                                    -- the bot's loop() function
    },
    -- faster Walter
    {   name="Walter ",
        color=0x0000ff,
        wait={4,3,2,2,1.4,1,1,0.8,0.6,0.5},
        loop="bot_walter"
    }, 
    -- Ms. Magpie
    {   name="Ms. Magpie",
        color=0x80ffff,
        wait={5,3.33,2.25,2.25,1.5,1.2,1.1,1,0.9,0.7},
        loop="bot_magpie"
    },
    -- Crab Lord
    {   name="Crab Lord",
        color=0xff0000,
        wait={4,3,2,2,1.4,1,1,0.8,0.6,0.5},
        loop="bot_crab_lord"
    },
    -- Phantom
    {   name="The Phantom",
        color=0x8000ff,
        wait={5,3.33,2.25,2.25,1.5,1.2,1.1,1,0.9,0.7},
        loop="bot_phantom"
    },
    -- Banjo King
    {   name="Banjo King",
        color=0xffff00,
        wait={5,3.33,2.25,2.25,1.5,1.2,1.1,1,0.9,0.7},
        loop="bot_banjo_king"
    },
    -- normal Zanthor
    {   name="Zanthor",
        color=0xff8000,
        wait={12,12,12,11,10,8,6,4,3,2},
        loop="bot_zanthor"
    },
    -- faster Zanthor
    {   name="Zanthor ",
        color=0xff8000,
        wait={10,10,10,9,7,4,3,2,1.5,1},
        loop="bot_zanthor"
    }, 
    -- Slug Princess
    {   name="Slug Princess",
        color=0xff80ff,
        wait={5,3.33,2.25,2.25,1.5,1.2,1.1,1,0.9,0.7},
        loop="bot_slug_princess"
    },
}

-- return bot data
function get_bot_data(name)
    for _i,bot_data in ipairs(BOTS) do
        if (bot_data.name == name) then
            return bot_data
        end
    end
end

function bot_standard(user,perc,to_query,to_eval)
    -- default value
    if to_query == nil then to_query = "planet -owner:"..user end
    if GLOBAL.finish and user.ui_to_mask ~= 0x7 then to_query = "planet -team:"..user:team().." -neutral" end
    -- fire from planets
    local from = find("planet owner:"..user,function(p) return p.ships_value end)
    if (from ~= nil) then
        local to
        if math.random() > RANKS[GLOBAL.current_difficulty].rand and not GLOBAL.finish then
            to = find("planet",function(p) return math.random(0,99999) end)
        else
            to = find(to_query,to_eval,from)
        end
        if (to ~= nil) then from:fleet_send(perc,to) end
    end
    -- redirect 
    if RANKS[GLOBAL.current_difficulty].redir == 1 then
        do_redirect(user,to_query,to_eval)
    end
end

function ships_prod(p) if p.ships_production_enabled then return 1 end return 0 end

function bot_walter(user)
    bot_standard(user,75,"planet -team:"..user:team().." -neutral",function(p,from) return 2*p.ships_value + p.ships_production - from:distance(p)*0.18 end)
end

function bot_magpie(user)
    bot_standard(user,60,nil,function(p,from) return -0.6*p.ships_value*(2 - ships_prod(p)) + p.ships_production - from:distance(p)*0.17 end)
end

function bot_crab_lord(user)
    bot_standard(user,65,nil,function(p,from) return -0.7*p.ships_value*(2 - 1.5*ships_prod(p)) + p.ships_production - from:distance(p)*0.18 end)
end

function bot_phantom(user)
    bot_standard(user,55,nil,function(p,from) return -0.8*p.ships_value*(2 - 1.2*ships_prod(p)) + p.ships_production - from:distance(p)*0.16 end)
end

function bot_banjo_king(user)
    bot_standard(user,75,nil,function(p,from) return -1.5*p.ships_value*(2 - 0.7*ships_prod(p)) + p.ships_production - from:distance(p)*0.17 end)
end

function bot_slug_princess(user)
    local to_query
    if user.ui_to_mask == 0x7 then
        to_query = "planet team:"..GAME.user_neutral:team()
    else
        to_query = "planet -team:"..user:team()
    end
    bot_standard(user,65,to_query,function(p,from) return -0.7*p.ships_value*(2 - 1.2*ships_prod(p)) + p.ships_production - from:distance(p)*0.18 end)
end

function bot_zanthor(user)
    local planets = g2.search("planet owner:"..user.n);
    for _i,from in ipairs(planets) do
        if (from ~= nil) then
            local to
            to = find("planet -team:"..user:team(),function(p) return p.ships_production end)
            if (to ~= nil) then from:fleet_send(70,to) end
        end
    end
end

function find_to_wormhole(user,from)
    return find("planet",function(p) if (p.ships_value < 23 or p.ships_production_enabled == 1) then return math.random(0,99999) else return -1 end end)
end

function do_redirect(user,to_query,to_eval)
    local fleets = g2.search("fleet owner:"..user);
    for _i,from in ipairs(fleets) do
        to = find(to_query,to_eval,from)
        local player = GAME.player
        local skip = false
        if user:team() == player:team() and g2.item(from.fleet_target):owner() == player then
            skip = true
        end
        if skip == false then
            if to ~= nil then
                from:fleet_redirect(to)
            end
        end
        -- don't redirect every fleet....
        if math.random() < 0.5 then break end
    end
end