; The CMD file.
;
; Two parts: 1. Command definition and  2. State entry
; (state entry is after the commands def section)
;
; 1. Command definition
; ---------------------
; Note: The commands are CASE-SENSITIVE, and so are the command names.
; The eight directions are:
;   B, DB, D, DF, F, UF, U, UB     (all CAPS)
;   corresponding to back, down-back, down, downforward, etc.
; The six buttons are:
;   a, b, c, x, y, z               (all lower case)
;   In default key config, abc are are the bottom, and xyz are on the
;   top row. For 2 button characters, we recommend you use a and b.
;   For 6 button characters, use abc for kicks and xyz for punches.
;
; Each [Command] section defines a command that you can use for
; state entry, as well as in the CNS file.
; The command section should look like:
;
;   [Command]
;   name = some_name
;   command = the_command
;   time = time (optional)
;   buffer.time = time (optional)
;
; - some_name
;   A name to give that command. You'll use this name to refer to
;   that command in the state entry, as well as the CNS. It is case-
;   sensitive (QCB_a is NOT the same as Qcb_a or QCB_A).
;
; - command
;   list of buttons or directions, separated by commas. Each of these
;   buttons or directions is referred to as a "symbol".
;   Directions and buttons can be preceded by special characters:
;   slash (/) - means the key must be held down
;          egs. command = /D       ;hold the down direction
;               command = /DB, a   ;hold down-back while you press a
;   tilde (~) - to detect key releases
;          egs. command = ~a       ;release the a button
;               command = ~D, F, a ;release down, press fwd, then a
;          If you want to detect "charge moves", you can specify
;          the time the key must be held down for (in game-ticks)
;          egs. command = ~30a     ;hold a for at least 30 ticks, then release
;   dollar ($) - Direction-only: detect as 4-way
;          egs. command = $D       ;will detect if D, DB or DF is held
;               command = $B       ;will detect if B, DB or UB is held
;   plus (+) - Buttons only: simultaneous press
;          egs. command = a+b      ;press a and b at the same time
;               command = x+y+z    ;press x, y and z at the same time
;   greater-than (>) - means there must be no other keys pressed or released
;                      between the previous and the current symbol.
;          egs. command = a, >~a   ;press a and release it without having hit
;                                  ;or released any other keys in between
;   You can combine the symbols:
;     eg. command = ~30$D, a+b     ;hold D, DB or DF for 30 ticks, release,
;                                  ;then press a and b together
;
;   Note: Successive direction symbols are always expanded in a manner similar
;         to this example:
;           command = F, F
;         is expanded when MUGEN reads it, to become equivalent to:
;           command = F, >~F, >F
;
;   It is recommended that for most "motion" commads, eg. quarter-circle-fwd,
;   you start off with a "release direction". This makes the command easier
;   to do.
;
; - time (optional)
;   Time allowed to do the command, given in game-ticks. The default
;   value for this is set in the [Defaults] section below. A typical
;   value is 15.
;
; - buffer.time (optional)
;   Time that the command will be buffered for. If the command is done
;   successfully, then it will be valid for this time. The simplest
;   case is to set this to 1. That means that the command is valid
;   only in the same tick it is performed. With a higher value, such
;   as 3 or 4, you can get a "looser" feel to the command. The result
;   is that combos can become easier to do because you can perform
;   the command early. Attacks just as you regain control (eg. from
;   getting up) also become easier to do. The side effect of this is
;   that the command is continuously asserted, so it will seem as if
;   you had performed the move rapidly in succession during the valid
;   time. To understand this, try setting buffer.time to 30 and hit
;   a fast attack, such as KFM's light punch.
;   The default value for this is set in the [Defaults] section below. 
;   This parameter does not affect hold-only commands (eg. /F). It
;   will be assumed to be 1 for those commands.
;
; If you have two or more commands with the same name, all of them will
; work. You can use it to allow multiple motions for the same move.
;
; Some common commands examples are given below.
;
; [Command] ;Quarter circle forward + x
; name = "QCF_x"
; command = ~D, DF, F, x
;
; [Command] ;Half circle back + a
; name = "HCB_a"
; command = ~F, DF, D, DB, B, a
;
; [Command] ;Two quarter circles forward + y
; name = "2QCF_y"
; command = ~D, DF, F, D, DF, F, y
;
; [Command] ;Tap b rapidly
; name = "5b"
; command = b, b, b, b, b
; time = 30
;
; [Command] ;Charge back, then forward + z
; name = "charge_B_F_z"
; command = ~60$B, F, z
; time = 10
;
; [Command] ;Charge down, then up + c
; name = "charge_D_U_c"
; command = ~60$D, U, c
; time = 10


;-| Button Remapping |-----------------------------------------------------
; This section lets you remap the player's buttons (to easily change the
; button configuration). The format is:
;   old_button = new_button
; If new_button is left blank, the button cannot be pressed.
[Remap]
x = x
y = y
z = z
a = a
b = b
c = c
s = s

;AI Start----------------------------------------------------------------------------

; AI Activation
[Command]
name = "cpu1"
command = U, U, U, U, F, B, B, F, B, B, B, B, U, U, U, D, D, D, D, a, a, a, a, a, b, b, b, b, b, b
time = 1

[Command]
name = "cpu2"
command = U, U, U, D, F, B, B, F, x, x, x, x, x, y, y, y, a, a, a, D ,B, a, F, F
time = 1

[Command]
name = "cpu3"
command = U, U, D, D, F, B, B, F, F, a, a, a, F, U, D ,B, a, F, F, B, F, F, a, a, a
time = 1

[Command]
name = "cpu4"
command = U, D, D, D, F, B, B, F, D, F, F, F, F, F, F, F, x, a, b, x, a, y
time = 1

[Command]
name = "cpu5"
command = D, D, D, D, F, B, B, F, x, a, y, D, F, F, F, F, U, U, U, U, D, D, D, D, F
time = 1

[Command]
name = "cpu6"
command = x, y, a, b, x, y, a, b, x, y, a, b, x, y, a, b, x, y, a, b, x, y, a, b, B, B, B, B, B, B, F, F, F, F, D, D, D
time = 1

[Command]
name = "cpu7"
command = D, D, U, U, F, B, B, F ,x ,y ,y ,y ,a ,a ,a ,a ,D ,D ,D ,D ,D ,D ,D ,x ,x ,x ,x ,x ,x ,x ,x ,a ,a ,a ,a ,a ,a
time = 1

[Command]
name = "cpu8"
command = D, U, U, U, F, B, B, F, B, B, B, B, B, B, B, B, a, a, a, a, a, x, x, x, x, y, y, y, a, a, D, U, D, B, D
time = 1

[Command]
name = "cpu9"
command = x, x, x, x, x, y, y, y, y, y, a, a, a, a, a, b, b, b, b, b, D, D, D, D, U, D, U, U, F, B, B, F
time = 1

[Command]
name = "cpu10"
command = U, U, D, U, F, B, B, F, D, U, U, D, F, B, D, F, x, y, a, b, D, F, x, y, a, b, D, F, x, y, a, b, D, F, x, y, a, b
time = 1

[Command]
name = "cpu11"
command = D, U, U, D, F, B, B, F, U, F, B, B, F, D, D, D, D, D, D, D, D, D, F, F, F, F, F, B, B, B, B, B, x, x, x, x, x, y, y, y, y, y, a, a, a, a, a, b, b, b, b, b, D
time = 1

[Command]
name = "cpu12"
command = b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b,b
time = 1

[Command]
name = "cpu13"
command = a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a,a
time = 1

[Command]
name = "cpu14"
command = y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y,y
time = 1

[Command]
name = "cpu15"
command = x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x
time = 1

;-| Default Values |-------------------------------------------------------
[Defaults]
; Default value for the "time" parameter of a Command. Minimum 1.
command.time = 15

; Default value for the "buffer.time" parameter of a Command. Minimum 1,
; maximum 30.
command.buffer.time = 1


;-| Super Motions |--------------------------------------------------------
[Command]
name = "Smokin Jab"
command = ~D, DF, F, x
time = 20

[Command]
name = "Smokin Jab"   ;Same name as above
command = ~D, DF, F, y
time = 20

[Command]
name = "Smoking Blast"
command = ~D, DF, F, a
time = 20

[Command]
name = "Smoking Blast"   ;Same name as above
command = ~D, DF, F, b
time = 18

;-| Special Motions |------------------------------------------------------
[Command]
name = "Smoke Dash"
command = ~D, DB, x
time = 20

[Command]
name = "Smoke Twister"
command = ~D, B, a
time = 20

[Command]
name = "Tashigi"
command = x+y
time = 20

[Command]
name = "Marines"
command = c
time = 20

[Command]
name = "2p"
command = a
time = 20

[Command]
name = "2p"
command = b
time = 20

[Command]
name = "2p"
command = x
time = 20

[Command]
name = "2p"
command = y
time = 20

;-| Double Tap |-----------------------------------------------------------
[Command]
name = "FF"     ;Required (do not remove)
command = F, F
time = 10

[Command]
name = "BB"     ;Required (do not remove)
command = B, B
time = 10

;-| 2/3 Button Combination |-----------------------------------------------
[Command]
name = "recovery";Required (do not remove)
command = x+y
time = 1

[Command]
name = "recovery";Required (do not remove)
command = x+y
time = 1

[Command]
name = "recovery";Required (do not remove)
command = y+x
time = 1

[Command]
name = "recovery";Required (do not remove)
command = a+b
time = 1

[Command]
name = "recovery";Required (do not remove)
command = b+a
time = 1

[Command]
name = "recovery";Required (do not remove)
command = x+a
time = 1

[Command]
name = "recovery";Required (do not remove)
command = y+b
time = 1

[Command]
name = "recovery";Required (do not remove)
command = y
time = 1

[Command]
name = "recovery";Required (do not remove)
command = x
time = 1

[Command]
name = "recovery";Required (do not remove)
command = a
time = 1

[Command]
name = "recovery";Required (do not remove)
command = b
time = 1

;-| Dir + Button |---------------------------------------------------------
[Command]
name = "down_a"
command = /$D,a
time = 1

[Command]
name = "down_b"
command = /$D,b
time = 1

;-| Single Button |---------------------------------------------------------
[Command]
name = "a"
command = a
time = 1

[Command]
name = "b"
command = b
time = 1

[Command]
name = "c"
command = c
time = 1

[Command]
name = "x"
command = x
time = 1

[Command]
name = "y"
command = y
time = 1

[Command]
name = "z"
command = z
time = 1

[Command]
name = "start"
command = s
time = 1

;-| Hold Dir |--------------------------------------------------------------
[Command]
name = "holdfwd";Required (do not remove)
command = /$F
time = 1

[Command]
name = "holdback";Required (do not remove)
command = /$B
time = 1

[Command]
name = "holdup" ;Required (do not remove)
command = /$U
time = 1

[Command]
name = "holddown";Required (do not remove)
command = /$D
time = 1

[Command]
name = "hold_b"
command = /z

;---------------------------------------------------------------------------
; 2. State entry
; --------------
; This is where you define what commands bring you to what states.
;
; Each state entry block looks like:
;   [State -1, Label]           ;Change Label to any name you want to use to
;                               ;identify the state with.
;   type = ChangeState          ;Don't change this
;   value = new_state_number
;   trigger1 = command = command_name
;   . . .  (any additional triggers)
;
; - new_state_number is the number of the state to change to
; - command_name is the name of the command (from the section above)
; - Useful triggers to know:
;   - statetype
;       S, C or A : current state-type of player (stand, crouch, air)
;   - ctrl
;       0 or 1 : 1 if player has control. Unless "interrupting" another
;                move, you'll want ctrl = 1
;   - stateno
;       number of state player is in - useful for "move interrupts"
;   - movecontact
;       0 or 1 : 1 if player's last attack touched the opponent
;                useful for "move interrupts"
;
; Note: The order of state entry is important.
;   State entry with a certain command must come before another state
;   entry with a command that is the subset of the first.
;   For example, command "fwd_a" must be listed before "a", and
;   "fwd_ab" should come before both of the others.
;
; For reference on triggers, see CNS documentation.
;
; Just for your information (skip if you're not interested):
; This part is an extension of the CNS. "State -1" is a special state
; that is executed once every game-tick, regardless of what other state
; you are in.


; Don't remove the following line. It's required by the CMD standard.
[Statedef -1]

;===========================================================================
;---------------------------------------------------------------------------
;Triple Kung Fu Palm (uses one super bar)
;OJt[˂iQ[WxPj
[State -1, Smokin Jab]
type = ChangeState
value = 3000
triggerall = command = "Smokin Jab"
triggerall = power >= 2000
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = statetype != A
trigger2 = hitdefattr = SC, NA, SA, HA
trigger2 = stateno != [3000,3050)

;---------------------------------------------------------------------------
;Triple Kung Fu Palm (uses one super bar)
;OJt[˂iQ[WxPj
[State -1, Smoking Blast]
type = ChangeState
value = 3001
triggerall = command = "Smoking Blast"
triggerall = power >= 1000
trigger1 = statetype = S
trugger1 = numhelper < 666
trigger1 = ctrl
trigger2 = hitdefattr = SC, NA, SA, HA
trigger2 = time < 50

;===========================================================================
;This is not a move, but it sets up var(1) to be 1 if conditions are right
;for a combo into a special move (used below).
;Since a lot of special moves rely on the same conditions, this reduces
;redundant logic.
[State -1, Combo condition Reset]
type = VarSet
trigger1 = 1
var(1) = 0

[State -1, Combo condition Check]
type = VarSet
trigger1 = statetype != A
trigger1 = ctrl
trigger2 = (stateno = [200,299]) || (stateno = [400,499])
trigger2 = stateno != 440 ;Except for sweep kick
trigger2 = movecontact
var(1) = 1

;==========================================================================
; AI Activation
[State -1, AI On]
type = VarSet
triggerall = RoundState = 2
trigger1 = command = "cpu1"
trigger2 = command = "cpu2"
trigger3 = command = "cpu3"
trigger4 = command = "cpu4"
trigger5 = command = "cpu5"
trigger6 = command = "cpu6"
trigger7 = command = "cpu7"
trigger8 = command = "cpu8"
trigger9 = command = "cpu9"
trigger10 = command = "cpu10"
trigger11 = command = "cpu11"
trigger12 = command = "cpu12"
trigger13 = command = "cpu13"
trigger14 = command = "cpu14"
trigger15 = command = "cpu15"
var(58) = 1

[State -1, AI Off]
type = VarSet
triggerall = !Win
trigger1 = !alive
trigger2 = roundstate <= 1
trigger3 = roundstate >= 3
var(58) = 0

;---------------------------------------------------------------------------
;Run Fwd
[State -1, Run Fwd]
type = ChangeState
value = 100
trigger1 = command = "FF"
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------
;Run Back
[State -1, Run Back]
type = ChangeState
value = 105
trigger1 = command = "BB"
trigger1 = statetype = S
trigger1 = ctrl

;===========================================================================
;---------------------------------------------------------------------------
[State -1, Charging]
type = ChangeState
value = 1400
triggerall = var(59) = 0
triggerall = command = "hold_b"
triggerall = power != powermax
trigger1 = statetype != A && ctrl

;---------------------------------------------------------------------------
[State -1, Smoke Dash]
type = ChangeState
value = 777
triggerall = command = "Smoke Dash"
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------
[State -1, Smoke Twister]
type = ChangeState
value = 3002
triggerall = command = "Smoke Twister"
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------
;Tashigi helper
[State -1,Tashigi Helper]
type = ChangeState
value = 8800
triggerall = command = "Tashigi"
triggerall = numhelper(25000) = 0
trigger1 = statetype != A
trigger1 = ctrl = 1

;---------------------------------------------------------------------------
;Marines helper
[State -1,Marines Helper]
type = ChangeState
value = 8801
triggerall = command = "Marines"
triggerall = numhelper(35000) = 0
trigger1 = statetype != A
trigger1 = ctrl = 1

;---------------------------------------------------------------------------
; Alpha Counter
[State -1, Counter]
type = ChangeState
value = 900
triggerall = power >= 10
triggerall = command = "2p"
triggerall = statetype != A
trigger1 = !var(0)
trigger1 = stateno = 150
trigger2 = stateno = 151
trigger3 = stateno = 152
trigger4 = stateno = 153

;---------------------------------------------------------------------------
;Stand Light Punch
[State -1, Stand Light Punch]
type = ChangeState
value = 200
triggerall = command = "x"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------
;Stand Strong Punch
[State -1, Stand Strong Punch]
type = ChangeState
value = 210
triggerall = command = "y"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = (stateno = 200) && time > 16
trigger3 = (stateno = 230) && time > 18

;---------------------------------------------------------------------------
;Stand Light Kick
[State -1, Stand Light Kick]
type = ChangeState
value = 230
triggerall = command = "a"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = (stateno = 200) && time > 16
trigger3 = (stateno = 230) && time > 18

;---------------------------------------------------------------------------
;Standing Strong Kick
[State -1, Standing Strong Kick]
type = ChangeState
value = 240
triggerall = command = "b"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = (stateno = 200) && time > 16
trigger3 = (stateno = 230) && time > 18

;---------------------------------------------------------------------------
;Taunt
[State -1, Taunt]
type = ChangeState
value = 195
triggerall = command = "start"
trigger1 = statetype != A
trigger1 = ctrl

;---------------------------------------------------------------------------
;Crouching Light Punch
;Ⴊݎp`
[State -1, Crouching Light Punch]
type = ChangeState
value = 400
triggerall = command = "x"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
trigger2 = stateno=410&&movecontact
trigger3 = stateno=430&&movecontact
trigger4 = stateno=440&&movecontact

;---------------------------------------------------------------------------
;Crouching Strong Punch
;Ⴊ݋p`
[State -1, Crouching Strong Punch]
type = ChangeState
value = 410
triggerall = command = "y"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
trigger2 = stateno=400&&movecontact
trigger3 = stateno=430&&movecontact
trigger4 = stateno=440&&movecontact

;---------------------------------------------------------------------------
;Crouching Light Kick
;ႪݎLbN
[State -1, Crouching Light Kick]
type = ChangeState
value = 430
triggerall = command = "a"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
trigger2 = stateno=400&&movecontact
trigger3 = stateno=410&&movecontact
trigger4 = stateno=440&&movecontact

;---------------------------------------------------------------------------
;Crouching Strong Kick
;Ⴊ݋LbN
[State -1, Crouching Strong Kick]
type = ChangeState
value = 440
triggerall = command = "b"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
trigger2 = stateno=400&&movecontact
trigger3 = stateno=410&&movecontact
trigger4 = stateno=430&&movecontact

;---------------------------------------------------------------------------
;Jump Light Punch
;󒆎p`
[State -1, Jump Light Punch]
type = ChangeState
value = 600
triggerall = command = "x"
trigger1 = statetype = A
trigger1 = ctrl
trigger2 = stateno = 600
trigger2 = statetime >= 11
trigger3 = stateno = 1350 ;Air blocking

;---------------------------------------------------------------------------
;Jump Strong Punch
[State -1, Jump Strong Punch]
type = ChangeState
value = 610
triggerall = command = "y"
trigger1 = statetype = A
trigger1 = ctrl
trigger2 = stateno = 600 || stateno = 630 ;jump_x or jump_a
trigger2 = movecontact
trigger3 = stateno = 1350 ;Air blocking

;---------------------------------------------------------------------------
;Jump Light Kick
[State -1, Jump Light Kick]
type = ChangeState
value = 630
triggerall = command = "a"
trigger1 = statetype = A
trigger1 = ctrl
trigger2 = stateno = 1350 ;Air blocking

;---------------------------------------------------------------------------
;Jump Strong Kick
;󒆋LbN
[State -1, Jump Strong Kick]
type = ChangeState
value = 640
triggerall = command = "b"
trigger1 = statetype = A
trigger1 = ctrl
trigger2 = stateno = 600 || stateno = 630 ;jump_x or jump_a
trigger2 = movecontact
trigger3 = stateno = 1350 ;Air blocking

;===========================================================================
; Smoker's Block Techniques
;---------------------------------------------------------------------------
[State -1, Counter AI]
type = ChangeState
triggerall = !win
triggerall = var(58) = 1
triggerall = power >= 10
triggerall = StateType = S
triggerall = p2movetype = A
triggerall = p2bodydist x <= 50
trigger1 = stateno = 150
trigger2 = stateno = 151
trigger3 = stateno = 152
trigger4 = stateno = 153
value = 900

;---------------------------------------------------------------------------
[State -1, Guard AI]
type = ChangeState
triggerall = !win
triggerall = var(58) = 1
triggerall = StateType = S
trigger1 = p2movetype = A
trigger1 = movetype != A
trigger1 = ctrl
value = 120

;===========================================================================
; Smoker's Basics
;----------------------------------------------------------------------------
[State -1, Stand Light PunchAI]
type = ChangeState
value = 200
triggerall = !win
triggerall = var(58) = 1
triggerall = (roundstate = 2) && (var(58))
triggerall = p2bodydist X < 20
triggerall = random <= 12
triggerall = statetype != A
trigger1 = ctrl
trigger2 = movecontact
trigger2 = time = 38
trigger2 = hitdefattr = SC, NA, SA
trigger2 = stateno=210&&movecontact
trigger3 = stateno=230&&movecontact
trigger4 = stateno=240&&movecontact

;----------------------------------------------------------------------------
[State -1, Stand Strong PunchAI]
type = ChangeState
value = 210
triggerall = !win
triggerall = var(58) = 1
triggerall = (roundstate = 2) && (var(58))
triggerall = p2bodydist X < 84
triggerall = random < 19
triggerall = statetype != A
trigger1 = ctrl
trigger2 = movecontact
trigger2 = time = 38
trigger2 = hitdefattr = SC, NA, SA
trigger2 = stateno=200&&movecontact
trigger3 = stateno=230&&movecontact
trigger4 = stateno=240&&movecontact

;----------------------------------------------------------------------------
[State -1, Stand Light KickAI]
type = ChangeState
value = 230
triggerall = !win
triggerall = var(58) = 1
triggerall = (roundstate = 2) && (var(58))
triggerall = p2bodydist X < 84
triggerall = random < 15
triggerall = statetype != A
trigger1 = ctrl
trigger2 = movecontact
trigger2 = time = 38
trigger2 = hitdefattr = SC, NA, SA
trigger2 = stateno=200&&movecontact
trigger3 = stateno=210&&movecontact
trigger4 = stateno=240&&movecontact

;---------------------------------------------------------------------------
[State -1, Standing Strong KickAI]
type = ChangeState
value = 240
triggerall = !win
triggerall = var(58) = 1
triggerall = (roundstate = 2) && (var(58))
triggerall = p2bodydist X < 84
triggerall = random <11
triggerall = statetype != A
trigger1 = ctrl
trigger2 = movecontact
trigger2 = time = 38
trigger2 = hitdefattr = SC, NA, SA
trigger2 = stateno=200&&movecontact
trigger3 = stateno=210&&movecontact
trigger4 = stateno=230&&movecontact

;---------------------------------------------------------------------------
[State -1, Crouching Light PunchAI]
type = ChangeState
value = 400
triggerall = !win
triggerall = var(58) = 1
triggerall = (roundstate = 2) && (var(58))
triggerall = p2bodydist X < 84
triggerall = random < 17
triggerall = statetype != A
trigger1 = ctrl
trigger2 = movecontact
trigger2 = time = 38
trigger2 = hitdefattr = SC, NA, SA
trigger2 = stateno=410&&movecontact
trigger3 = stateno=430&&movecontact
trigger4 = stateno=440&&movecontact

;---------------------------------------------------------------------------
[State -1, Crouching Strong PunchAI]
type = ChangeState
value = 410
triggerall = !win
triggerall = var(58) = 1
triggerall = (roundstate = 2) && (var(58))
triggerall = p2bodydist X < 84
triggerall = random < 18
triggerall = statetype != A
trigger1 = ctrl
trigger2 = movecontact
trigger2 = time = 38
trigger2 = hitdefattr = SC, NA, SA
trigger2 = stateno=400&&movecontact
trigger3 = stateno=430&&movecontact
trigger4 = stateno=440&&movecontact

;---------------------------------------------------------------------------
[State -1, Crouching Light KickAI]
type = ChangeState
value = 430
triggerall = !win
triggerall = var(58) = 1
triggerall = (roundstate = 2) && (var(58))
triggerall = p2bodydist X < 84
triggerall = random < 19
triggerall = statetype != A
trigger1 = ctrl
trigger2 = movecontact
trigger2 = time = 38
trigger2 = hitdefattr = SC, NA, SA
trigger2 = stateno=400&&movecontact
trigger3 = stateno=410&&movecontact
trigger4 = stateno=440&&movecontact

;---------------------------------------------------------------------------
[State -1, Crouching Strong KickAI]
type = ChangeState
value = 440
triggerall = !win
triggerall = var(58) = 1
triggerall = (roundstate = 2) && (var(58))
triggerall = p2bodydist X < 84
triggerall = random < 10
triggerall = statetype != A
trigger1 = ctrl
trigger2 = movecontact
trigger2 = time = 38
trigger2 = hitdefattr = SC, NA, SA
trigger2 = stateno=400&&movecontact
trigger3 = stateno=410&&movecontact
trigger4 = stateno=430&&movecontact

;---------------------------------------------------------------------------
[State -1, Jump Light PunchAI]
type = ChangeState
value = 600
triggerall = !win
triggerall = var(58) = 1
triggerall = (roundstate = 2) && (var(58))
triggerall = p2bodydist X < 84
triggerall = random < 31
triggerall = statetype != S
trigger1 = ctrl
trigger2 = movecontact
trigger2 = time = 38
trigger2 = hitdefattr = SC, NA, SA
trigger2 = stateno=640&&movecontact

;---------------------------------------------------------------------------
[State -1, Jump Strong PunchAI]
type = ChangeState
value = 610
triggerall = !win
triggerall = var(58) = 1
triggerall = (roundstate = 2) && (var(58))
triggerall = p2bodydist X < 84
triggerall = random < 32
triggerall = statetype != S
trigger1 = ctrl
trigger2 = movecontact
trigger2 = hitdefattr = SC, NA, SA

;---------------------------------------------------------------------------
[State -1, Jump Light KickAI]
type = ChangeState
value = 630
triggerall = !win
triggerall = var(58) = 1
triggerall = (roundstate = 2) && (var(58))
triggerall = p2bodydist X < 84
triggerall = random < 33
triggerall = statetype != S
trigger1 = ctrl
trigger2 = movecontact
trigger2 = hitdefattr = SC, NA, SA
trigger2 = stateno=610&&movecontact

;---------------------------------------------------------------------------
[State -1, Jump Strong KickAI]
type = ChangeState
value = 640
triggerall = !win
triggerall = var(58) = 1
triggerall = (roundstate = 2) && (var(58))
triggerall = p2bodydist X < 84
triggerall = random < 34
triggerall = statetype != S
trigger1 = ctrl
trigger2 = hitdefattr = SC, NA, SA

;===========================================================================
; Smoker's Supers (Level 3 AI)
;---------------------------------------------------------------------------
;N/A
;===========================================================================
; Smoker's Supers (Level 2 AI)
;---------------------------------------------------------------------------
[State -1, Smokin JabAI]
type = ChangeState
value = 3000
triggerall = !win
triggerall = var(58) = 1
triggerall = (roundstate = 2) && (var(58))
triggerall = !p2bodydist X < 84
triggerall = random < 7
triggerall = statetype != A
triggerall = power >= 2000
trigger1 = ctrl
trigger2 = hitdefattr = SC, NA, SA

;===========================================================================
; Smoker's Supers (Level 1 AI)
;---------------------------------------------------------------------------
[State -1, Smoking BlastAI]
type = ChangeState
value = 3001
triggerall = !win
triggerall = var(58) = 1
triggerall = (roundstate = 2) && (var(58))
triggerall = p2bodydist X < 84
triggerall = random < 8
triggerall = statetype != A
triggerall = power >= 1000
trigger1 = ctrl
trigger2 = hitdefattr = SC, NA, SA

;===========================================================================
; Smoker's Specials AI
;---------------------------------------------------------------------------
[State -1, Smoke DashAI]
type = ChangeState
value = 777
triggerall = !win
triggerall = var(58) = 1
triggerall = (roundstate = 2) && (var(58))
triggerall = p2bodydist X < 84
triggerall = random < 6
triggerall = statetype != A
trigger1 = ctrl
trigger2 = hitdefattr = SC, NA, SA

;-----------------------------------------------------------------------------
[State -1, Smoke TwisterAI]
type = ChangeState
value = 3002
triggerall = !win
triggerall = var(58) = 1
triggerall = (roundstate = 2) && (var(58))
triggerall = p2bodydist X < 84
triggerall = random < 3
triggerall = statetype != A
trigger1 = ctrl
trigger2 = hitdefattr = SC, NA, SA
