; The CMD file.
;
; Two parts: 1. Command definition and  2. State entry
; (state entry is after the commands def section)
;
; 1. Command definition
; ---------------------
; Note: The commands are CASE-SENSITIVE, and so are the command names.
; The eight directions are:
;   B, DB, D, DF, F, UF, U, UB     (all CAPS)
;   corresponding to back, down-back, down, downforward, etc.
; The six buttons are:
;   a, b, c, x, y, z               (all lower case)
;   In default key config, abc are are the bottom, and xyz are on the
;   top row. For 2 button characters, we recommend you use a and b.
;   For 6 button characters, use abc for kicks and xyz for punches.
;
; Each [Command] section defines a command that you can use for
; state entry, as well as in the CNS file.
; The command section should look like:
;
;   [Command]
;   name = some_name
;   command = the_command
;   time = time (optional -- defaults to 15 if omitted)
;
; - some_name
;   A name to give that command. You'll use this name to refer to
;   that command in the state entry, as well as the CNS. It is case-
;   sensitive (QCB_a is NOT the same as Qcb_a or QCB_A).
;
; - command
;   list of buttons or directions, separated by commas.
;   Directions and buttons can be preceded by special characters:
;   slash (/) - means the key must be held down
;          egs. command = /D       ;hold the down direction
;               command = /DB, a   ;hold down-back while you press a
;   tilde (~) - to detect key releases
;          egs. command = ~a       ;release the a button
;               command = ~D, F, a ;release down, press fwd, then a
;          If you want to detect "charge moves", you can specify
;          the time the key must be held down for (in game-ticks)
;          egs. command = ~30a     ;hold a for at least 30 ticks, then release
;   dollar ($) - Direction-only: detect as 4-way
;          egs. command = $D       ;will detect if D, DB or DF is held
;               command = $B       ;will detect if B, DB or UB is held
;   plus (+) - Buttons only: simultaneous press
;          egs. command = a+b      ;press a and b at the same time
;               command = x+y+z    ;press x, y and z at the same time
;   You can combine them:
;     eg. command = ~30$D, a+b     ;hold D, DB or DF for 30 ticks, release,
;                                  ;then press a and b together
;   It's recommended that for most "motion" commads, eg. quarter-circle-fwd,
;   you start off with a "release direction". This matches the way most
;   popular fighting games implement their command detection.
;
; - time (optional)
;   Time allowed to do the command, given in game-ticks. Defaults to 15
;   if omitted
;
; If you have two or more commands with the same name, all of them will
; work. You can use it to allow multiple motions for the same move.
;
; Some common commands examples are given below.
;
; [Command] ;Quarter circle forward + x
; name = "QCF_x"
; command = ~D, DF, F, x
;
; [Command] ;Half circle back + a
; name = "HCB_a"
; command = ~F, DF, D, DB, B, a
;
; [Command] ;Two quarter circles forward + y
; name = "2QCF_y"
; command = ~D, DF, F, D, DF, F, y
;
; [Command] ;Tap b rapidly
; name = "5b"
; command = b, b, b, b, b
; time = 30
;
; [Command] ;Charge back, then forward + z
; name = "charge_B_F_z"
; command = ~60$B, F, z
; time = 10
; 
; [Command] ;Charge down, then up + c
; name = "charge_D_U_c"
; command = ~60$D, U, c
; time = 10
; 

;-| Button Remapping |-----------------------------------------------------
; This section lets you remap the player's buttons (to easily change the
; button configuration). The format is:
;   old_button = new_button
; If new_button is left blank, the button cannot be pressed.
[Remap]
x = x
y = y
z = z
a = a
b = b
c = c
s = s

;-| Default Values |-------------------------------------------------------
[Defaults]
; Default value for the "time" parameter of a Command. Minimum 1.
command.time = 30

; Default value for the "buffer.time" parameter of a Command. Minimum 1,
; maximum 30.
command.buffer.time = 1

;-| Super Motions |--------------------------------------------------------

;-| Special Motions |------------------------------------------------------

;-| Double Tap |-----------------------------------------------------------
;---|AI Commands|-----------------------------------------------------------
[Command]
name = "AI1"
command = D,D,D,F,F,F,a+b+c+x+y+z
time = 1

[Command]
name = "AI2"
command = D,D,D,F,F,U,a+b+c+x+y+z
time = 1

[Command]
name = "AI3"
command = D,D,D,F,F,UF,a+b+c+x+y+z
time = 1

[Command]
name = "AI4"
command = D,D,D,F,F,D,a+b+c+x+y+z
time = 1

[Command]
name = "AI5"
command = D,D,D,F,F,DF,a+b+c+x+y+z
time = 1

[Command]
name = "AI6"
command = D,D,D,F,F,B,a+b+c+x+y+z
time = 1

[Command]
name = "AI7"
command = D,D,D,F,F,DB,a+b+c+x+y+z
time = 1

[Command]
name = "AI8"
command = D,D,D,F,F,UB,a+b+c+x+y+z
time = 1

[Command]
name = "AI9"
command = D,D,D,F,U,F,a+b+c+x+y+z
time = 1

[Command]
name = "AI10"
command = D,D,D,F,UF,F,a+b+c+x+y+z
time = 1

[Command]
name = "AI11"
command = D,D,D,F,DF,F,a+b+c+x+y+z
time = 1

[Command]
name = "AI12"
command = D,D,D,F,D,F,a+b+c+x+y+z
time = 1

[Command]
name = "AI13"
command = D,D,D,F,DB,F,a+b+c+x+y+z
time = 1

[Command]
name = "AI14"
command = D,D,D,F,B,F,a+b+c+x+y+z
time = 1

[Command]
name = "AI15"
command = D,D,D,F,UB,F,a+b+c+x+y+z
time = 1

[Command]
name = "AI16"
command = D,D,D,F,F,F,a+b+c+x+y,z
time = 1

[Command]
name = "AI17"
command = D,D,D,F,F,F,a+b+c+x,y,z
time = 1

[Command]
name = "AI18"
command = D,D,D,F,F,F,a+b+c,x,y,z
time = 1

[Command]
name = "AI19"
command = D,D,D,F,F,F,a+b,c,x,y,z
time = 1

[Command]
name = "AI20"
command = D,D,D,F,F,F,a,b,c,x,y,z
time = 1

[Command]
name = "AI21"
command = D,D,D,F,F,F,a+b+c,x+y+z
time = 1

[Command]
name = "AI22"
command = D,D,D,F,F,U,a+b,c+x+y+z
time = 1

[Command]
name = "AI23"
command = D,D,D,F,F,UF,a,b+c+x+y+z
time = 1

[Command]
name = "AI24"
command = D,D,D,F,F,U,a+b,c+x+y+z
time = 1

[Command]
name = "AI25"
command = D,D,D,F,F,DF,a,b,c+x+y+z
time = 1

[Command]
name = "AI26"
command = D,D,D,F,F,B,a+b,c+x,y+z
time = 1

[Command]
name = "AI27"
command = D,D,D,F,F,DB,a,b+c+x,y+z
time = 1

[Command]
name = "AI28"
command = D,D,D,F,F,UB,a,b+c+x+y,z
time = 1

[Command]
name = "AI29"
command = DF,D,D,F,U,F,a+b+c+x+y+z
time = 1

[Command]
name = "AI30"
command = B,D,D,F,UF,F,a+b+c+x+y+z
time = 1

[Command]
name = "AI31"
command = B,B,BD,F,DF,F,a+b+c+x+y+z
time = 1

[Command]
name = "AI32"
command = D,F,F,F,D,F,a+b+c+x+y+z
time = 1

[Command]
name = "AI33"
command = DF,D,DF,UF,DB,F,a+b+c+x+y+z
time = 1

[Command]
name = "AI34"
command = D,D,D,F,DB,DF,a+b+c+x+y+z
time = 1

[Command]
name = "AI35"
command = D,D,UF,DF,UB,UF,a+b+c+x+y+z
time = 1

[Command]
name = "AI36"
command = D,DF,DF,DF,DF,F,a+b+c+x+y,z
time = 1

[Command]
name = "AI37"
command = D,D,DB,UF,DF,UF,a+b+c+x,y,z
time = 1

[Command]
name = "AI38"
command = F,U,F,F,F,F,a,b+c,x,y,z
time = 1

[Command]
name = "AI39"
command = DF,UF,D,DF,U,F,a+b,c+x,y,z
time = 1

[Command]
name = "AI40"
command = D,D,D,D,F,D,a+b,c,x,y+z
time = 1
;--------------------------------------------------------------------------
[Command]
name = "FF"     ;Required (do not remove)
command = F, F
time = 15

[Command]
name = "BB"     ;Required (do not remove)
command = B, B
time = 15

;-| 2/3 Button Combination |-----------------------------------------------
[Command]
name = "recovery" ;Required (do not remove)
command = x+y
time = 1

[Command]
name = "recovery"
command = y+z
time = 1

[Command]
name = "recovery"
command = x+z
time = 1

[Command]
name = "recovery"
command = a+b
time = 1

[Command]
name = "recovery"
command = b+c
time = 1

[Command]
name = "recovery"
command = a+c
time = 1

;-| Dir + Button |---------------------------------------------------------
[Command]
name = "back_x"
command = /B,x
time = 1

[Command]
name = "back_y"
command = /B,y
time = 1

[Command]
name = "back_z"
command = /B,z
time = 1

[Command]
name = "down_x"
command = /D,x
time = 1

[Command]
name = "down_y"
command = /D,y
time = 1

[Command]
name = "down_z"
command = /D,z
time = 1

[Command]
name = "fwd_x"
command = /F,x
time = 1

[Command]
name = "fwd_y"
command = /F,y
time = 1

[Command]
name = "fwd_z"
command = /F,z
time = 1

[Command]
name = "up_x"
command = /U,x
time = 1

[Command]
name = "up_y"
command = /U,y
time = 1

[Command]
name = "up_z"
command = /U,z
time = 1

[Command]
name = "back_a"
command = /B,a
time = 1

[Command]
name = "back_b"
command = /B,b
time = 1

[Command]
name = "back_c"
command = /B,c
time = 1

[Command]
name = "down_a"
command = /D,a
time = 1

[Command]
name = "down_b"
command = /D,b
time = 1

[Command]
name = "down_c"
command = /D,c
time = 1

[Command]
name = "fwd_a"
command = /F,a
time = 1

[Command]
name = "fwd_b"
command = /F,b
time = 1

[Command]
name = "fwd_c"
command = /F,c
time = 1

[Command]
name = "up_a"
command = /U,a
time = 1

[Command]
name = "up_b"
command = /U,b
time = 1

[Command]
name = "up_c"
command = /U,c
time = 1

;-| Single Button |---------------------------------------------------------
[Command]
name = "a"
command = a
time = 1

[Command]
name = "b"
command = b
time = 1

[Command]
name = "c"
command = c
time = 1

[Command]
name = "x"
command = x
time = 1

[Command]
name = "y"
command = y
time = 1

[Command]
name = "z"
command = z
time = 1

[Command]
name = "s"
command = s
time = 1

;-| Single Dir |------------------------------------------------------------
[Command]
name = "fwd" ;Required (do not remove)
command = $F
time = 1

[Command]
name = "downfwd"
command = $DF
time = 1

[Command]
name = "down" ;Required (do not remove)
command = $D
time = 1

[Command]
name = "downback"
command = $DB
time = 1

[Command]
name = "back" ;Required (do not remove)
command = $B
time = 1

[Command]
name = "upback"
command = $UB
time = 1

[Command]
name = "up" ;Required (do not remove)
command = $U
time = 1

[Command]
name = "upfwd"
command = $UF
time = 1

;-| Hold Button |--------------------------------------------------------------
[Command]
name = "hold_x"
command = /x
time = 1

[Command]
name = "hold_y"
command = /y
time = 1

[Command]
name = "hold_z"
command = /z
time = 1

[Command]
name = "hold_a"
command = /a
time = 1

[Command]
name = "hold_b"
command = /b
time = 1

[Command]
name = "hold_c"
command = /c
time = 1

[Command]
name = "hold_s"
command = /s
time = 1

;-| Hold Dir |--------------------------------------------------------------
[Command]
name = "holdfwd" ;Required (do not remove)
command = /$F
time = 1

[Command]
name = "holddownfwd"
command = /$DF
time = 1

[Command]
name = "holddown" ;Required (do not remove)
command = /$D
time = 1

[Command]
name = "holddownback"
command = /$DB
time = 1

[Command]
name = "holdback" ;Required (do not remove)
command = /$B
time = 1

[Command]
name = "holdupback"
command = /$UB
time = 1

[Command]
name = "holdup" ;Required (do not remove)
command = /$U
time = 1

[Command]
name = "holdupfwd"
command = /$UF
time = 1

;---------------------------------------------------------------------------


;---------------------------------------------------------------------------
; 2. State entry
; --------------
; This is where you define what commands bring you to what states.
;
; Each state entry block looks like:
;   [State -1, Label]           ;Change Label to any name you want to use to
;                               ;identify the state with.
;   type = ChangeState          ;Don't change this
;   value = new_state_number
;   trigger1 = command = command_name
;   . . .  (any additional triggers)
;
; - new_state_number is the number of the state to change to
; - command_name is the name of the command (from the section above)
; - Useful triggers to know:
;   - statetype
;       S, C or A : current state-type of player (stand, crouch, air)
;   - ctrl
;       0 or 1 : 1 if player has control. Unless "interrupting" another
;                move, you'll want ctrl = 1
;   - stateno
;       number of state player is in - useful for "move interrupts"
;   - movecontact
;       0 or 1 : 1 if player's last attack touched the opponent
;                useful for "move interrupts"
;
; Note: The order of state entry is important.
;   State entry with a certain command must come before another state
;   entry with a command that is the subset of the first.  
;   For example, command "fwd_a" must be listed before "a", and
;   "fwd_ab" should come before both of the others.
;
; For reference on triggers, see CNS documentation.
;
; Just for your information (skip if you're not interested):
; This part is an extension of the CNS. "State -1" is a special state
; that is executed once every game-tick, regardless of what other state
; you are in.


; Don't remove the following line. It's required by the CMD standard.
[Statedef -1]

;===========================================================================
;---------------------------------------------------------------------------

;===========================================================================
; Debug 1
[State -1, Debug 1]
type = ChangeState
value = 20
trigger1 = command = "holdup"
trigger1 = command = "holdfwd"
trigger2 = command = "holdup"
trigger2 = command = "holdback"
triggerall = statetype = S
triggerall = stateno = 40
triggerall = command != "c"
triggerall = command != "up_a"
triggerall = command != "up_b"
triggerall = command != "up_x"
triggerall = command != "up_y"
triggerall = command != "up_z"
triggerall = command != "a"
triggerall = command != "b"
;---------------------------------------------------------------------------
; Debug 2
[State -1, Debug 2]
type = ChangeState
value = 0
trigger1 = command != "holdfwd"
trigger2 = command != "holdback"
triggerall = vel x >= -2
triggerall = vel x <= 2
triggerall = command = "holdup"
triggerall = statetype = S
triggerall = stateno = 40
triggerall = command != "c"
triggerall = command != "up_a"
triggerall = command != "up_b"
triggerall = command != "up_x"
triggerall = command != "up_y"
triggerall = command != "up_z"
triggerall = command != "a"
triggerall = command != "b"
;---------------------------------------------------------------------------
; Dash
[State -1, Dash]
type = ChangeState
value = 100
trigger1 = command = "FF"
trigger1 = statetype = S
trigger1 = ctrl
;---------------------------------------------------------------------------
; Dash Back
[State -1, Dasg Backwards]
type = ChangeState
value = 105
trigger1 = command = "BB"
trigger1 = statetype = S
trigger1 = ctrl
;---------------------------------------------------------------------------
; Jump
[State -1, Jump]
type = ChangeState
value = 41
triggerall = stateno != 5121
trigger1 = command = "c"
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------
; Double Jump
[State -1, Double Jump]
type = ChangeState
value = 46
trigger1 = command = "c"
trigger1 = statetype = A
trigger1 = var(20)>0
;---------------------------------------------------------------------------
; Ultimate
[State -1, Ultimate]
type = ChangeState
value = 110
triggerall = command = "s"
trigger1 = statetype != A
trigger1 = ctrl

;---------------------------------------------------------------------------
; A
[State -1, A]
type = ChangeState
value = 200
triggerall = command = "a"
triggerall = command != "holdfwd"
triggerall = command != "holddown"
triggerall = command != "holdup"
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------
; Fwd+A
[State -1, Fwd+A]
type = ChangeState
value = 210
triggerall = command = "fwd_a"
triggerall = command != "holddown"
triggerall = command != "holdup"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = stateno = 200
trigger2 = time>=10

;---------------------------------------------------------------------------
; Up+A
[State -1, Up+A]
type = ChangeState
value = 400
triggerall = command = "up_a"
triggerall = var(25)=0
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = stateno = 200
trigger2 = time>=10

;---------------------------------------------------------------------------
; Down+A
[State -1, Down+A]
type = ChangeState
value = 220
triggerall = command = "down_a"
trigger1 = statetype = C
trigger1 = ctrl

;---------------------------------------------------------------------------
; Veal Shot
[State -1, Veal Shot]
type = ChangeState
value = 330
triggerall = power>2999
triggerall = command = "z"
triggerall = command != "holddown"
triggerall = command != "holdup"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = stateno = 200
trigger2 = time>=10
trigger3 = stateno = 210
trigger3 = time>=14
trigger4 = stateno = 250
trigger4 = animelemno(0) >=11
;---------------------------------------------------------------------------
; Pose of Love
[State -1, Pose of Love]
type = ChangeState
value = 240
triggerall = power>2999
triggerall = command = "up_z"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = stateno = 200
trigger2 = time>=10
trigger3 = stateno = 210
trigger3 = time>=14
trigger4 = stateno = 250
trigger4 = animelemno(0) >=11
;---------------------------------------------------------------------------
; Parage Shot
[State -1, Parage Shot]
type = ChangeState
value = 440
triggerall = power>999
triggerall = command = "x"
triggerall = command != "holddown"
triggerall = command != "holdup"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = stateno = 200
trigger2 = time>=10
trigger3 = stateno = 210
trigger3 = time>=14
trigger4 = stateno = 250
trigger4 = animelemno(0) >=11
;---------------------------------------------------------------------------
; Brochette
[State -1, Brochette]
type = ChangeState
value = 320
triggerall = power>999
triggerall = command = "up_x"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = stateno = 200
trigger2 = time>=10
trigger3 = stateno = 210
trigger3 = time>=14
trigger4 = stateno = 250
trigger4 = animelemno(0) >=11
;---------------------------------------------------------------------------
; Muton Shot
[State -1, Muton Shot]
type = ChangeState
value = 270
triggerall = power>1999
triggerall = command = "y"
triggerall = command != "holddown"
triggerall = command != "holdup"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = stateno = 200
trigger2 = time>=10
trigger3 = stateno = 210
trigger3 = time>=14
trigger4 = stateno = 250
trigger4 = animelemno(0) >=11
;---------------------------------------------------------------------------
; Special Y+Up
;[State -1, Special Y+Up]
;type = ChangeState
;value = 290
;triggerall = power>1999
;triggerall = command = "up_y"
;triggerall = command != "holddown"
;trigger1 = statetype = S
;trigger1 = ctrl
;trigger2 = stateno = 200
;trigger2 = time>=10
;trigger3 = stateno = 210
;trigger3 = time>=14
;trigger4 = stateno = 250
;trigger4 = animelemno(0) >=11
;---------------------------------------------------------------------------
; B
[State -1, B]
type = ChangeState
value = 250
triggerall = command = "b"
triggerall = command != "holdfwd"
triggerall = command != "holddown"
triggerall = command != "holdup"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = stateno = 200
trigger2 = time>=10
trigger3 = stateno = 210
trigger3 = time>=14
trigger4 = stateno = 220
trigger4 = time>=40

;---------------------------------------------------------------------------
; Fwd+B
[State -1, Fwd+B]
type = ChangeState
value = 260
triggerall = command = "fwd_b"
triggerall = command != "holddown"
triggerall = command != "holdup"
triggerall = var(26)=0
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = stateno = 200
trigger2 = time>=10
trigger3 = stateno = 210
trigger3 = time>=14
trigger4 = stateno = 250
trigger4 = animelemno(0) >=11

;---------------------------------------------------------------------------
; Down+B
[State -1, Down+B]
type = ChangeState
value = 280
triggerall = command = "down_b"
trigger1 = statetype = C
trigger1 = ctrl

;---------------------------------------------------------------------------
; Up+B
[State -1, Up+B]
type = ChangeState
value = 620
triggerall = command = "up_b"
triggerall = var(27)=0
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = stateno = 400
trigger2 = time >= 16
trigger3 = stateno = 200
trigger3 = time>=10

;---------------------------------------------------------------------------
; Jump+A
[State -1, Jump+A]
type = ChangeState
value = 630
triggerall = command = "a"
triggerall = stateno != 5121
trigger1 = stateno != 630
trigger1 = stateno != 620
trigger1 = stateno != 610
trigger1 = statetype = A
trigger1 = var(20) > 0
trigger2 = stateno = 620
trigger2 = time >=34
trigger2 = var(20) > 0

;---------------------------------------------------------------------------
; Jump+B
[State -1, Jump+B]
type = ChangeState
value = 610
triggerall = command = "b"
triggerall = stateno != 5121
triggerall = pos y <= 20
trigger1 = statetype = A
trigger1 = stateno != 610
trigger1 = stateno != 620
trigger1 = stateno != 630
trigger1 = var(20) > 0
trigger2 = stateno = 620
trigger2 = time >=34
trigger2 = var(20) > 0

;----|AI|-------------------------------------------------------------------
[State -1, Activate AI]
type = VarSet
triggerall = var(50) != 1
trigger1 = command = "AI1"
trigger2 = command = "AI2"
trigger3 = command = "AI3"
trigger4 = command = "AI4"
trigger5 = command = "AI5"
trigger6 = command = "AI6"
trigger7 = command = "AI7"
trigger8 = command = "AI8"
trigger9 = command = "AI9"
trigger10 = command = "AI10"
trigger11 = command = "AI11"
trigger12 = command = "AI12"
trigger13 = command = "AI13"
trigger14 = command = "AI14"
trigger15 = command = "AI15"
trigger16 = command = "AI16"
trigger17 = command = "AI17"
trigger18 = command = "AI18"
trigger19 = command = "AI19"
trigger20 = command = "AI20"
trigger21 = command = "AI21"
trigger22 = command = "AI22"
trigger23 = command = "AI23"
trigger24 = command = "AI24"
trigger25 = command = "AI25"
trigger26 = command = "AI26"
trigger27 = command = "AI27"
trigger28 = command = "AI28"
trigger29 = command = "AI29"
trigger30 = command = "AI30"
trigger31 = command = "AI31"
trigger32 = command = "AI32"
trigger33 = command = "AI33"
trigger34 = command = "AI34"
trigger35 = command = "AI35"
trigger36 = command = "AI36"
trigger37 = command = "AI37"
trigger38 = command = "AI38"
trigger39 = command = "AI39"
trigger40 = command = "AI40"
var(50) = 1
;--------------------------------------------------------------------------
[State -3, AI Combo 1 - A]
type = ChangeState
value = 200
triggerall = Var(50) = 1
triggerall = p2life > 0
triggerall = p2bodydist X < 20
triggerall = statetype != A
triggerall = statetype = S
triggerall = stateno !=200
trigger1 = random < 5
trigger1 = ctrl

;--------------------------------------------------------------------------
[State -3, AI Combo 1 - A+Fwd]
type = ChangeState
value = 210
triggerall = Var(50) = 1
triggerall = p2life > 0
triggerall = statetype = S
triggerall = statetype != A
triggerall = stateno !=210
trigger1 = stateno = 200
trigger1 = time>=10
;--------------------------------------------------------------------------
[State -3, AI Combo 1 - B]
type = ChangeState
value = 250
triggerall = Var(50) = 1
triggerall = p2life > 0
triggerall = statetype = S
triggerall = statetype != A
trigger1 = time>=14
trigger1 = stateno = 210
;--------------------------------------------------------------------------
[State -3, AI Combo Special - Parage Shot]
type = ChangeState
value = 440
triggerall = Var(50) = 1
triggerall = p2life > 0
triggerall = statetype = S
triggerall = statetype != A
triggerall = stateno !=440
trigger1 = stateno = 250
trigger1 = animelemno(0) >=11
trigger1 = random < 50
trigger1 = power>999
trigger1 = p2stateno != 5110
;--------------------------------------------------------------------------
[State -3, AI Combo Special - Muton Shot]
type = ChangeState
value = 270
triggerall = Var(50) = 1
triggerall = p2life > 0
triggerall = statetype = S
triggerall = statetype != A
triggerall = stateno !=270
trigger1 = stateno = 250
trigger1 = animelemno(0) >=11
trigger1 = random < 100
trigger1 = power>1999
trigger1 = p2stateno != 5110
;--------------------------------------------------------------------------
[State -3, AI Combo Special - Veal Shot]
type = ChangeState
value = 330
triggerall = Var(50) = 1
triggerall = p2life > 0
triggerall = statetype = S
triggerall = statetype != A
triggerall = stateno !=330
trigger1 = stateno = 250
trigger1 = animelemno(0) >=11
trigger1 = random < 200
trigger1 = power>2999
trigger1 = p2stateno != 5110
;--------------------------------------------------------------------------
[State -3, AI Combo 1 - B+Fwd]
type = ChangeState
value = 260
triggerall = Var(50) = 1
triggerall = p2life > 0
triggerall = statetype = S
triggerall = statetype != A
triggerall = stateno !=260
trigger1 = stateno = 250
trigger1 = animelemno(0) >=11
;--------------------------------------------------------------------------
[State -3, AI Combo 2 - A+Up]
type = ChangeState
value = 400
triggerall = Var(50) = 1
triggerall = p2life > 0
triggerall = p2bodydist X < 5
triggerall = statetype != A
triggerall = statetype = S
triggerall = stateno !=400
trigger1 = random < 25
trigger1 = ctrl

;--------------------------------------------------------------------------
[State -3, AI Combo 2 - B+Up]
type = ChangeState
value = 620
triggerall = Var(50) = 1
triggerall = p2life > 0
triggerall = statetype = S
triggerall = statetype != A
triggerall = stateno !=620
trigger1 = stateno = 400
trigger1 = time>=16
;--------------------------------------------------------------------------
[State -3, AI Combo 2 - A+Jump]
type = ChangeState
value = 630
triggerall = Var(50) = 1
triggerall = p2life > 0
triggerall = statetype != S
triggerall = statetype = A
triggerall = stateno != 5121
triggerall = stateno != 630
triggerall = stateno != 610
triggerall = p2dist y <=50
trigger1 = time>=34
trigger1 = stateno = 620
trigger1 = var(20)>0
trigger1 = movetype!=H
;--------------------------------------------------------------------------
[State -3, AI Combo 2 - B+Jump]
type = ChangeState
value = 610
triggerall = Var(50) = 1
triggerall = p2life > 0
triggerall = statetype != S
triggerall = statetype = A
triggerall = stateno != 5121
triggerall = stateno != 630
triggerall = stateno != 620
triggerall = p2dist y > 50
trigger1 = time>=34
trigger1 = stateno = 620
trigger1 = var(20)>0
trigger1 = movetype!=H
;--------------------------------------------------------------------------
[State -3, AI - Recovery]
type = ChangeState
value = 5121
triggerall = Var(50) = 1
triggerall = stateno != 5121
triggerall = life =!0
trigger1 = stateno = 5101
trigger1 = random< 250
;--------------------------------------------------------------------------
[State -3, AI - Heal]
type = ChangeState
value = 110
triggerall = Var(50) = 1
triggerall = stateno != 110
triggerall = life =!0
triggerall = life < 700
trigger1 = random< 350
trigger1= p2bodydist X > 150
