; The CMD file.
;
; Two parts: 1. Command definition and  2. State entry
; (state entry is after the commands def section)
;
; 1. Command definition
; ---------------------
; Note: The commands are CASE-SENSITIVE, and so are the command names.
; The eight directions are:
;   B, DB, D, DF, F, UF, U, UB     (all CAPS)
;   corresponding to back, down-back, down, downforward, etc.
; The six buttons are:
;   a, b, c, x, y, z               (all lower case)
;   In default key config, abc are are the bottom, and xyz are on the
;   top row. For 2 button characters, we recommend you use a and b.
;   For 6 button characters, use abc for kicks and xyz for punches.
;
; Each [Command] section defines a command that you can use for
; state entry, as well as in the CNS file.
; The command section should look like:
;
;   [Command]
;   name = some_name
;   command = the_command
;   time = time (optional)
;   buffer.time = time (optional)
;
; - some_name
;   A name to give that command. You'll use this name to refer to
;   that command in the state entry, as well as the CNS. It is case-
;   sensitive (QCB_a is NOT the same as Qcb_a or QCB_A).
;
; - command
;   list of buttons or directions, separated by commas. Each of these
;   buttons or directions is referred to as a "symbol".
;   Directions and buttons can be preceded by special characters:
;   slash (/) - means the key must be held down
;          egs. command = /D       ;hold the down direction
;               command = /DB, a   ;hold down-back while you press a
;   tilde (~) - to detect key releases
;          egs. command = ~a       ;release the a button
;               command = ~D, F, a ;release down, press fwd, then a
;          If you want to detect "charge moves", you can specify
;          the time the key must be held down for (in game-ticks)
;          egs. command = ~30a     ;hold a for at least 30 ticks, then release
;   dollar ($) - Direction-only: detect as 4-way
;          egs. command = $D       ;will detect if D, DB or DF is held
;               command = $B       ;will detect if B, DB or UB is held
;   plus (+) - Buttons only: simultaneous press
;          egs. command = a+b      ;press a and b at the same time
;               command = x+y+z    ;press x, y and z at the same time
;   greater-than (>) - means there must be no other keys pressed or released
;                      between the previous and the current symbol.
;          egs. command = a, >~a   ;press a and release it without having hit
;                                  ;or released any other keys in between
;   You can combine the symbols:
;     eg. command = ~30$D, a+b     ;hold D, DB or DF for 30 ticks, release,
;                                  ;then press a and b together
;
;   Note: Successive direction symbols are always expanded in a manner similar
;         to this example:
;           command = F, F
;         is expanded when MUGEN reads it, to become equivalent to:
;           command = F, >~F, >F
;
;   It is recommended that for most "motion" commads, eg. quarter-circle-fwd,
;   you start off with a "release direction". This makes the command easier
;   to do.
;
; - time (optional)
;   Time allowed to do the command, given in game-ticks. The default
;   value for this is set in the [Defaults] section below. A typical
;   value is 15.
;
; - buffer.time (optional)
;   Time that the command will be buffered for. If the command is done
;   successfully, then it will be valid for this time. The simplest
;   case is to set this to 1. That means that the command is valid
;   only in the same tick it is performed. With a higher value, such
;   as 3 or 4, you can get a "looser" feel to the command. The result
;   is that combos can become easier to do because you can perform
;   the command early. Attacks just as you regain control (eg. from
;   getting up) also become easier to do. The side effect of this is
;   that the command is continuously asserted, so it will seem as if
;   you had performed the move rapidly in succession during the valid
;   time. To understand this, try setting buffer.time to 30 and hit
;   a fast attack, such as KFM's light punch.
;   The default value for this is set in the [Defaults] section below. 
;   This parameter does not affect hold-only commands (eg. /F). It
;   will be assumed to be 1 for those commands.
;
; If you have two or more commands with the same name, all of them will
; work. You can use it to allow multiple motions for the same move.
;
; Some common commands examples are given below.
;
; [Command] ;Quarter circle forward + x
; name = "QCF_x"
; command = ~D, DF, F, x
;
; [Command] ;Half circle back + a
; name = "HCB_a"
; command = ~F, DF, D, DB, B, a
;
; [Command] ;Two quarter circles forward + y
; name = "2QCF_y"
; command = ~D, DF, F, D, DF, F, y
;
; [Command] ;Tap b rapidly
; name = "5b"
; command = b, b, b, b, b
; time = 30
;
; [Command] ;Charge back, then forward + z
; name = "charge_B_F_z"
; command = ~60$B, F, z
; time = 10
;
; [Command] ;Charge down, then up + c
; name = "charge_D_U_c"
; command = ~60$D, U, c
; time = 10


;-| Button Remapping |-----------------------------------------------------
; This section lets you remap the player's buttons (to easily change the
; button configuration). The format is:
;   old_button = new_button
; If new_button is left blank, the button cannot be pressed.
[Remap]
x = x
y = y
z = z
a = a
b = b
c = c
s = s

;--|AI Activation|----------------------------------------------------------

[Command]
name = "AI1"
command = U,U,U,U,F,B,B,F,a,b,a,c,a,b
time = 1

[Command]
name = "AI2"
command = U,U,U,D,F,B,B,F,b,a,a,a,a,a,a
time = 1

[Command]
name = "AI3"
command = U,U,D,D,F,B,B,F,c,c,c,c,c,c,c
time = 1

[Command]
name = "AI4"
command = U,D,D,D,F,B,B,F,x,b,b,b,
time = 1

[Command]
name = "AI5"
command = D,D,D,D,F,B,B,F,y,a,a,c,b
time = 1

[Command]
name = "AI6"
command = D,D,D,U,F,B,B,F,z,z,z,z,z,x,a
time = 1

[Command]
name = "AI7"
command = D,D,U,U,F,B,B,F,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x
time = 1

[Command]
name = "AI8"
command = D,U,U,U,F,B,B,F,z,z,z,z,z,z,z,x,x,x,x,x
time = 1

[Command]
name = "AI9"
command = U,D,U,U,F,B,B,F,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,a,a,a,a,a,a,a
time = 1

[Command]
name = "AI10"
command = U,U,D,U,F,B,B,F,c,c,c,c,c,a,a,a,z,z,z,x,x,x,x
time = 1

[Command]
name = "AI11"
command = D,U,U,D,F,B,B,F,b,b,b,b,b,b,B,B,B,B,B,B,B,B,B,B,B,
time = 1

[Command]
name = "AI12"
command = U,D,D,U,F,B,B,F,D,D,D,D,D,D,D,D,D,D,D,D,
time = 1

[Command]
name = "AI13"
command = D,U,D,U,F,B,B,F,U,U,U,U,U,U,U,U,U,U,U,U,U,D
time = 1

[Command]
name = "AI14"
command = U,D,U,D,F,B,B,F,B,B,B,B,B,B,B,B,B,B,B,B,a,b,c,x,y,z,a,b,c,x,y,z,a,b,c,x,y,z,a,b,c,x,y,z
time = 1

[Command]
name = "AI15"
command = F,F,F,F,F,B,B,F,D,D,D,D,D,D,D,x,x,x,x,x,x,x,x,z,z,z,z,z
time = 1

[Command]
name = "AI16"
command = B,B,B,B,F,B,B,F,a,b,c,x,y,z,a,b,c,x,y,z,a,b,c,x,y,z,a,b,c,x,y,z,a,b,c,x,y,z,a,b,c,x,y,z,a,b,c,x,y,z,a,b,c,x,y,z
time = 1

[Command]
name = "AI17"
command = F,B,F,F,F,B,B,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,U,U,U,U,U,U,U,U,U,U,U,U,F
time = 1

[Command]
name = "AI18"
command = F,F,B,F,F,B,B,F,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B
time = 1

[Command]
name = "AI19"
command = B,F,F,F,F,B,B,F,F,F,F,F,F,F,F,F,F,F,F,F,U,U,U,U,U,U,U,U,U,U,U,U,U,D,D,D,D,D,D,D,B,B,B
time = 1

[Command]
name = "AI20"
command = F,F,F,B,F,B,B,F,F,F,F,B,F,B,B,F,F,F,F,B,F,B,B,F,F,F,F,B,F,B,B,F,F,F,F,B,F,B,B,F,F,F,F,B,F,B,B,F
time = 1

[Command]
name = "AI21"
command = F,B,B,F,F,B,B,F,D,B,D,B,D,B,D,B,D,B,D,B,D,B,D,B,D,B,D,B,D,B,D,B,D,B,D,B,D,B,D,B,D,B,D,B,D,B,D,B,D,B,D,B
time = 1

[Command]
name = "AI22"
command = B,F,F,B,F,B,B,F,B,F,F,B,F,B,B,F,B,F,F,B,F,B,B,F,B,F,F,B,F,B,B,F,B,F,F,B,F,B,B,F,B,F,F,B,F,B,B,F,B,F,F,B,F,B,B,F,B,F,F,B,F,B,B,F,B,F,F,B,F,B,B,F,B,F,F,B,F,B,B,F,B,F,F,B,F,B,B,F
time = 1

[Command]
name = "AI23"
command = F,B,F,B,F,B,B,F,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B
time = 1

[Command]
name = "AI24"
command = B,F,B,F,F,B,B,F,x,y,z,x,y,z,x,y,z,x,y,z,x,y,z,x,y,z,x,y,z,x,y,z,x,y,z,x,y,z,x,y,z,x,y,z
time = 1

[Command]
name = "AI25"
command = D,F,D,F,F,B,B,F
time = 1

[Command]
name = "AI26"
command = D,B,D,B,F,B,B,F
time = 1

[Command]
name = "AI27"
command = D,B,D,F,F,B,B,F
time = 1

[Command]
name = "AI28"
command = D,F,D,B,F,B,B,F
time = 1

[Command]
name = "AI29"
command = U,F,D,B,F,B,B,F
time = 1

[Command]
name = "AI30"
command = U,B,D,F,F,B,B,F
time = 1

;-| Default Values |-------------------------------------------------------
[Defaults]
command.time = 15

command.buffer.time = 1


;-| Super Motions |--------------------------------------------------------

[Command]
name = "Shark Tooth Drill"
command = ~D,D,z
time = 20

[Command]
name = "Shark Tooth Drill"
command = ~D,D,z
time = 20

[Command]
name = "Shark Dive"
command = ~D,D,y
time = 20

[Command]
name = "Shark Dive"
command = ~D,D,y
time = 20

;-| Special Motions |------------------------------------------------------

[Command]
name = "Kurobi"
command = D,F,a

[Command]
name = "Chuu"
command = D,F,b

[Command]
name = "Hachi"
command = D,F,c


;-| Double Tap |-----------------------------------------------------------
[Command]
name = "FF"     ;Required (do not remove)
command = F, F
time = 10

[Command]
name = "BB"     ;Required (do not remove)
command = B, B
time = 10

;-| 2/3 Button Combination |-----------------------------------------------

[Command]
name = "recovery";Required (do not remove)
command = x+y
time = 1

[Command]
name = "recovery";Required (do not remove)
command = y+z
time = 1

[Command]
name = "recovery";Required (do not remove)
command = z+a
time = 1

[Command]
name = "recovery";Required (do not remove)
command = a+b
time = 1

[Command]
name = "recovery";Required (do not remove)
command = b+c
time = 1

[Command]
name = "recovery";Required (do not remove)
command = c+x
time = 1

[Command]
name = "recovery";Required (do not remove)
command = a+x
time = 1

[Command]
name = "recovery";Required (do not remove)
command = b+y
time = 1

[Command]
name = "recovery";Required (do not remove)
command = c+z
time = 1

;-| Dir + Button |---------------------------------------------------------
[Command]
name = "down_a"
command = /$D,a
time = 1

[Command]
name = "down_b"
command = /$D,b
time = 1

;-| Single Button |---------------------------------------------------------
[Command]
name = "a"
command = a
time = 1

[Command]
name = "b"
command = b
time = 1

[Command]
name = "c"
command = c
time = 1

[Command]
name = "x"
command = x
time = 1

[Command]
name = "y"
command = y
time = 1

[Command]
name = "z"
command = z
time = 1

[Command]
name = "start"
command = s
time = 1

;-| Hold Dir |--------------------------------------------------------------
[Command]
name = "holdfwd";Required (do not remove)
command = /$F
time = 1

[Command]
name = "holdback";Required (do not remove)
command = /$B
time = 1

[Command]
name = "holdup" ;Required (do not remove)
command = /$U
time = 1

[Command]
name = "holddown";Required (do not remove)
command = /$D
time = 1

;---------------------------------------------------------------------------
; 2. State entry
; --------------
; This is where you define what commands bring you to what states.
;
; Each state entry block looks like:
;   [State -1, Label]           ;Change Label to any name you want to use to
;                               ;identify the state with.
;   type = ChangeState          ;Don't change this
;   value = new_state_number
;   trigger1 = command = command_name
;   . . .  (any additional triggers)
;
; - new_state_number is the number of the state to change to
; - command_name is the name of the command (from the section above)
; - Useful triggers to know:
;   - statetype
;       S, C or A : current state-type of player (stand, crouch, air)
;   - ctrl
;       0 or 1 : 1 if player has control. Unless "interrupting" another
;                move, you'll want ctrl = 1
;   - stateno
;       number of state player is in - useful for "move interrupts"
;   - movecontact
;       0 or 1 : 1 if player's last attack touched the opponent
;                useful for "move interrupts"
;
; Note: The order of state entry is important.
;   State entry with a certain command must come before another state
;   entry with a command that is the subset of the first.
;   For example, command "fwd_a" must be listed before "a", and
;   "fwd_ab" should come before both of the others.
;
; For reference on triggers, see CNS documentation.
;
; Just for your information (skip if you're not interested):
; This part is an extension of the CNS. "State -1" is a special state
; that is executed once every game-tick, regardless of what other state
; you are in.


; Don't remove the following line. It's required by the CMD standard.
[Statedef -1]

;---------------------------------------------------------------------------
;Shark Tooth Drill
[State -1, Shark Tooth Drill]
type = ChangeState
value = 3000
triggerall = command = "Shark Tooth Drill"
triggerall = power >= 3000
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = statetype != A
trigger2 = hitdefattr = SC, NA, SA, HA
trigger2 = stateno != [3000,3000)

[State -1, Shark Tooth Drill AI]
type = ChangeState
value = 3000
triggerall = (roundstate = 2) && (var(58))
triggerall = p2bodydist X < 0
triggerall = random < 128
triggerall = statetype != A
triggerall = power >= 3000
trigger1 = ctrl
trigger2 = hitdefattr = SC, NA, SA

;---------------------------------------------------------------------------
;Shark Dive
[State -1, Shark Dive]
type = ChangeState
value = 3200
triggerall = command = "Shark Dive"
triggerall = power >= 1000
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = statetype != A
trigger2 = hitdefattr = SC, NA, SA, HA
trigger2 = stateno != [3200,3200)
trigger2 = stateno = 3200
trigger2 = time > 121

[State -1, Shark Tooth Drill AI]
type = ChangeState
value = 3200
triggerall = (roundstate = 2) && (var(58))
triggerall = p2bodydist X < 0
triggerall = random < 34
triggerall = statetype != A
triggerall = power >= 1000
trigger1 = ctrl
trigger2 = hitdefattr = SC, NA, SA

;===========================================================================
;This is not a move, but it sets up var(1) to be 1 if conditions are right
;for a combo into a special move (used below).
;Since a lot of special moves rely on the same conditions, this reduces
;redundant logic.
[State -1, Combo condition Reset]
type = VarSet
trigger1 = 1
var(1) = 0

[State -1, Combo condition Check]
type = VarSet
trigger1 = statetype != A
trigger1 = ctrl
trigger2 = (stateno = [200,299]) || (stateno = [400,499])
trigger2 = stateno != 440 ;Except for sweep kick
trigger2 = movecontact
var(1) = 1

;==========================================================================
; AI Activation
[State -1, AI On]
type = VarSet
triggerall = RoundState = 2
trigger1 = command = "AI1"
trigger2 = command = "AI2"
trigger3 = command = "AI3"
trigger4 = command = "AI4"
trigger5 = command = "AI5"
trigger6 = command = "AI6"
trigger7 = command = "AI7"
trigger8 = command = "AI8"
trigger9 = command = "AI9"
trigger10 = command = "AI10"
trigger11 = command = "AI11"
trigger12 = command = "AI12"
trigger13 = command = "AI13"
trigger14 = command = "AI14"
trigger15 = command = "AI15"
trigger16 = command = "AI16"
trigger17 = command = "AI17"
trigger18 = command = "AI18"
trigger19 = command = "AI19"
trigger20 = command = "AI20"
trigger21 = command = "AI21"
trigger22 = command = "AI22"
trigger23 = command = "AI23"
trigger24 = command = "AI24"
trigger25 = command = "AI25"
trigger26 = command = "AI26"
trigger27 = command = "AI27"
trigger28 = command = "AI28"
trigger29 = command = "AI29"
trigger30 = command = "AI30"
var(58) = 1

[State -1, AI Off]
type = VarSet
triggerall = !Win
trigger1 = !alive
trigger2 = roundstate <= 1
trigger3 = roundstate >= 3
var(58) = 0

;---------------------------------------------------------------------------
;Run Fwd
[State -1, Run Fwd]
type = ChangeState
value = 100
trigger1 = command = "FF"
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------
;Run Back
[State -1, Run Back]
type = ChangeState
value = 105
trigger1 = command = "BB"
trigger1 = statetype = S
trigger1 = ctrl

;Kurobi helper
[State -1,Kurobi Helper]
type = ChangeState
value = 8800
triggerall = command = "Kurobi"
triggerall = numhelper(25000) = 0
trigger1 = statetype != A
trigger1 = ctrl = 1

;Hachi helper
[State -1,Hachi Helper]
type = ChangeState
value = 8801
triggerall = command = "Hachi"
triggerall = numhelper(15000) = 0
trigger1 = statetype != A
trigger1 = ctrl = 1

;Chuu helper
[State -1,Chuu Helper]
type = ChangeState
value = 8802
triggerall = command = "Chuu"
triggerall = numhelper(35000) = 0
trigger1 = statetype != A
trigger1 = ctrl = 1

;===========================================================================
;---------------------------------------------------------------------------
;Stand Light Punch
[State -1, Stand Light Punch]
type = ChangeState
value = 200
triggerall = command = "x"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = stateno = 200
trigger2 = time > 36
trigger3 = stateno =210&&movecontact

[State -1, Stand Light Punch AI]
type = ChangeState
value = 200
triggerall = (roundstate = 2) && (var(58))
triggerall = random < 13
triggerall = statetype != A
trigger1 = ctrl
trigger2 = movecontact
trigger2 = hitdefattr = SC, NA, SA
trigger2 = stateno = 200
trigger2 = time > 36

;---------------------------------------------------------------------------
;Stand Strong Punch
[State -1, Stand Strong Punch]
type = ChangeState
value = 210
triggerall = command = "y"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = (stateno = 200) && time > 25
trigger3 = (stateno = 230) && time > 26

[State -1, Stand Strong Punch AI]
type = ChangeState
value = 210
triggerall = (roundstate = 2) && (var(58))
triggerall = random < 14
triggerall = statetype != A
trigger1 = ctrl
trigger2 = hitdefattr = SC, NA, SA
trigger2 = (stateno = 200) && time > 25
trigger3 = (stateno = 230) && time > 26

;---------------------------------------------------------------------------
;Fast Punch
[State -1, Fast Punch]
type = ChangeState
value = 215
triggerall = command = "z"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = (stateno = 200) && time > 25
trigger3 = (stateno = 230) && time > 26

[State -1, Fast Punch AI]
type = ChangeState
value = 210
triggerall = (roundstate = 2) && (var(58))
triggerall = random < 14
triggerall = statetype != A
trigger1 = ctrl
trigger2 = hitdefattr = SC, NA, SA
trigger2 = (stateno = 200) && time > 25
trigger3 = (stateno = 230) && time > 26

;---------------------------------------------------------------------------
;atk 1
[state -1, Atk 1]
type = changestate
value = 230
triggerall = command = "a"
triggerall = command != "holddown"
trigger1 = ctrl
trigger1 = statetype = S
trigger2 = time = 35

[State -1, Atk 1 AI]
type = ChangeState
value = 230
triggerall = (roundstate = 2) && (var(58))
triggerall = random < 13
triggerall = statetype != A
trigger1 = ctrl
trigger2 = hitdefattr = SC, NA, SA
trigger2 = time = 35

;---------------------------------------------------------------------------
;Standing Strong Kick
[State -1, Standing Strong Kick]
type = ChangeState
value = 240
triggerall = command = "b"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = (stateno = 200) && time > 5
trigger3 = (stateno = 230) && time > 6

[State -1, Standing Strong Kick AI]
type = ChangeState
value = 240
triggerall = (roundstate = 2) && (var(58))
triggerall = p2bodydist X < 84
triggerall = random <12
triggerall = statetype != A
trigger1 = ctrl
trigger2 = hitdefattr = SC, NA, SA
trigger2 = (stateno = 200) && time > 5
trigger3 = (stateno = 230) && time > 6

;---------------------------------------------------------------------------
;Taunt
[State -1, Taunt]
type = ChangeState
value = 195
triggerall = command = "start"
trigger1 = statetype != A
trigger1 = ctrl

;---------------------------------------------------------------------------
;Crouching Light Punch
[State -1, Crouching Light Punch]
type = ChangeState
value = 400
triggerall = command = "x"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
trigger2 = (stateno = 400) && time > 73

[State -1, Crouching Light Punch AI]
type = ChangeState
value = 400
triggerall = (roundstate = 2) && (var(58))
triggerall = p2bodydist X < 84
triggerall = random < 10
triggerall = statetype != A
trigger1 = ctrl
trigger2 = hitdefattr = SC, NA, SA
trigger2 = (stateno = 400) && time > 73
trigger2 = p2stateno = 400
trigger2 = p2stateno = 410
trigger2 = p2stateno = 430
trigger2 = p2stateno = 440
trigger2 = p2stateno = 6
trigger2 = p2stateno = 11

;---------------------------------------------------------------------------
;Crouching Strong Punch
[State -1, Crouching Strong Punch]
type = ChangeState
value = 410
triggerall = command = "y"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
trigger2 = (stateno = 430)
trigger2 = (time > 155)

[State -1, Crouching Strong Punch AI]
type = ChangeState
value = 410
triggerall = (roundstate = 2) && (var(58))
triggerall = p2bodydist X < 84
triggerall = random < 10
triggerall = statetype != A
trigger1 = ctrl
trigger2 = hitdefattr = SC, NA, SA
trigger2 = (stateno = 410)
trigger2 = (time > 89)
trigger2 = p2stateno = 400
trigger2 = p2stateno = 410
trigger2 = p2stateno = 430
trigger2 = p2stateno = 440
trigger2 = p2stateno = 6
trigger2 = p2stateno = 11

;---------------------------------------------------------------------------
;Crouching Light Kick
[State -1, Crouching Light Kick]
type = ChangeState
value = 430
triggerall = command = "a"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
trigger2 = (stateno = 430)
trigger2 = (time > 25)

[State -1, Crouching Light Kick AI]
type = ChangeState
value = 430
triggerall = (roundstate = 2) && (var(58))
triggerall = p2bodydist X < 84
triggerall = random < 10
triggerall = statetype != A
trigger1 = ctrl
trigger2 = hitdefattr = SC, NA, SA
trigger2 = (stateno = 430)
trigger2 = (time > 25)
trigger2 = p2stateno = 400
trigger2 = p2stateno = 410
trigger2 = p2stateno = 430
trigger2 = p2stateno = 440
trigger2 = p2stateno = 6
trigger2 = p2stateno = 11

;---------------------------------------------------------------------------
;Crouching Light Kick
[State -1, Crouching Light Kick]
type = ChangeState
value = 440
triggerall = command = "b"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
trigger2 = (stateno = 440)
trigger2 = (time > 106)

[State -1, Crouching Light Kick AI]
type = ChangeState
value = 440
triggerall = (roundstate = 2) && (var(58))
triggerall = p2bodydist X < 84
triggerall = random < 10
triggerall = statetype != A
trigger1 = ctrl
trigger2 = hitdefattr = SC, NA, SA
trigger2 = (stateno = 440)
trigger2 = (time > 106)
trigger2 = p2stateno = 400
trigger2 = p2stateno = 410
trigger2 = p2stateno = 430
trigger2 = p2stateno = 440
trigger2 = p2stateno = 6
trigger2 = p2stateno = 11

;---------------------------------------------------------------------------
;Crouching Strong Kick
[State -1, Crouching Strong Kick]
type = ChangeState
value = 445
triggerall = command = "z"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
trigger2 = (stateno = 445)
trigger2 = (time > 105) || (movecontact && time > 105)

[State -1, Crouching Strong Kick AI]
type = ChangeState
value = 445
triggerall = (roundstate = 2) && (var(58))
triggerall = p2bodydist X < 84
triggerall = random < 10
triggerall = statetype != A
trigger1 = ctrl
trigger2 = hitdefattr = SC, NA, SA
trigger2 = (stateno = 445)
trigger2 = (time > 105) || (movecontact && time > 105)
trigger2 = p2stateno = 400
trigger2 = p2stateno = 410
trigger2 = p2stateno = 430
trigger2 = p2stateno = 440
trigger2 = p2stateno = 6
trigger2 = p2stateno = 11

;---------------------------------------------------------------------------
;Jump Light Punch
[State -1, Jump Light Punch]
type = ChangeState
value = 600
triggerall = command = "x"
trigger1 = statetype = A
trigger1 = ctrl
trigger2 = stateno = 600
trigger2 = (stateno = 600) && time > 25
trigger3 = stateno = 1350 ;Air blocking

[State -1, Jump Light PunchAI]
type = ChangeState
value = 600
triggerall = (roundstate = 2) && (var(58))
triggerall = random < 11
triggerall = statetype != A
trigger1 = ctrl
trigger2 = hitdefattr = SC, NA, SA
trigger2 = stateno = 600
trigger2 = (stateno = 600) && time > 25
trigger3 = stateno = 1350

;---------------------------------------------------------------------------
;Jump Strong Punch
[State -1, Jump Strong Punch]
type = ChangeState
value = 610
triggerall = command = "y"
trigger1 = statetype = A
trigger1 = ctrl
trigger2 = stateno = 600 || stateno = 630 ;jump_x or jump_a
trigger2 = movecontact
trigger3 = stateno = 1350 ;Air blocking

[State -1, Jump Strong PunchAI]
type = ChangeState
value = 610
triggerall = (roundstate = 2) && (var(58))
triggerall = random < 11
triggerall = statetype != A
trigger1 = ctrl
trigger2 = hitdefattr = SC, NA, SA
trigger2 = stateno = 600 || stateno = 630
trigger3 = stateno = 1350

;---------------------------------------------------------------------------
;Jump Strong Punch
[State -1, Jump Strong Punch]
type = ChangeState
value = 615
triggerall = command = "z"
trigger1 = statetype = A
trigger1 = ctrl
trigger2 = (stateno = 615) && time > 44
trigger3 = stateno = 1350

[State -1, Jump Strong PunchAI]
type = ChangeState
value = 615
triggerall = (roundstate = 2) && (var(58))
triggerall = random < 11
triggerall = statetype != A
trigger1 = ctrl
trigger2 = hitdefattr = SC, NA, SA
trigger2 = (stateno = 615) && time > 44
trigger3 = stateno = 1350

;---------------------------------------------------------------------------
;Jump Light Kick
[State -1, Jump Light Kick]
type = ChangeState
value = 630
triggerall = command = "a"
trigger1 = statetype = A
trigger1 = ctrl
trigger2 = stateno = 1350 ;Air blocking

[State -1, Jump Light KickAI]
type = ChangeState
value = 630
triggerall = (roundstate = 2) && (var(58))
triggerall = random < 11
triggerall = statetype != A
trigger1 = ctrl
trigger2 = hitdefattr = SC, NA, SA
trigger3 = stateno = 1350

;---------------------------------------------------------------------------
;Dive Attack
[State -1, Dive Attack]
type = ChangeState
value = 640
triggerall = command = "b"
trigger1 = statetype = A
trigger1 = ctrl
trigger3 = stateno = 1350 ;Air blocking

[State -1, Dive AttackAI]
type = ChangeState
value = 640
triggerall = (roundstate = 2) && (var(58))
triggerall = p2bodydist Y < -90
triggerall = random < 11
triggerall = statetype != A
trigger1 = ctrl
trigger2 = hitdefattr = SC, NA, SA
trigger3 = stateno = 1350

