; The CMD file.
;
; Two parts: 1. Command definition and  2. State entry
; (state entry is after the commands def section)
;
; 1. Command definition
; ---------------------
; Note: The commands are CASE-SENSITIVE, and so are the command names.
; The eight directions are:
;   B, DB, D, DF, F, UF, U, UB     (all CAPS)
;   corresponding to back, down-back, down, downforward, etc.
; The six buttons are:
;   a, b, c, x, y, z               (all lower case)
;   In default key config, abc are are the bottom, and xyz are on the
;   top row. For 2 button characters, we recommend you use a and b.
;   For 6 button characters, use abc for kicks and xyz for punches.
;
; Each [Command] section defines a command that you can use for
; state entry, as well as in the CNS file.
; The command section should look like:
;
;   [Command]
;   name = some_name
;   command = the_command
;   time = time (optional)
;   buffer.time = time (optional)
;
; - some_name
;   A name to give that command. You'll use this name to refer to
;   that command in the state entry, as well as the CNS. It is case-
;   sensitive (QCB_a is NOT the same as Qcb_a or QCB_A).
;
; - command
;   list of buttons or directions, separated by commas. Each of these
;   buttons or directions is referred to as a "symbol".
;   Directions and buttons can be preceded by special characters:
;   slash (/) - means the key must be held down
;          egs. command = /D       ;hold the down direction
;               command = /DB, a   ;hold down-back while you press a
;   tilde (~) - to detect key releases
;          egs. command = ~a       ;release the a button
;               command = ~D, F, a ;release down, press fwd, then a
;          If you want to detect "charge moves", you can specify
;          the time the key must be held down for (in game-ticks)
;          egs. command = ~30a     ;hold a for at least 30 ticks, then release
;   dollar ($) - Direction-only: detect as 4-way
;          egs. command = $D       ;will detect if D, DB or DF is held
;               command = $B       ;will detect if B, DB or UB is held
;   plus (+) - Buttons only: simultaneous press
;          egs. command = a+b      ;press a and b at the same time
;               command = x+y+z    ;press x, y and z at the same time
;   greater-than (>) - means there must be no other keys pressed or released
;                      between the previous and the current symbol.
;          egs. command = a, >~a   ;press a and release it without having hit
;                                  ;or released any other keys in between
;   You can combine the symbols:
;     eg. command = ~30$D, a+b     ;hold D, DB or DF for 30 ticks, release,
;                                  ;then press a and b together
;
;   Note: Successive direction symbols are always expanded in a manner similar
;         to this example:
;           command = F, F
;         is expanded when MUGEN reads it, to become equivalent to:
;           command = F, >~F, >F
;
;   It is recommended that for most "motion" commads, eg. quarter-circle-fwd,
;   you start off with a "release direction". This makes the command easier
;   to do.
;
; - time (optional)
;   Time allowed to do the command, given in game-ticks. The default
;   value for this is set in the [Defaults] section below. A typical
;   value is 15.
;
; - buffer.time (optional)
;   Time that the command will be buffered for. If the command is done
;   successfully, then it will be valid for this time. The simplest
;   case is to set this to 1. That means that the command is valid
;   only in the same tick it is performed. With a higher value, such
;   as 3 or 4, you can get a "looser" feel to the command. The result
;   is that combos can become easier to do because you can perform
;   the command early. Attacks just as you regain control (eg. from
;   getting up) also become easier to do. The side effect of this is
;   that the command is continuously asserted, so it will seem as if
;   you had performed the move rapidly in succession during the valid
;   time. To understand this, try setting buffer.time to 30 and hit
;   a fast attack, such as KFM's light punch.
;   The default value for this is set in the [Defaults] section below.
;   This parameter does not affect hold-only commands (eg. /F). It
;   will be assumed to be 1 for those commands.
;
; If you have two or more commands with the same name, all of them will
; work. You can use it to allow multiple motions for the same move.
;
; Some common commands examples are given below.
;
; [Command] ;Quarter circle forward + x
; name = "QCF_x"
; command = ~D, DF, F, x
;
; [Command] ;Half circle back + a
; name = "HCB_a"
; command = ~F, DF, D, DB, B, a
;
; [Command] ;Two quarter circles forward + y
; name = "2QCF_y"
; command = ~D, DF, F, D, DF, F, y
;
; [Command] ;Tap b rapidly
; name = "5b"
; command = b, b, b, b, b
; time = 30
;
; [Command] ;Charge back, then forward + z
; name = "charge_B_F_z"
; command = ~60$B, F, z
; time = 10
;
; [Command] ;Charge down, then up + c
; name = "charge_D_U_c"
; command = ~60$D, U, c
; time = 10


;-| Button Remapping |-----------------------------------------------------
; This section lets you remap the player's buttons (to easily change the
; button configuration). The format is:
;   old_button = new_button
; If new_button is left blank, the button cannot be pressed.
[Remap]
x = x
y = y
z = z
a = a
b = b
c = c
s = s
;
; AI
;

[Command]
Name    = "AI_1"
Command = a, b, c, x, y, z, s
Time = 0

[Command]
Name    = "AI_2"
Command = x, y, z, a, b, c, s
Time = 0

[Command]
Name    = "AI_3"
Command = z, y, x, c, b, a, s
Time = 0

[Command]
Name    = "AI_4"
Command = c, b, a, z, y, x, s
Time = 0

[Command]
Name    = "AI_5"
Command = a, b, c, z, y, x, s
Time = 0

[Command]
Name    = "AI_6"
Command = z, y, x, a, b, c, s
Time = 0

[Command]
Name    = "AI_7"
Command = x, y, z, c, b, a, s
Time = 0

[Command]
Name    = "AI_8"
Command = c, b, a, x, y, z, s
Time = 0

[Command]
Name    = "AI_9"
Command = a, a, a, a, a, s
Time = 0

[Command]
Name    = "AI_10"
Command = b, b, b, b, b, s
Time = 0

[Command]
Name    = "AI_11"
Command = c, c, c, c, c, s
Time = 0

[Command]
Name    = "AI_12"
Command = x, x, x, x, x, s
Time = 0

[Command]
Name    = "AI_13"
Command = y, y, y, y, y, s
Time = 0

[Command]
Name    = "AI_14"
Command = z, z, z, z, z, s
Time = 0

[Command]
Name    = "AI_15"
Command = s, s, s, s, s, s
Time = 0

[Command]
Name    = "AI_16"
Command = U, U, U, U
Time = 0

[Command]
Name    = "AI_17"
Command = D, D, D, D
Time = 0

[Command]
Name    = "AI_18"
Command = F, F, F, F
Time = 0

[Command]
Name    = "AI_19"
Command = B, B, B, B
Time = 0

;-| Default Values |-------------------------------------------------------
[Defaults]
; Default value for the "time" parameter of a Command. Minimum 1.
command.time = 15

; Default value for the "buffer.time" parameter of a Command. Minimum 1,
; maximum 30.
command.buffer.time = 4

;-| Super Motions |--------------------------------------------------------
;The following two have the same name, but different motion.
;Either one will be detected by a "command = TripleKFPalm" trigger.
;Time is set to 20 (instead of default of 15) to make the move
;easier to do.
[Command]
name = "Arc_Drive"
command = ~B, DB, D, DF, F, c
time = 30
buffer.time = 8
;-| Special Motions |------------------------------------------------------
[Command]
name = "QCF_A"
command = ~D, DF, F, a
time = 20
buffer.time = 8

[Command]
name = "QCF_B"
command = ~D, DF, F, b
time = 20
buffer.time = 8

[Command]
name = "QCF_C"
command = ~D, DF, F, c
time = 20
buffer.time = 8

[Command]
name = "QCB_A"
command = ~D, DB, B, a
time = 20
buffer.time = 8

[Command]
name = "QCB_B"
command = ~D, DB, B, b
time = 20
buffer.time = 8

[Command]
name = "QCB_C"
command = ~D, DB, B, c
time = 20
buffer.time = 8

[Command]
name = "Z_A"
command = ~F, $D, F, a
time = 20
buffer.time = 8

[Command]
name = "Z_B"
command = ~F, $D, F, b
time = 20
buffer.time = 8

[Command]
name = "Z_C"
command = ~F, $D, F, c
time = 20
buffer.time = 8

[Command]
name = "DD_A"
command = ~D, D, a
time = 15
buffer.time = 8

[Command]
name = "DD_B"
command = ~D, D, b
time = 15
buffer.time = 8

[Command]
name = "DD_C"
command = ~D, D, c
time = 15
buffer.time = 8

;---------------------------------------------------------------------------
;Charge_Down_Up
[Command]
name = "HighJump"
command = ~$D, UF
time = 10
buffer.time = 2

[Command]
name = "NeutralJump"
command = ~$D, U
time = 10
buffer.time = 2

;-| Double Tap |-----------------------------------------------------------
[Command]
name = "FF"     ;Required (do not remove)
command = F, F
time = 12
buffer.time = 2

[Command]
name = "BB"     ;Required (do not remove)
command = B, B
time = 12
buffer.time = 2

;-| 2/3 Button Combination |-----------------------------------------------
[Command]
name = "recovery";Required (do not remove)
command = x+y
time = 1

;-| Dir + Button |---------------------------------------------------------
[Command]
name = "down_a"
command = /$D,a
time = 1

[Command]
name = "down_b"
command = /$D,b
time = 1

;-| Single Button |---------------------------------------------------------
[Command]
name = "a"
command = a
time = 1

[Command]
name = "b"
command = b
time = 1

[Command]
name = "c"
command = c
time = 1

[Command]
name = "x"
command = x
time = 1

[Command]
name = "y"
command = y
time = 1

[Command]
name = "z"
command = z
time = 1

[Command]
name = "start"
command = s
time = 1
;-----------------------傢@o[͂Ȃē
[Command]
name = "Fr"
command = $F
time = 1

[Command]
name = "Ba"
command = $B
time = 1

[Command]
name = "UP"
command = $U
time = 10
buffer.time = 12

[Command]
name = "Do"
command = $D
time = 1

;-| Hold Dir |--------------------------------------------------------------
[Command]
name = "holdfwd";Required (do not remove)
command = /$F
time = 1

[Command]
name = "holdback";Required (do not remove)
command = /$B
time = 1

[Command]
name = "holdup" ;Required (do not remove)
command = /$U
time = 1

[Command]
name = "holddown";Required (do not remove)
command = /$D
time = 1

[Command]
name = "HoldB"
command = /$b
time = 1

[Command]
name = "HoldS"
command = /$s
time = 1
;-| Recovery Dir |--------------------------------------------------------------
[Command]
name = "ReF"
command = $F
time = 1
buffer.time=6

[Command]
name = "ReB"
command = $B
time = 1
buffer.time=6

[Command]
name = "ReU"
command = $U
time = 1
buffer.time=6

;---------------------------------------------------------------------------
; 2. State entry
; --------------
; This is where you define what commands bring you to what states.
;
; Each state entry block looks like:
;   [State -1, Label]           ;Change Label to any name you want to use to
;                               ;identify the state with.
;   type = ChangeState          ;Don't change this
;   value = new_state_number
;   trigger1 = command = command_name
;   . . .  (any additional triggers)
;
; - new_state_number is the number of the state to change to
; - command_name is the name of the command (from the section above)
; - Useful triggers to know:
;   - statetype
;       S, C or A : current state-type of player (stand, crouch, air)
;   - ctrl
;       0 or 1 : 1 if player has control. Unless "interrupting" another
;                move, you'll want ctrl = 1
;   - stateno
;       number of state player is in - useful for "move interrupts"
;   - movecontact
;       0 or 1 : 1 if player's last attack touched the opponent
;                useful for "move interrupts"
;
; Note: The order of state entry is important.
;   State entry with a certain command must come before another state
;   entry with a command that is the subset of the first.
;   For example, command "fwd_a" must be listed before "a", and
;   "fwd_ab" should come before both of the others.
;
; For reference on triggers, see CNS documentation.
;
; Just for your information (skip if you're not interested):
; This part is an extension of the CNS. "State -1" is a special state
; that is executed once every game-tick, regardless of what other state
; you are in.


; Don't remove the following line. It's required by the CMD standard.
[Statedef -1]

;===========================================================================
;---------------------------------------------------------------------------
;Run Fwd
[State -1, Run Fwd]
type = ChangeState
value = 100
trigger1 = command = "FF"
trigger1 = statetype = S
trigger1 = ctrl
;---------------------------------------------------------------------------
;Run Back
[State -1, Run Back]
type = ChangeState
value = 105
trigger1 = command = "BB"
trigger1 = statetype = S
trigger1 = ctrl
;---------------------------------------------------------------------------
;Air Dash Fwd
[State -1, Air Dash Fwd]
type = ChangeState
value = 110
triggerall = var(30)!=0
trigger1 = command = "FF"
trigger1 = statetype = A
trigger1 = ctrl
;---------------------------------------------------------------------------
;Air Dash Back
[State -1, Air Dash Back]
type = ChangeState
value = 115
triggerall = var(30)!=0
trigger1 = command = "BB"
trigger1 = statetype = A
trigger1 = ctrl
trigger1 = stateno != 105
;---------------------------------------------------------------------------
;High Jump
[State -1, High Jump]
type = ChangeState
value = 60
triggerall = command       = "HighJump"
triggerall = statetype    != A
trigger1   = ctrl
trigger2   = stateno       = 100
trigger2   = animelemtime(3) >= 0
;---------------------------------------------------------------------------
;Neutral Super Jump
[State -1, Neutral Super Jump]
type = ChangeState
value = 70
triggerall = command       = "NeutralJump"
triggerall = statetype    != A
trigger1   = ctrl
;===========================================================================
;Recovery
[State -1,Recovery]
type = ChangeState
value = 5220
triggerall = alive
triggerall = command       = "ReF" || command = "ReB" || command = "ReU"
triggerall = canrecover
trigger1   = stateno       = 5100
trigger1   = time          = [0,3]
;---------------------------------------------------------------------------
;Taunt
[State -1, Taunt]
type = ChangeState
value = 195
triggerall = command = "start"
triggerall = statetype != A
trigger1 = ctrl
;---------------------------------------------------------------------------
;Heat
[State -1, Heat]
type = ChangeState
value = 1500
triggerall = command = "y"
triggerall = command != "holdfwd" && command != "holdback"
triggerall = command != "holddown"
triggerall = statetype = S
triggerall = ctrl
trigger1 = var(35)=3
trigger2 = power>=1000
trigger2 = var(35)=0
;---------------------------------------------------------------------------
;Dodge
[State -1, Dodge]
type = ChangeState
value = 990
triggerall = command = "y"
;triggerall = command != "holdfwd" && command != "holdback"
triggerall = command = "holddown"
triggerall = statetype = C
trigger1 = ctrl
;---------------------------------------------------------------------------
;Throw
[State -1, Throw]
type = ChangeState
value = 800
triggerall = command = "y"
triggerall = command != "holddown"
triggerall = statetype != A
triggerall = ctrl
trigger1 = command = "holdfwd" || command = "holdback"
trigger2 = (command != "holdfwd" && command != "holdback") && power < 1000
;---------------------------------------------------------------------------
;Air Throw
[State -1, Air Throw]
type = ChangeState
value = 850
triggerall = command = "y"
triggerall = enemynear(0),p2bodydist x< 25
triggerall = enemynear(0),statetype = A
trigger1 = statetype = A
trigger1 = ctrl
trigger2 = movehit
trigger2 = stateno = 220
trigger2 = time > 6
trigger3 = movehit
trigger3 = stateno = 250
trigger3 = time > 9

;===========================================================================
;Last Arc
[State -1, Last Arc]
type = ChangeState
value = 1200
triggerall = command = "x"
triggerall = statetype != A
triggerall = ctrl
trigger1 = var(35)=2
;===========================================================================
;Arc Drive
[State -1, Arc Drive]
type = ChangeState
value = 900
triggerall = command = "Arc_Drive"
triggerall = statetype != A
triggerall = var(35)=1 || var(35)=3
trigger1 = ctrl
trigger2 = movehit
trigger2 = stateno = 200
trigger2 = time > 5
trigger3 = movehit
trigger3 = stateno = 210
trigger3 = time > 5
trigger4 = movehit
trigger4 = stateno = 230
trigger4 = time > 11
trigger5 = movehit
trigger5 = anim = 242
trigger5 = time > 5
;===========================================================================
;Another Arc Drive
[State -1, Another Arc Drive]
type = ChangeState
value = 1000
triggerall = command = "Arc_Drive"
triggerall = statetype != A
triggerall = var(35)=2
trigger1 = ctrl
trigger2 = movehit
trigger2 = stateno = 200
trigger2 = time > 5
trigger3 = movehit
trigger3 = stateno = 210
trigger3 = time > 5
trigger4 = movehit
trigger4 = stateno = 230
trigger4 = time > 11
trigger5 = movehit
trigger5 = anim = 242
trigger5 = time > 5
;===========================================================================
;Fire Uppercut EX EDGE
[State -1, Fire Uppercut, EX EDGE]
type = ChangeState
value = 520
triggerall = command = "Z_C"
triggerall = statetype != A
triggerall = (power>=1000 && var(35)=0) || var(35)>0
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = movehit
trigger2 = stateno = 200
trigger2 = time > 5
trigger3 = movehit
trigger3 = stateno = 210
trigger3 = time > 5
trigger4 = movehit
trigger4 = stateno = 230
trigger4 = time > 11
trigger5 = movehit
trigger5 = anim = 242
trigger5 = time > 5
;===========================================================================
;Fire Uppercut Type A
[State -1, Fire Uppercut Type A]
type = ChangeState
value = 500
triggerall = command = "Z_A"
triggerall = statetype != A
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = movehit
trigger2 = stateno = 200
trigger2 = time > 5
trigger3 = movehit
trigger3 = stateno = 210
trigger3 = time > 5
trigger4 = movehit
trigger4 = stateno = 230
trigger4 = time > 11
trigger5 = movehit
trigger5 = anim = 242
trigger5 = time > 5
;===========================================================================
;Fire Uppercut Type B
[State -1, Fire Uppercut Type B]
type = ChangeState
value = 510
triggerall = command = "Z_B"
triggerall = statetype != A
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = movehit
trigger2 = stateno = 200
trigger2 = time > 5
trigger3 = movehit
trigger3 = stateno = 210
trigger3 = time > 5
trigger4 = movehit
trigger4 = stateno = 230
trigger4 = time > 11
trigger5 = movehit
trigger5 = anim = 242
trigger5 = time > 5
;===========================================================================
;Fire Uppercut Type C
[State -1, Fire Uppercut Type C]
type = ChangeState
value = 510
triggerall = command = "Z_C"
triggerall = statetype != A
triggerall = power < 1000
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = movehit
trigger2 = stateno = 200
trigger2 = time > 5
trigger3 = movehit
trigger3 = stateno = 210
trigger3 = time > 5
trigger4 = movehit
trigger4 = stateno = 230
trigger4 = time > 11
trigger5 = movehit
trigger5 = anim = 242
trigger5 = time > 5
;---------------------------------------------------------------------------
;Chain Combo EX
[State -1, Chain Combo, EX EDGE]
type = ChangeState
value = 420
triggerall = command = "QCF_C"
triggerall = statetype != A
triggerall = (power>=1000 && var(35)=0) || var(35)>0
trigger1 = ctrl
trigger2 = movehit
trigger2 = stateno = 200
trigger2 = time > 5
trigger3 = movehit
trigger3 = stateno = 210
trigger3 = time > 5
trigger4 = movehit
trigger4 = stateno = 230
trigger4 = time > 11
trigger5 = movehit
trigger5 = anim = 242
trigger5 = time > 5
;===========================================================================
;Chain Combo A
[State -1, Chain Combo, Type A]
type = ChangeState
value = 400
triggerall = command = "QCF_A"
triggerall = statetype != A
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = movehit
trigger2 = stateno = 200
trigger2 = time > 5
trigger3 = movehit
trigger3 = stateno = 210
trigger3 = time > 5
trigger4 = movehit
trigger4 = stateno = 230
trigger4 = time > 11
trigger5 = movehit
trigger5 = anim = 242
trigger5 = time > 5
;---------------------------------------------------------------------------
;Chain Combo B
[State -1, Chain Combo, Type B]
type = ChangeState
value = 410
triggerall = command = "QCF_B"
triggerall = statetype != A
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = movehit
trigger2 = stateno = 200
trigger2 = time > 5
trigger3 = movehit
trigger3 = stateno = 210
trigger3 = time > 5
trigger4 = movehit
trigger4 = stateno = 230
trigger4 = time > 11
trigger5 = movehit
trigger5 = anim = 242
trigger5 = time > 5
;---------------------------------------------------------------------------
;Chain Combo C
[State -1, Chain Combo, Type C]
type = ChangeState
value = 410
triggerall = command = "QCF_C"
triggerall = statetype != A
triggerall = power < 1000
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = movehit
trigger2 = stateno = 200
trigger2 = time > 5
trigger3 = movehit
trigger3 = stateno = 210
trigger3 = time > 5
trigger4 = movehit
trigger4 = stateno = 230
trigger4 = time > 11
trigger5 = movehit
trigger5 = anim = 242
trigger5 = time > 5
;---------------------------------------------------------------------------
;RoundHouse Fire Kick - EX EDGE
[State -1, RoundHouse Fire Kick, EX EDGE]
type = ChangeState
value = 620
triggerall = command = "QCB_C"
triggerall = statetype != A
triggerall = (power>=1000 && var(35)=0) || var(35)>0
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = movehit
trigger2 = stateno = 200
trigger2 = time > 5
trigger3 = movehit
trigger3 = stateno = 210
trigger3 = time > 5
trigger4 = movehit
trigger4 = stateno = 230
trigger4 = time > 11
trigger5 = movehit
trigger5 = anim = 242
trigger5 = time > 5
;===========================================================================
;RoundHouse Fire Kick - Type A
[State -1, RoundHouse Fire Kick, Type A]
type = ChangeState
value = 600
triggerall = command = "QCB_A"
triggerall = statetype != A
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = movehit
trigger2 = stateno = 200
trigger2 = time > 5
trigger3 = movehit
trigger3 = stateno = 210
trigger3 = time > 5
trigger4 = movehit
trigger4 = stateno = 230
trigger4 = time > 11
trigger5 = movehit
trigger5 = anim = 242
trigger5 = time > 5
;---------------------------------------------------------------------------
;RoundHouse Fire Kick - Type B
[State -1, RoundHouse Fire Kick, Type B]
type = ChangeState
value = 610
triggerall = command = "QCB_B"
triggerall = statetype != A
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = movehit
trigger2 = stateno = 200
trigger2 = time > 5
trigger3 = movehit
trigger3 = stateno = 210
trigger3 = time > 5
trigger4 = movehit
trigger4 = stateno = 230
trigger4 = time > 11
trigger5 = movehit
trigger5 = anim = 242
trigger5 = time > 5
;---------------------------------------------------------------------------
;RoundHouse Fire Kick - Type C
[State -1, RoundHouse Fire Kick, Type C]
type = ChangeState
value = 610
triggerall = command = "QCB_C"
triggerall = statetype != A
triggerall = power < 1000
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = movehit
trigger2 = stateno = 200
trigger2 = time > 5
trigger3 = movehit
trigger3 = stateno = 210
trigger3 = time > 5
trigger4 = movehit
trigger4 = stateno = 230
trigger4 = time > 11
trigger5 = movehit
trigger5 = anim = 242
trigger5 = time > 5
;---------------------------------------------------------------------------
;Flame Explosion - EX EDGE
[State -1, Flame Explosion, EX EDGE]
type = ChangeState
value = 720
triggerall = command = "DD_C"
triggerall = statetype != A
triggerall = (power>=1000 && var(35)=0) || var(35)>0
trigger1 = ctrl
trigger2 = movehit
trigger2 = stateno = 200
trigger2 = time > 5
trigger3 = movehit
trigger3 = stateno = 210
trigger3 = time > 5
trigger4 = movehit
trigger4 = stateno = 230
trigger4 = time > 11
trigger5 = movehit
trigger5 = anim = 242
trigger5 = time > 5
;===========================================================================
;Flame Explosion - Type A
[State -1, Flame Explosion, Type A]
type = ChangeState
value = 700
triggerall = command = "DD_A"
triggerall = statetype != A
trigger1 = ctrl
trigger2 = movehit
trigger2 = stateno = 200
trigger2 = time > 5
trigger3 = movehit
trigger3 = stateno = 210
trigger3 = time > 5
trigger4 = movehit
trigger4 = stateno = 230
trigger4 = time > 11
trigger5 = movehit
trigger5 = anim = 242
trigger5 = time > 5
;---------------------------------------------------------------------------
;Flame Explosion - Type B
[State -1, Flame Explosion, Type B]
type = ChangeState
value = 710
triggerall = command = "DD_B"
triggerall = statetype != A
trigger1 = ctrl
trigger2 = movehit
trigger2 = stateno = 200
trigger2 = time > 5
trigger3 = movehit
trigger3 = stateno = 210
trigger3 = time > 5
trigger4 = movehit
trigger4 = stateno = 230
trigger4 = time > 11
trigger5 = movehit
trigger5 = anim = 242
trigger5 = time > 5
;---------------------------------------------------------------------------
;Flame Explosion - Type C
[State -1, Flame Explosion, Type C]
type = ChangeState
value = 710
triggerall = command = "DD_C"
triggerall = statetype != A
triggerall = power < 1000
trigger1 = ctrl
trigger2 = movehit
trigger2 = stateno = 200
trigger2 = time > 5
trigger3 = movehit
trigger3 = stateno = 210
trigger3 = time > 5
trigger4 = movehit
trigger4 = stateno = 230
trigger4 = time > 11
trigger5 = movehit
trigger5 = anim = 242
trigger5 = time > 5
;---------------------------------------------------------------------------
;RoundHouse Fire Kick AIR - Ex Edge
[State -1, RHF Kick Air, EX EDGE]
type = ChangeState
value = 670
triggerall = command = "QCB_C"
triggerall = (power>=1000 && var(35)=0) || var(35)>0
trigger1 = statetype = A
trigger1 = ctrl
trigger2 = movehit
trigger2 = stateno = 220
trigger2 = time > 6
trigger3 = movehit
trigger3 = stateno = 250
trigger3 = time > 9
;===========================================================================
;RoundHouse Fire Kick AIR - Type A
[State -1, RHF Kick Air, Type A]
type = ChangeState
value = 650
triggerall = command = "QCB_A"
trigger1 = statetype = A
trigger1 = ctrl
trigger2 = movehit
trigger2 = stateno = 220
trigger2 = time > 6
trigger3 = movehit
trigger3 = stateno = 250
trigger3 = time > 9
;---------------------------------------------------------------------------
;RoundHouse Fire Kick AIR - Type B
[State -1, RHF Kick Air, Type B]
type = ChangeState
value = 660
triggerall = command = "QCB_B"
trigger1 = statetype = A
trigger1 = ctrl
trigger2 = movehit
trigger2 = stateno = 220
trigger2 = time > 6
trigger3 = movehit
trigger3 = stateno = 250
trigger3 = time > 9
;---------------------------------------------------------------------------
;RoundHouse Fire Kick AIR - Type C
[State -1, RHF Kick Air, Type C]
type = ChangeState
value = 660
triggerall = command = "QCB_C"
triggerall = power < 1000
trigger1 = statetype = A
trigger1 = ctrl
trigger2 = movehit
trigger2 = stateno = 220
trigger2 = time > 6
trigger3 = movehit
trigger3 = stateno = 250
trigger3 = time > 9
;---------------------------------------------------------------------------
;A
[State -1, A]
type = ChangeState
value = 200
triggerall = command = "a"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = stateno = 200
trigger2 = time > 5
trigger3 = stateno = 210
trigger3 = time > 5
trigger3 = fvar(20)=1
;---------------------------------------------------------------------------
;Crouch A
[State -1, Crouch A]
type = ChangeState
value = 210
triggerall = command = "a"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
trigger2 = fvar(21)=1
trigger2 = stateno = 200
trigger2 = time > 5
trigger3 = stateno = 210
trigger3 = time > 5
;---------------------------------------------------------------------------
;Jump A
[State -1, Jump A]
type = ChangeState
value = 220
triggerall = command = "a"
trigger1 = statetype = A
trigger1 = ctrl
;trigger2 = movehit
;trigger2 = stateno = 220
;trigger2 = time > 6
trigger2 = movehit
trigger2 = stateno = 250
trigger2 = time > 9
;---------------------------------------------------------------------------
;B
[State -1, B]
type = ChangeState
value = 230
triggerall = command = "b"
triggerall = command != "holddown"
triggerall = fvar(23)=1
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = movehit
trigger2 = stateno = 200
trigger2 = time > 5
trigger3 = movehit
trigger3 = stateno = 210
trigger3 = time > 5
trigger4 = movehit
;trigger4 = prevstateno != 230
trigger4 = anim = 242
trigger4 = time > 5

;---------------------------------------------------------------------------
;Crouch B
[State -1, Crouch B]
type = ChangeState
value = 240
triggerall = command = "b"
triggerall = command = "holddown"
triggerall = command != "holdfwd"
triggerall = fvar(24)=1
trigger1 = statetype = C
trigger1 = ctrl
trigger2 = movehit
trigger2 = stateno = 200
trigger2 = time > 5
trigger3 = movehit
trigger3 = stateno = 210
trigger3 = time > 5
trigger4 = movehit
;trigger4 = prevstateno != 240
trigger4 = stateno = 230
trigger4 = time > 11

;---------------------------------------------------------------------------
;Upper Kick
[State -1, Upper Kick]
type = ChangeState
value = 280
triggerall = command = "b"
triggerall = command = "holddown"
triggerall = command = "holdfwd"
trigger1 = statetype = C
trigger1 = ctrl
trigger2 = movehit
trigger2 = stateno = 200
trigger2 = time > 5
trigger3 = movehit
trigger3 = stateno = 210
trigger3 = time > 5
trigger4 = movehit
trigger4 = stateno = 230
trigger4 = time > 11
trigger5 = movehit
trigger5 = anim = 242
trigger5 = time > 5

;---------------------------------------------------------------------------
;Jump B
[State -1, Jump B]
type = ChangeState
value = 250
triggerall = command = "b"
trigger1 = statetype = A
trigger1 = ctrl
trigger2 = movehit
trigger2 = stateno = 220
trigger2 = time > 6
;trigger3 = movehit
;trigger3 = stateno = 250
;trigger3 = time > 9
;---------------------------------------------------------------------------
;C
[State -1, C]
type = ChangeState
value = 270
triggerall = command = "c"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = movehit
trigger2 = stateno = 200
trigger2 = time > 5
trigger3 = movehit
trigger3 = stateno = 210
trigger3 = time > 5
trigger4 = movehit
trigger4 = stateno = 230
trigger4 = time > 11
trigger5 = movehit
trigger5 = anim = 242
trigger5 = time > 5
trigger6 = stateno = 260
trigger6 = movehit
trigger6 = animelem = 5,>1
trigger6 = animelem = 6,<1
;---------------------------------------------------------------------------
;Crouch C
[State -1, Crouch C]
type = ChangeState
value = 260
triggerall = command = "c"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
trigger2 = movehit
trigger2 = stateno = 200
trigger2 = time > 5
trigger3 = movehit
trigger3 = stateno = 210
trigger3 = time > 5
trigger4 = movehit
trigger4 = stateno = 230
trigger4 = time > 11
trigger5 = movehit
trigger5 = anim = 242
trigger5 = time > 5
;---------------------------------------------------------------------------
;Jump C
[State -1, Jump C]
type = ChangeState
value = 290
triggerall = command = "c"
triggerall = command != "holddown"
trigger1 = statetype = A
trigger1 = ctrl
trigger2 = movehit
trigger2 = stateno = 220
trigger2 = time > 6
trigger3 = movehit
trigger3 = stateno = 250
trigger3 = time > 9
;---------------------------------------------------------------------------
;Jump Down C
[State -1, Jump Down C]
type = ChangeState
value = 300
triggerall = command = "c"
triggerall = command = "holddown"
trigger1 = statetype = A
trigger1 = ctrl
trigger2 = movehit
trigger2 = stateno = 220
trigger2 = time > 6
trigger3 = movehit
trigger3 = stateno = 250
trigger3 = time > 9
