sampler2D Tex0;

struct PS_INPUT{
    float4 Color			: COLOR0;
    float2 Tex				: TEXCOORD0;
	float4 Color2			: TEXCOORD1;
};

struct PS_OUTPUT{
    float4 Color			: COLOR;
};

PS_OUTPUT main(const PS_INPUT Input){
	float4 Color = tex2D(Tex0, Input.Tex);
	
	PS_OUTPUT Out;
#if defined(PS11) || defined(PS12) || defined(PS13) || defined(PS14)
	Out.Color = Color * float4(Input.Color2.rgb, Input.Color.a);
#else
	Out.Color = Color * Input.Color;
#endif	
	return Out;
}

/*

float4 RGB2HSL(float4 RGB){
	float h, s, l;
    float v;
    float m;
    float vm;
    float r2, g2, b2;

    v = max(RGB.r, RGB.g);
    v = max(v, RGB.b);
    m = min(RGB.r, RGB.g);
    m = min(m, RGB.b);

    if ((l = (m + v) / 2.0) <= 0.0){
		h = 0;
		s = 0;
	}
    
    if ((s = vm = v - m) > 0.0){
		s /= (l <= 0.5) ? (v + m) : (2.0 - v - m) ;
    }
    else{
		h = 0;
	}

    r2 = (v - RGB.r) / vm;
    g2 = (v - RGB.g) / vm;
    b2 = (v - RGB.b) / vm;

    if (RGB.r == v){
		h = (RGB.g == m ? 5.0 + b2 : 1.0 - g2);
	}
    else if (RGB.g == v){
		h = (RGB.b == m ? 1.0 + r2 : 3.0 - b2);
	}
    else{
		h = (RGB.r == m ? 3.0 + g2 : 5.0 - r2);

    	h /= 6;
	}
	
	float4 HSL;
	HSL.x = h;
	HSL.y = s;
	HSL.z = l;
	HSL.a = RGB.a;
	return HSL;
}

float4 HSL2RGB(float4 HSL){
    float v;
    
    float h = HSL.x;
    float s = HSL.y;
    float l = HSL.z;
    
    float sl = s * l;
    
    float4 RGB;

    v = (l <= 0.5) ? (l * (1.0 + sl)) : (l + sl - l * sl);
    if (v <= 0){
		RGB.r = RGB.g = RGB.b = 0.0;
    }
    else{
		float m;
		float sv;
		int sextant;
		float fract, vsf, mid1, mid2;

		m = l + l - v;
		sv = (v - m ) / v;
		h *= 6.0;
		sextant = h;	
		fract = h - sextant;
		vsf = v * sv * fract;
		mid1 = m + vsf;
		mid2 = v - vsf;
		
		if (sextant == 0){
			RGB.r = v; RGB.g = mid1; RGB.b = m;
		}
		else if (sextant == 1){
			RGB.r = mid2; RGB.g = v; RGB.b = m;
		}
		else if (sextant == 2){
			RGB.r = m; RGB.g = v; RGB.b = mid1;
		}
		else if (sextant == 3){
			RGB.r = m; RGB.g = mid2; RGB.b = v;
		}
		else if (sextant == 4){
			RGB.r = mid1; RGB.g = m; RGB.b = v;
		}
		else if (sextant == 5){
			RGB.r = v; RGB.g = m; RGB.b = mid2;
		}
    }
    
    RGB.a = HSL.a;
    return RGB;
}

PS_OUTPUT main(const PS_INPUT Input){
	float4 HSL = Input.Color;//RGB2HSL(tex2D(Tex0, Input.Tex));
	
	PS_OUTPUT Out;
	Out.Color = HSL2RGB(HSL);// * Input.Color;
	return Out;
}*/
