sampler2D Tex0;

struct PS_INPUT{
    float4 Color			: COLOR0;
    float2 Tex				: TEXCOORD0;
};

struct PS_OUTPUT{
    float4 Color			: COLOR;
};

PS_OUTPUT main(const PS_INPUT Input){
	float4 Src = tex2D(Tex0, Input.Tex);
	float4 Overlay = Input.Color;
	
	float4 Blend = step(Src, float4(0.5f, 0.5f, 0.5f, 0.5f));
	
	float4 Bigger = 1.0f - (1.0f - 2 * (Src - 0.5f)) * (1.0f - Overlay);
	float4 Smaller = (2 * Src) * Overlay;
	
	float4 Dest = lerp(Bigger, Smaller, Blend);
	
	PS_OUTPUT Out;
	Out.Color = Dest;
	Out.Color.a = Overlay.a * Src.a;
	return Out;
}