// transformations
float4x4 World : register(c0);

struct VS_OUTPUT{
    float4 Pos				: POSITION;
    float4 Color			: COLOR0;
    float2 Tex				: TEXCOORD0;
	float4 Color2			: TEXCOORD1;
};

struct VS_INPUT{
    float2 Pos				: POSITION;
    float4 Color			: COLOR0;
    float2 Tex				: TEXCOORD0;
};

float SpriteOffsetX;
float SpriteOffsetY;

VS_OUTPUT main(const VS_INPUT Input){
	float2 InputPos = Input.Pos;
	//InputPos.x += 0.5f;
	//InputPos.y += 0.5f;

	float2 P;
	P.x = InputPos.x * World[0][0] + InputPos.y * World[0][1] + World[0][3];
	P.y = InputPos.x * World[1][0] + InputPos.y * World[1][1] + World[1][3];
	
	//P.x += SpriteOffsetX;
	//P.y += SpriteOffsetY;
	
	//P.x += 0.5f / 800;
	//P.y += 0.5f / 600;
	
	VS_OUTPUT Out;
    Out.Pos = float4(P, 0, 1);
    Out.Color = Input.Color;
    Out.Tex= float2(1.0f - Input.Tex.x, Input.Tex.y); 
    Out.Color2 = Input.Color;                                  

    return Out;
}