#ifndef CAMPOS_DEFINED
#define CAMPOS_DEFINED
float3 CamPos;
#endif

#ifndef FOG_DEFINED
#define FOG_DEFINED
float FogNear;
float FogRange;
float InvFogRange;
#endif

#include "dcCubeNormalize.HLSL"

void LineVertexDist(float3 Point, float3 Origin, float3 Direction, out float T){
    float3 Diff = Point - Origin;
    T = dot(Diff, Direction);
    
    T /= dot(Direction, Direction);
    T = clamp(T, 0, 1);
}

#ifdef HQ_POSNORMAL
float PackPos(float3 Diff){
	return length(Diff);
}

float3 UnpackPos(float Length, float3 ViewDir){
	float3 Pos = Normalize(ViewDir) * Length;
	Pos += CamPos;

	return Pos;
}

float3 UnpackNormal(float3 Input){
	return Input;
}

float ComputeFog(float Input){
	return clamp((Input - FogNear) * InvFogRange, 0, 1);
}

#define dcNormalData(x, y) float3 x[2] : y

#define OutputNormalData(x) Out.Normal[0] = x;
#define OutputPosData(x) Out.Normal[1] = x - CamPos;

#else
#include "dcCubeNormalize.HLSL"
float PackPos(float Pos){
	return Pos;
}

float3 UnpackPos(float Input, float3 ViewDir){
	/*float Length = (Input * FogRange) + FogNear;

	float3 Pos = Normalize(ViewDir) * Length;
	Pos += CamPos;

	return Pos;*/
	
	return 0;
}

float3 UnpackNormal(float3 Input){
	return (Input - 0.5f) * 2;
}

float ComputeFog(float Input){
	return Input;
}

#ifndef NORMALCOLOR1
#define dcNormalData(x, y) float4 x : COLOR0
#else
#define dcNormalData(x, y) float4 x : COLOR1
#endif

#define OutputNormalData(x) Out.Normal.xyz = (x / 2) + 0.5f;
#define OutputPosData(x) Out.Normal.w = (length(Pos - CamPos) - FogNear) * InvFogRange;

#endif

