// transformations
float4x4 World : register(c0);

struct VS_OUTPUT{
    float4 Pos				: POSITION;
    float4 Color			: COLOR0;
    float2 Tex0				: TEXCOORD0;
    float2 Tex1				: TEXCOORD1;
};

struct VS_INPUT{
    float2 Pos				: POSITION;
    float4 Color			: COLOR0;
    float2 Tex				: TEXCOORD0;
};

VS_OUTPUT main(const VS_INPUT Input){
	float2 InputPos = Input.Pos;
	//InputPos.x += 0.5f;
	//InputPos.y += 0.5f;

	float2 P;
	P.x = InputPos.x * World[0][0] + InputPos.y * World[0][1] + World[0][3];
	P.y = InputPos.x * World[1][0] + InputPos.y * World[1][1] + World[1][3];
	
	VS_OUTPUT Out;
    Out.Pos = float4(P, 0, 1);
    Out.Color = Input.Color;
    Out.Tex0  = Input.Tex;
    Out.Tex1 = Input.Tex;
    return Out;
}