sampler2D Tex0;
sampler2D BlurMask;

struct PS_INPUT{
    float4 Color			: COLOR0;
    float2 Tex0				: TEXCOORD0;
    float2 Tex1				: TEXCOORD1;
};

struct PS_OUTPUT{
    float4 Color			: COLOR;
};

PS_OUTPUT main(const PS_INPUT Input){
	float4 Color = float4(tex2D(Tex0, Input.Tex0).xyz, 1) * tex2D(BlurMask, Input.Tex1);
	
	PS_OUTPUT Out;
	Out.Color.rgb = Color.rgb * Input.Color.rgb;
	Out.Color.a = lerp(1, Color.a, Input.Color.a);
	return Out;
}