struct PS_OUTPUT{
#ifdef MRT
	float4 Color			: COLOR0;
	float4 Normal			: COLOR1;
#ifdef RT_MATERIAL
#ifndef MRT_FORCE_NOMATERIAL
	float4 Material			: COLOR2;
#endif
#endif
#else
	float4 Data				: COLOR0;
#endif
};

// void OutputNormal(float4)
#ifdef RT_NORMAL
	#ifdef HQ_POSNORMAL
		#ifdef MRT
			#define OutputNormal(x) Out.Normal = float4(x[0], length(x[1]));
			#define OutputNormalEx(x, y) Out.Normal = float4(x, length(y[1]));
		#else
			#define OutputNormal(x) Out.Data = float4(x[0], length(x[1]));
			#define OutputNormalEx(x, y) Out.Data = float4(x, length(y[1]));
		#endif
	#else
		#ifdef MRT
			#define OutputNormal(x) Out.Normal = x
			#define OutputNormalEx(x, y) Out.Normal = float4(x, y.w);
		#else
			#define OutputNormal(x) Out.Data = x
			#define OutputNormalEx(x, y) Out.Data = float4(x, y.w);
		#endif
	#endif
	
#else
	#define OutputNormal(x)
	#define OutputNormalEx(x, y)
#endif

// void OutputMaterial(float4)
#ifdef RT_MATERIAL
	#ifdef MRT
		#ifndef MRT_FORCE_NOMATERIAL
			#define OutputMaterial(x) Out.Material = x
		#else
			#define OutputMaterial(x)
		#endif
	#else
		#define OutputMaterial(x) Out.Data = x
	#endif
#else
	#define OutputMaterial(x)
#endif

// void OutputColor(float4)
#ifdef RT_COLOR
	#ifdef MRT
		#define OutputColor(x) Out.Color = x
	#else
		#define OutputColor(x) Out.Data = x
	#endif
#else
	#define OutputColor(x)
#endif