static float Epsilon = 0.0000001f;

float LineLine(float3 _Origin0, float3 Dir0, float Length0, float3 _Origin1, float3 Dir1, float Length1, out float3 m_kClosestPoint[2], out float m_fSegmentParameter[2]){
	float Extent0 = Length0 / 2;
	float Extent1 = Length1 / 2;
	
	float3 Origin0 = _Origin0 + Dir0 * Extent0;
	float3 Origin1 = _Origin1 + Dir1 * Extent1;

	float3 kDiff = Origin0 - Origin1;
    float fA01 = dot(-Dir0, Dir1);
    float fB0 = dot(kDiff, Dir0);
    float fB1 = dot(-kDiff, Dir1);
    float fC = dot(kDiff, kDiff);
    float fDet = abs(1.0 - fA01 * fA01);
    float fS0, fS1, fSqrDist, fExtDet0, fExtDet1, fTmpS0, fTmpS1;

    if (fDet >= Epsilon){
        // segments are not parallel
        fS0 = fA01*fB1-fB0;
        fS1 = fA01*fB0-fB1;
        fExtDet0 = Extent0*fDet;
        fExtDet1 = Extent1*fDet;

        if (fS0 >= -fExtDet0){
            if (fS0 <= fExtDet0){
                if (fS1 >= -fExtDet1){
                    if (fS1 <= fExtDet1){  // region 0 (interior)
                        // minimum at two interior points of 3D lines
                        float fInvDet = (1.0)/fDet;
                        fS0 *= fInvDet;
                        fS1 *= fInvDet;
                        fSqrDist = fS0*(fS0+fA01*fS1+(2.0)*fB0) + fS1*(fA01*fS0+fS1+(2.0)*fB1)+fC;
                    }
                    else{  // region 3 (side)
                        fS1 = Extent1;
                        fTmpS0 = -(fA01*fS1+fB0);
                        if (fTmpS0 < -Extent0){
                            fS0 = -Extent0;
                            fSqrDist = fS0*(fS0-(2.0)*fTmpS0) + fS1*(fS1+(2.0)*fB1)+fC;
                        }
                        else if (fTmpS0 <= Extent0){
                            fS0 = fTmpS0;
                            fSqrDist = -fS0*fS0+fS1*(fS1+(2.0)*fB1)+fC;
                        }
                        else{
                            fS0 = Extent0;
                            fSqrDist = fS0*(fS0-(2.0)*fTmpS0) + fS1*(fS1+(2.0)*fB1)+fC;
                        }
                    }
                }
                else{  // region 7 (side)
                    fS1 = -Extent1;
                    fTmpS0 = -(fA01*fS1+fB0);
                    if (fTmpS0 < -Extent0){
                        fS0 = -Extent0;
                        fSqrDist = fS0*(fS0-(2.0)*fTmpS0) + fS1*(fS1+(2.0)*fB1)+fC;
                    }
                    else if (fTmpS0 <= Extent0){
                        fS0 = fTmpS0;
                        fSqrDist = -fS0*fS0+fS1*(fS1+(2.0)*fB1)+fC;
                    }
                    else{
                        fS0 = Extent0;
                        fSqrDist = fS0*(fS0-(2.0)*fTmpS0) + fS1*(fS1+(2.0)*fB1)+fC;
                    }
                }
            }
            else{
                if (fS1 >= -fExtDet1){
                    if (fS1 <= fExtDet1){  // region 1 (side)
                        fS0 = Extent0;
                        fTmpS1 = -(fA01*fS0+fB1);
                        if (fTmpS1 < -Extent1){
                            fS1 = -Extent1;
                            fSqrDist = fS1*(fS1-(2.0)*fTmpS1) + fS0*(fS0+(2.0)*fB0)+fC;
                        }
                        else if (fTmpS1 <= Extent1){
                            fS1 = fTmpS1;
                            fSqrDist = -fS1*fS1+fS0*(fS0+(2.0)*fB0)+fC;
                        }
                        else {
                            fS1 = Extent1;
                            fSqrDist = fS1*(fS1-(2.0)*fTmpS1) + fS0*(fS0+(2.0)*fB0)+fC;
                        }
                    }
                    else{  // region 2 (corner)
                        fS1 = Extent1;
                        fTmpS0 = -(fA01*fS1+fB0);
                        if (fTmpS0 < -Extent0){
                            fS0 = -Extent0;
                            fSqrDist = fS0*(fS0-(2.0)*fTmpS0) + fS1*(fS1+(2.0)*fB1)+fC;
                        }
                        else if (fTmpS0 <= Extent0){
                            fS0 = fTmpS0;
                            fSqrDist = -fS0*fS0+fS1*(fS1+(2.0)*fB1)+fC;
                        }
                        else{
                            fS0 = Extent0;
                            fTmpS1 = -(fA01*fS0+fB1);
                            if (fTmpS1 < -Extent0){
                                fS1 = -Extent1;
                                fSqrDist = fS1*(fS1-(2.0)*fTmpS1) + fS0*(fS0+(2.0)*fB0)+fC;
                            }
                            else if (fTmpS1 <= Extent1){
                                fS1 = fTmpS1;
                                fSqrDist = -fS1*fS1+fS0*(fS0+(2.0)*fB0)+ fC;
                            }
                            else{
                                fS1 = Extent1;
                                fSqrDist = fS1*(fS1-(2.0)*fTmpS1) +
                                    fS0*(fS0+(2.0)*fB0)+fC;
                            }
                        }
                    }
                }
                else{  // region 8 (corner)
                    fS1 = -Extent1;
                    fTmpS0 = -(fA01*fS1+fB0);
                    if (fTmpS0 < -Extent0) {
                        fS0 = -Extent0;
                        fSqrDist = fS0*(fS0-(2.0)*fTmpS0) +
                            fS1*(fS1+(2.0)*fB1)+fC;
                    }
                    else if (fTmpS0 <= Extent0){
                        fS0 = fTmpS0;
                        fSqrDist = -fS0*fS0+fS1*(fS1+(2.0)*fB1)+fC;
                    }
                    else{
                        fS0 = Extent0;
                        fTmpS1 = -(fA01*fS0+fB1);
                        if (fTmpS1 > Extent1){
                            fS1 = Extent1;
                            fSqrDist = fS1*(fS1-(2.0)*fTmpS1) +
                                fS0*(fS0+(2.0)*fB0)+fC;
                        }
                        else if (fTmpS1 >= -Extent1){
                            fS1 = fTmpS1;
                            fSqrDist = -fS1*fS1+fS0*(fS0+(2.0)*fB0)
                                + fC;
                        }
                        else{
                            fS1 = -Extent1;
                            fSqrDist = fS1*(fS1-(2.0)*fTmpS1) +
                                fS0*(fS0+(2.0)*fB0)+fC;
                        }
                    }
                }
            }
        }
        else {
            if (fS1 >= -fExtDet1){
                if (fS1 <= fExtDet1){  // region 5 (side)
                    fS0 = -Extent0;
                    fTmpS1 = -(fA01*fS0+fB1);
                    if (fTmpS1 < -Extent1){
                        fS1 = -Extent1;
                        fSqrDist = fS1*(fS1-(2.0)*fTmpS1) +
                            fS0*(fS0+(2.0)*fB0)+fC;
                    }
                    else if (fTmpS1 <= Extent1){
                        fS1 = fTmpS1;
                        fSqrDist = -fS1*fS1+fS0*(fS0+(2.0)*fB0)+fC;
                    }
                    else{
                        fS1 = Extent1;
                        fSqrDist = fS1*(fS1-(2.0)*fTmpS1) +
                            fS0*(fS0+(2.0)*fB0)+fC;
                    }
                }
                else{  // region 4 (corner)
                    fS1 = Extent1;
                    fTmpS0 = -(fA01*fS1+fB0);
                    if (fTmpS0 > Extent0){
                        fS0 = Extent0;
                        fSqrDist = fS0*(fS0-(2.0)*fTmpS0) +
                            fS1*(fS1+(2.0)*fB1)+fC;
                    }
                    else if (fTmpS0 >= -Extent0){
                        fS0 = fTmpS0;
                        fSqrDist = -fS0*fS0+fS1*(fS1+(2.0)*fB1)+fC;
                    }
                    else{
                        fS0 = -Extent0;
                        fTmpS1 = -(fA01*fS0+fB1);
                        if (fTmpS1 < -Extent1){
                            fS1 = -Extent1;
                            fSqrDist = fS1*(fS1-(2.0)*fTmpS1) + fS0*(fS0+(2.0)*fB0)+fC;
                        }
                        else if (fTmpS1 <= Extent1){
                            fS1 = fTmpS1;
                            fSqrDist = -fS1*fS1+fS0*(fS0+(2.0)*fB0) + fC;
                        }
                        else{
                            fS1 = Extent1;
                            fSqrDist = fS1*(fS1-(2.0)*fTmpS1) + fS0*(fS0+(2.0)*fB0)+fC;
                        }
                    }
                }
            }
            else{   // region 6 (corner)
                fS1 = -Extent1;
                fTmpS0 = -(fA01*fS1+fB0);
                if (fTmpS0 > Extent0){
                    fS0 = Extent0;
                    fSqrDist = fS0*(fS0-(2.0)*fTmpS0) + fS1*(fS1+(2.0)*fB1)+fC;
                }
                else if (fTmpS0 >= -Extent0){
                    fS0 = fTmpS0;
                    fSqrDist = -fS0*fS0+fS1*(fS1+(2.0)*fB1)+fC;
                }
                else{
                    fS0 = -Extent0;
                    fTmpS1 = -(fA01*fS0+fB1);
                    if (fTmpS1 < -Extent1){
                        fS1 = -Extent1;
                        fSqrDist = fS1*(fS1-(2.0)*fTmpS1) + fS0*(fS0+(2.0)*fB0)+fC;
                    }
                    else if (fTmpS1 <= Extent1){
                        fS1 = fTmpS1;
                        fSqrDist = -fS1*fS1+fS0*(fS0+(2.0)*fB0) + fC;
                    }
                    else{
                        fS1 = Extent1;
                        fSqrDist = fS1*(fS1-(2.0)*fTmpS1) + fS0*(fS0+(2.0)*fB0)+fC;
                    }
                }
            }
        }
    }
    else{
        // The segments are parallel.  The average b0 term is designed to
        // ensure symmetry of the function.  That is, dist(seg0,seg1) and
        // dist(seg1,seg0) should produce the same number.
        float fE0pE1 = Extent0 + Extent1;
        float fSign = (fA01 > 0.0 ? -1.0 : 1.0);
        float fB0Avr = (0.5)*(fB0 - fSign*fB1);
        float fLambda = -fB0Avr;
        if (fLambda < -fE0pE1){
            fLambda = -fE0pE1;
        }
        else if (fLambda > fE0pE1){
            fLambda = fE0pE1;
        }

        fS1 = -fSign*fLambda*Extent1/fE0pE1;
        fS0 = fLambda + fSign*fS1;
        fSqrDist = fLambda*(fLambda + (2.0)*fB0Avr) + fC;
    }

    m_kClosestPoint[0] = Origin0 + fS0 * Dir0;
    m_kClosestPoint[1] = Origin1 + fS1 * Dir1;
    m_fSegmentParameter[0] = fS0;
    m_fSegmentParameter[1] = fS1;
    
    return abs(fSqrDist);
}


// Junk
bool PointCone(float3 ConePos, float3 ConeDir, float ConeAngle, float3 Point){
	float3 kDiff = Point - ConePos;
    float fLSqr = dot(kDiff, kDiff);
	
    float fDot = dot(kDiff, ConeDir);
    float fDotSqr = fDot*fDot;
    float fCosSqr = ConeAngle * ConeAngle;
    if (fDotSqr >= fLSqr * fCosSqr && fDot > 0){
        return true;
    }
    else return false;
}

//static float Epsilon = 0.000001f;
static int IT_EMPTY = 0;
static int IT_POINT = 1;
static int IT_RAY = 2;
static int IT_SEGMENT = 3;

#define SET(Value)				\
	if (m_iQuantity == 0){		\
		m_akPoint[0] = Value;	\
	}							\
	else m_akPoint[1] = Value;

bool LineCone(float3 ConePos, float3 ConeDir, float ConeAngle, float3 LineOrigin, float3 LineDir, float LineLength, out int m_iQuantity, out float3 m_akPoint[2], out float3 Debug){
    float fAdD = dot(ConeDir, LineDir);
    float fCosSqr = ConeAngle * ConeAngle;
    
	float3 kE = LineOrigin - ConePos;
    float fAdE = dot(ConeDir, kE);
    float fDdE = dot(LineDir, kE);
    float fEdE = dot(kE, kE);
    float fC2 = fAdD*fAdD - fCosSqr;
    float fC1 = fAdD*fAdE - fCosSqr*fDdE;
    float fC0 = fAdE*fAdE - fCosSqr*fEdE;
    float fDot;

    int m_iIntersectionType;

    // Solve the quadratic.  Keep only those X for which Dot(A,X-V) >= 0.
    if (abs(fC2) >= Epsilon){
        // c2 != 0
        float fDiscr = fC1*fC1 - fC0*fC2;
        if (fDiscr < 0){
            // Q(t) = 0 has no real-valued roots.  The line does not intersect the double-sided cone.
            m_iIntersectionType = IT_EMPTY;
            m_iQuantity = 0;
            Debug = float3(0, 0, 0);
        }
        else if (fDiscr > Epsilon){
			// Q(t) = 0 has two distinct real-valued roots.  However, one or
            // both of them might intersect the portion of the double-sided
            // cone "behind" the vertex.  We are interested only in those
            // intersections "in front" of the vertex.
            float fRoot = sqrt(fDiscr);
            float fInvC2 = 1.0 / fC2;
            m_iQuantity = 0;

            float fT = (-fC1 - fRoot)*fInvC2;
            //fT = clamp(fT, 0, LineLength);

            SET(LineOrigin + fT * LineDir);
            kE = m_akPoint[m_iQuantity] - ConePos;
            fDot = dot(kE, ConeDir);
            if (fDot > 0){// && fT >= 0){// && fT < LineLength){
                m_iQuantity++;
            }

            fT = (-fC1 + fRoot)*fInvC2;
            //fT = clamp(fT, 0, LineLength);

            SET(LineOrigin + fT * LineDir);
            kE = m_akPoint[m_iQuantity] - ConePos;
            fDot = dot(kE, ConeDir);
			if (fDot > 0){// && fT >= 0){// && fT < LineLength){
                m_iQuantity++;
            }

            if (m_iQuantity == 2){
                // The line intersects the single-sided cone in front of the
                // vertex twice.
                m_iIntersectionType = IT_SEGMENT;
                Debug = float3(0, 0, 1);
            }
            else if (m_iQuantity == 1) {
                // The line intersects the single-sided cone in front of the
                // vertex once.  The other intersection is with the
                // single-sided cone behind the vertex.
                m_iIntersectionType = IT_RAY;
                m_akPoint[0] = LineOrigin;	// New
                m_akPoint[1] = LineDir;
                Debug = float3(0, 1, 0);
            }
            else{
                // The line intersects the single-sided cone behind the vertex
                // twice.
                m_iIntersectionType = IT_EMPTY;
                 Debug = float3(0, 1, 1);
            }
        }
        else{
            // one repeated real root (line is tangent to the cone)
            m_akPoint[0] = LineOrigin;// - (fC1 / fC2) * LineDir;
            kE = m_akPoint[0] - ConePos;
            if (dot(kE, ConeDir) > 0){
                m_iIntersectionType = IT_POINT;
                m_iQuantity = 1;
                 Debug = float3(1, 0, 0);
            }
            else{
                m_iIntersectionType = IT_EMPTY;
                m_iQuantity = 0;
                 Debug = float3(1, 0, 1);
            }
        }
    }
    else if (abs(fC1) >= Epsilon){
        // c2 = 0, c1 != 0 (D is a direction vector on the cone boundary)
        m_akPoint[0] = LineOrigin - (0.5f * fC0 / fC1) * LineDir;
        kE = m_akPoint[0] - ConePos;
        fDot = dot(kE, ConeDir);
        if (fDot > 0){
            m_iIntersectionType = IT_RAY;
            m_iQuantity = 1;//2;
            m_akPoint[0] = LineOrigin;
            m_akPoint[1] = LineDir;
             Debug = float3(1, 1, 0);
        }
        else{
            m_iIntersectionType = IT_EMPTY;
            m_iQuantity = 0;
             Debug = float3(1, 1, 1);
        }
    }
    else if (abs(fC0) >= Epsilon){
        // c2 = c1 = 0, c0 != 0
        m_iIntersectionType = IT_EMPTY;
        m_iQuantity = 0;
         Debug = float3(0.75, 0.75, 0.75);
    }
    else{
        // c2 = c1 = c0 = 0, cone contains ray V+t*D where V is cone vertex
        // and D is the line direction.
        m_iIntersectionType = IT_RAY;
        m_iQuantity = 1;//2;
        m_akPoint[0] = ConePos + ConeDir;
        m_akPoint[1] = LineDir;
         Debug = float3(0.25, 0.25, 0.25);
    }
    
    return m_iIntersectionType != IT_EMPTY;
}















