#include "dcVShaderConstants.HLSL"

//#define ALPHA

float3 CamDir;

//float ZNear;
//float InvZRange;

float3 ShadowCenter;
float3 InvShadowExtents;

struct VS_OUTPUT{
    float4 Pos				: POSITION;
    float3 Diff				: TEXCOORD0;
    
#ifdef ALPHA
	float2 Tex0				: TEXCOORD1;
#endif
};

struct VS_INPUT{
    float3 Pos              : POSITION;
#ifdef ALPHA
	float2 Tex0				: TEXCOORD0;
#endif
#ifdef INSTANCED
	float4x4 World			: TEXCOORD1;
#endif
};

VS_OUTPUT main(const VS_INPUT Input){
#ifdef INSTANCED
	float4x4 World = Input.World;
#endif

	float3 Pos = mul(float4(Input.Pos, 1), World);

	VS_OUTPUT Out;
	Out.Pos = mul(float4(Pos, 1), ViewProj);
	Out.Diff = Pos - CamPos;//((Pos - CamPos) - ShadowCenter) * InvShadowExtents;
	
#ifdef ALPHA
	Out.Tex0 = Input.Tex0;
#endif
	return Out;
}