sampler2D Tex0;

//#define ALPHA

float ZNear;
float InvZRange;

struct PS_INPUT{
	float3 Diff			: TEXCOORD0;
	
#ifdef ALPHA
	float2 Tex0			: TEXCOORD1;
#endif
};

struct PS_OUTPUT{
	float4 Color			: COLOR;
};

#include "dcOutputPos.HLSL"

PS_OUTPUT main(const PS_INPUT Input){
	float3 Diff = Input.Diff;
	Diff += normalize(Diff) * 0.2f;
	
	float4 Result = float4(Diff, 1);
	
#ifdef ALPHA
	Result.a = tex2D(Tex0, Input.Tex0).a;
#endif

	PS_OUTPUT Out;
	Out.Color = Result;
	return Out;
}
