#ifndef __DCCUBENORMALIZE_INCLUDED__
#define __DCCUBENORMALIZE_INCLUDED__

#if !defined(PS14) || defined(PS11)

float3 Normalize(float3 Vector){
	return normalize(Vector);
}

float Length(float3 Vector){
	return length(Vector);
}

#else

samplerCUBE NormalizeMapSigned;

float3 Normalize(float3 Vector){
	return (texCUBE(NormalizeMapSigned, Vector) - 0.5f) * 2;
}

sampler1D SqrtTex;

float Length(float3 Vector){
	float LengthSq = dot(Vector, Vector);
	return tex1D(SqrtTex, LengthSq / 2048).x;
}
	
	

#endif

#endif	//__DCCUBENORMALIZE_INCLUDED__