sampler2D RenderTex;
sampler2D PosTex;
sampler2D Tex0;

struct PS_INPUT{
	float2 Tex				: TEXCOORD0;
};

struct PS_OUTPUT{
	float4 Color			: COLOR0;
};

PS_OUTPUT main(const PS_INPUT Input){
	// Texture lookups
	float4 Render = tex2D(RenderTex, Input.Tex);
	float4 Blur = tex2D(Tex0, Input.Tex / 4);
	
	float Depth = tex2D(PosTex, Input.Tex);
	
	float BlendStart = 300;
	float BlendRange = 1700;
	
	float Blend;
	if (Depth > BlendStart){
		Blend = lerp(0, 1, clamp((Depth - BlendStart) / BlendRange, 0, 1));
	}
	else{
		Blend = 0;
	}
		
	// Output
	PS_OUTPUT Out;
	Out.Color = lerp(Render, Blur, pow(Blend, 10));
	
	return Out;
}
