#define COMPILE_TARGET vs_1_1

// transformations
float4x4 AlphaLightMatrix;

float3 LightDir;
float3 LightColor;

struct VS_OUTPUT{
    float4 Pos				: POSITION;
    float4 LightDir			: COLOR0;
    float4 LightColor		: COLOR1;

	float2 Tex0				: TEXCOORD0;
	float2 Tex1				: TEXCOORD1;
};

struct VS_INPUT{
    float3 Pos				: POSITION;
};

VS_OUTPUT main(const VS_INPUT Input){
	float2 Tex = mul(float4(Input.Pos, 1), AlphaLightMatrix);
	
	VS_OUTPUT Out;
    Out.Pos = float4(Input.Pos, 1);
    Out.LightDir = float4((LightDir + 1) / 2, 0);
    Out.LightColor = float4(LightColor, 1);
	Out.Tex0 = Tex;
	Out.Tex1 = Tex;
	return Out;
}
