#include "dcVShaderConstants.HLSL"

#include "dcOutputPos.HLSL"

float ArrowDirection;
float ArrowOffset;

struct VS_OUTPUT{
    float4 Pos				: POSITION;
    
	float2 Tex              : TEXCOORD0;
	dcNormalData(Normal, TEXCOORD1);
};

struct VS_INPUT{
    float3 Pos              : POSITION;
    float3 Normal           : NORMAL;
    float2 Tex              : TEXCOORD0;
    
#ifdef INSTANCED
	float4x4 World			: TEXCOORD1;
#endif
};

VS_OUTPUT main(const VS_INPUT Input){
#ifdef INSTANCED
	float4x4 World = Input.World;
#endif
	
	float3 Pos = mul(float4(Input.Pos, 1), World);
	float3 Normal = mul(Input.Normal, (float3x3)World);
	
	VS_OUTPUT Out;
    Out.Pos = mul(float4(Pos, 1), ViewProj);
	Out.Tex = Input.Tex;
	Out.Tex.x *= ArrowDirection;
	//Out.Tex.x += ArrowOffset;

	
#ifndef DOUBLESIDED
	OutputNormalData(Normal);
#else
	OutputNormalData(normalize(CamPos - Pos));
#endif
	OutputPosData(Pos);

    return Out;
}