#include "dcVShaderConstants.HLSL"
#include "dcDirtMap.HLSL"

#define NORMALCOLOR1
#include "dcOutputPos.HLSL"

struct VS_OUTPUT{
    float4 Pos				: POSITION;
    
    float4 DirtIntensity	: COLOR0;
    
	float2 Tex              : TEXCOORD0;
	float2 DirtTex			: TEXCOORD1;
	
	dcNormalData(Normal, TEXCOORD2);
};

struct VS_INPUT{
    float3 Pos              : POSITION;
    float3 Normal           : NORMAL;
    float2 Tex              : TEXCOORD0;
#ifdef INSTANCED
	float4x4 World			: TEXCOORD1;
#endif
};

VS_OUTPUT main(const VS_INPUT Input){
#ifdef INSTANCED
	float4x4 World = Input.World;
#endif

	float3 Pos = mul(float4(Input.Pos, 1), World);
	float3 Normal = mul(Input.Normal, (float3x3)World);
	
	VS_OUTPUT Out;
    Out.Pos = mul(float4(Pos, 1), ViewProj);
	Out.Tex = Input.Tex;
	Out.DirtTex = ComputeDirtMap(Pos);
	Out.DirtIntensity.rgb = clamp(abs(Normal.y) / 0.4f, 0, 1);
	Out.DirtIntensity.a = 1;

	OutputNormalData(Normal);
	OutputPosData(Pos);
	
    return Out;
}