sampler2D Tex0;
sampler2D Tex1;
sampler2D Tex7;
sampler2D Tex10;

#define NORMALCOLOR1
#include "dcOutputPos.HLSL"

float3 ReflectionColor;
float4 ColorMult;

struct PS_INPUT{
	float4 DirtIntensity	: COLOR0;
	
    float2 Tex              : TEXCOORD0;
	float2 DirtTex			: TEXCOORD1;

	dcNormalData(Normal, TEXCOORD2);
};

#include "dcMRT.HLSL"

PS_OUTPUT main(const PS_INPUT Input){
	float4 BaseTexColor = tex2D(Tex0, Input.Tex);
	float4 ShininessMap = tex2D(Tex1, Input.Tex);
	
	float4 DirtTexColor = float4(lerp(0.5f, tex2D(Tex10, Input.DirtTex).rgb, Input.DirtIntensity), 0.5f);

	float4 Result = (BaseTexColor + DirtTexColor) - 0.5f;

#ifdef HQ_POSNORMAL
	float3 Normal = (tex2D(Tex7, Input.Tex) - 0.5f) * 2;
#else
	float3 Normal = tex2D(Tex7, Input.Tex);
#endif
	
	PS_OUTPUT Out;
	OutputColor(Result * ColorMult);
	OutputNormalEx(Normal, Input.Normal);
	OutputMaterial(ShininessMap * float4(ReflectionColor, 1));

	return Out;
}
