sampler2D Tex0;
sampler2D Tex1;
float4 ColorMult;

#include "dcOutputPos.HLSL"

struct PS_INPUT{
    float2 Tex				: TEXCOORD0;
	dcNormalData(Normal, TEXCOORD1);
};

#include "dcMRT.HLSL"

PS_OUTPUT main(const PS_INPUT Input){
	float4 Result = tex2D(Tex0, Input.Tex);
	float4 ShininessMap = tex2D(Tex1, Input.Tex);
	
	PS_OUTPUT Out;
	OutputColor(Result * ColorMult);
	OutputNormal(Input.Normal);
	OutputMaterial(ShininessMap);
	
	return Out;
}
