sampler2D Tex0;
sampler2D Tex1;
float4 ColorMult;

//#define RT_COLOR
//#define REFALPHA 0.5

#include "dcOutputPos.HLSL"

struct PS_INPUT{
    float2 Tex				: TEXCOORD0;
	dcNormalData(Normal, TEXCOORD1);
};

#include "dcMRT.HLSL"

PS_OUTPUT main(const PS_INPUT Input){
	float4 Result = tex2D(Tex0, Input.Tex);
	float4 ShininessMap = tex2D(Tex1, Input.Tex);
	
#ifdef REFALPHA
	if (Result.a < REFALPHA){
		clip(-1);
	}
	Result.a = 1;
#endif
	
	PS_OUTPUT Out;
	OutputColor(Result * ColorMult);
	OutputNormal(Input.Normal);
	OutputMaterial(0);
	
	return Out;
}
