sampler2D AdTex;
sampler2D Tex1;
float4 ColorMult;

//#define RT_COLOR
//#define REFALPHA 0.5

#include "dcOutputPos.HLSL"

struct PS_INPUT{
    float2 Tex				: TEXCOORD0;
	dcNormalData(Normal, TEXCOORD1);
};

#include "dcMRT.HLSL"

PS_OUTPUT main(const PS_INPUT Input){
	float4 Src = tex2D(AdTex, Input.Tex);
	float4 Overlay = tex2D(Tex1, Input.Tex);
	
	float4 Blend = step(Src, float4(0.5f, 0.5f, 0.5f, 0.5f));
	
	float4 Bigger = 1.0f - (1.0f - 2 * (Src - 0.5f)) * (1.0f - Overlay);
	float4 Smaller = (2 * Src) * Overlay;
	
	float4 Result = lerp(Bigger, Smaller, Blend);


#ifdef REFALPHA
	if (Result.a < REFALPHA){
		clip(-1);
	}
	Result.a = 1;
#endif
	
	PS_OUTPUT Out;
	OutputColor(Result * ColorMult);
	OutputNormal(Input.Normal);
	OutputMaterial(0);
	
	return Out;
}
