sampler2D Tex0;
sampler2D Tex1;
sampler2D Tex7;
sampler2D Tex10;
float4 ColorMult;

#define NORMALCOLOR1
#include "dcOutputPos.HLSL"

struct PS_INPUT{
	float4 DirtIntensity	: COLOR0;
    
    float2 Tex              : TEXCOORD0;
	float2 DirtTex			: TEXCOORD1;
	dcNormalData(Normal, TEXCOORD2);
};

#include "dcMRT.HLSL"

PS_OUTPUT main(const PS_INPUT Input){
	float4 BaseTexColor = tex2D(Tex0, Input.Tex);
	float4 ShininessMap = tex2D(Tex1, Input.Tex);
	
	float4 DirtTexColor = float4(lerp(0.5f, tex2D(Tex10, Input.DirtTex).rgb, Input.DirtIntensity), 0.5f);

	float4 Result = (BaseTexColor + DirtTexColor) - 0.5f;

	PS_OUTPUT Out;
	OutputColor(Result * ColorMult);
	OutputNormal(Input.Normal);
	OutputMaterial(0);
	return Out;
}
