#define COMPILE_TARGET vs_1_1

// transformations
float4x4 AlphaLightMatrix;

float4x4 InvViewProj;

float3 CamPos;

float2 TexScale;

struct VS_OUTPUT{
    float4 Pos				: POSITION;

	float2 Tex				: TEXCOORD0;
	float4 Matrix0			: TEXCOORD1;
	float4 Matrix1			: TEXCOORD2;
	float4 Matrix2			: TEXCOORD3;
};

struct VS_INPUT{
    float3 Pos				: POSITION;
};

float3 GetVirtualPos(float2 ScreenPos){
	float Depth = 0.5f;

	float4 Pos;
	Pos.xy = ScreenPos;
	Pos.z = Depth;
	Pos.w = 1;
	
	Pos = mul(Pos, InvViewProj);
	return Pos.xyz / Pos.w;
}

VS_OUTPUT main(const VS_INPUT Input){
	float2 Tex = mul(float4(Input.Pos, 1), AlphaLightMatrix) * TexScale;
	
	VS_OUTPUT Out;
    Out.Pos = float4(Input.Pos, 1);
	Out.Tex = Tex;

	float3 VirtualPos = GetVirtualPos(Out.Pos.xy);
	 
	float3 ViewDir = CamPos - VirtualPos;
	
	Out.Matrix0 = float4(1, 0, 0, ViewDir.x);
	Out.Matrix1 = float4(0, 1, 0, ViewDir.y);
	Out.Matrix2 = float4(0, 0, 1, ViewDir.z);
	return Out;
}
