#define COMPILE_TARGET ps_1_1

sampler2D NormalTex;
sampler2D MaterialTex;

samplerCUBE ReflectionTex;
samplerCUBE RealtimeReflectionTex;

struct PS_INPUT{
	float2 Tex				: TEXCOORD0;
	
	float4x3 Matrix			: TEXCOORD1;
};

struct PS_OUTPUT{
    float4 Color			: COLOR;
};

PS_OUTPUT main(const PS_INPUT Input){
	float3 N = (tex2D(NormalTex, Input.Tex) - 0.5f) * 2.0f;
    N = mul(N, Input.Matrix);
    
    float3 V = float3(Input.Matrix[3][0], Input.Matrix[3][1], Input.Matrix[3][2]);
	float3 R = (2 * dot(N, V) / dot(N, N)) * N - V;
	
	float3 Reflection = texCUBE(RealtimeReflectionTex, R);
	    
	PS_OUTPUT Out;
	Out.Color.rgb = Reflection;
	Out.Color.a = 1.0f;
	return Out;
}
