// transformations
float4x4 ViewProj;
float4x4 AlphaLightMatrix;
float4x4 InvViewProj;

float3 CamPos;

float2 TexScale;

float4x4 World;
float4 ShadowTransform;

struct VS_OUTPUT{
    float4 Pos				: POSITION;
#ifdef PROJECTED
	float4 Tex				: TEXCOORD0;
#else
	float2 Tex				: TEXCOORD0;
#endif
	float3 ViewDir			: TEXCOORD1;
};

struct VS_INPUT{
    float3 Pos				: POSITION;
};

float3 GetVirtualPos(float2 ScreenPos){
	float Depth = 0.5f;

	float4 Pos;
	Pos.xy = ScreenPos;
	Pos.z = Depth;
	Pos.w = 1;
	
	Pos = mul(Pos, InvViewProj);
	return Pos.xyz / Pos.w;
}

VS_OUTPUT main(const VS_INPUT Input){
#ifdef PROJECTED
	float3 Pos = Input.Pos * ShadowTransform.xyz;
	Pos.z += ShadowTransform.w;
	
	Pos = mul(float4(Pos, 1), World);
	
	VS_OUTPUT Out;
    Out.Pos = mul(float4(Pos, 1), ViewProj);
#else
	VS_OUTPUT Out;
    Out.Pos = float4(Input.Pos, 1);
	
#endif
	Out.Tex = mul(Out.Pos, AlphaLightMatrix);
	
#ifdef PROJECTED
	float3 VirtualPos = Pos;
#else
	float3 VirtualPos = GetVirtualPos(Out.Pos.xy);
#endif
    Out.ViewDir = VirtualPos - CamPos;
    Out.Tex *= float4(TexScale, 1, 1);

	return Out;
}